/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.splitread;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.paimon.KeyValue;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.compact.ConcatRecordReader;
import org.apache.paimon.operation.MergeFileSplitRead;
import org.apache.paimon.operation.ReverseReader;
import org.apache.paimon.operation.SplitRead;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.table.source.DataSplit;
import org.apache.paimon.table.source.KeyValueTableRead;
import org.apache.paimon.table.source.splitread.SplitReadProvider;
import org.apache.paimon.utils.IOFunction;
import org.apache.paimon.utils.LazyField;

public class IncrementalChangelogReadProvider
implements SplitReadProvider {
    private final LazyField<SplitRead<InternalRow>> splitRead = new LazyField<SplitRead>(() -> {
        SplitRead<InternalRow> read = this.create(supplier);
        valuesAssigner.accept(read);
        return read;
    });

    public IncrementalChangelogReadProvider(Supplier<MergeFileSplitRead> supplier, Consumer<SplitRead<InternalRow>> valuesAssigner) {
    }

    private SplitRead<InternalRow> create(Supplier<MergeFileSplitRead> supplier) {
        MergeFileSplitRead read = supplier.get().withKeyProjection(new int[0][]);
        IOFunction convertedFactory = split -> {
            RecordReader<KeyValue> reader = ConcatRecordReader.create(() -> new ReverseReader(read.createNoMergeReader(split.partition(), split.bucket(), split.beforeFiles(), split.beforeDeletionFiles().orElse(null), true)), () -> read.createNoMergeReader(split.partition(), split.bucket(), split.dataFiles(), split.deletionFiles().orElse(null), true));
            return KeyValueTableRead.unwrap(reader);
        };
        return SplitRead.convert(read, convertedFactory);
    }

    @Override
    public boolean match(DataSplit split, boolean forceKeepDelete) {
        return !split.beforeFiles().isEmpty() && split.isStreaming();
    }

    @Override
    public boolean initialized() {
        return this.splitRead.initialized();
    }

    @Override
    public SplitRead<InternalRow> getOrCreate() {
        return this.splitRead.get();
    }
}

