/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.safe.SafeBinaryRow;
import org.apache.paimon.data.serializer.InternalRowSerializer;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.io.DataInputView;
import org.apache.paimon.io.DataOutputView;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.utils.InternalRowUtils;
import org.apache.paimon.utils.SerializationUtils;

public class DataFileMetaSafeSerializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final InternalRowSerializer rowSerializer = InternalSerializers.create(DataFileMeta.schema());

    public final void serializeList(List<DataFileMeta> records, DataOutputView target) throws IOException {
        target.writeInt(records.size());
        for (DataFileMeta t : records) {
            this.serialize(t, target);
        }
    }

    private void serialize(DataFileMeta meta, DataOutputView target) throws IOException {
        GenericRow row = GenericRow.of(BinaryString.fromString(meta.fileName()), meta.fileSize(), meta.rowCount(), SerializationUtils.serializeBinaryRow(meta.minKey()), SerializationUtils.serializeBinaryRow(meta.maxKey()), meta.keyStats().toRow(), meta.valueStats().toRow(), meta.minSequenceNumber(), meta.maxSequenceNumber(), meta.schemaId(), meta.level(), InternalRowUtils.toStringArrayData(meta.extraFiles()), meta.creationTime(), meta.deleteRowCount().orElse(null), meta.embeddedIndex());
        this.rowSerializer.serialize(row, target);
    }

    public final List<DataFileMeta> deserializeList(DataInputView source) throws IOException {
        int size = source.readInt();
        ArrayList<DataFileMeta> records = new ArrayList<DataFileMeta>(size);
        for (int i = 0; i < size; ++i) {
            records.add(this.deserialize(source));
        }
        return records;
    }

    private DataFileMeta deserialize(DataInputView in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        SafeBinaryRow row = new SafeBinaryRow(this.rowSerializer.getArity(), bytes, 0);
        return new DataFileMeta(row.getString(0).toString(), row.getLong(1), row.getLong(2), SerializationUtils.deserializeBinaryRow(row.getBinary(3)), SerializationUtils.deserializeBinaryRow(row.getBinary(4)), BinaryTableStats.fromRow(row.getRow(5, 3)), BinaryTableStats.fromRow(row.getRow(6, 3)), row.getLong(7), row.getLong(8), row.getLong(9), row.getInt(10), InternalRowUtils.fromStringArrayData(row.getArray(11)), row.getTimestamp(12, 3), row.isNullAt(13) ? null : Long.valueOf(row.getLong(13)), row.isNullAt(14) ? null : row.getBinary(14));
    }
}

