/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.operation.AbstractFileStoreScan;
import org.apache.paimon.operation.ScanBucketFilter;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.schema.KeyValueFieldsExtractor;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.stats.BinaryTableStats;
import org.apache.paimon.stats.FieldStatsArraySerializer;
import org.apache.paimon.stats.FieldStatsConverters;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final FieldStatsConverters fieldKeyStatsConverters;
    private final FieldStatsConverters fieldValueStatsConverters;
    private Predicate keyFilter;
    private Predicate valueFilter;
    private final boolean deletionVectorsEnabled;
    private final CoreOptions.MergeEngine mergeEngine;

    public KeyValueFileStoreScan(RowType partitionType, ScanBucketFilter bucketFilter, SnapshotManager snapshotManager, SchemaManager schemaManager, TableSchema schema, KeyValueFieldsExtractor keyValueFieldsExtractor, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets, Integer scanManifestParallelism, String branchName, boolean deletionVectorsEnabled, CoreOptions.MergeEngine mergeEngine) {
        super(partitionType, bucketFilter, snapshotManager, schemaManager, schema, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets, scanManifestParallelism, branchName);
        this.fieldKeyStatsConverters = new FieldStatsConverters(sid -> keyValueFieldsExtractor.keyFields(this.scanTableSchema((long)sid)), schema.id());
        this.fieldValueStatsConverters = new FieldStatsConverters(sid -> keyValueFieldsExtractor.valueFields(this.scanTableSchema((long)sid)), schema.id());
        this.deletionVectorsEnabled = deletionVectorsEnabled;
        this.mergeEngine = mergeEngine;
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        this.bucketKeyFilter.pushdown(predicate);
        return this;
    }

    public KeyValueFileStoreScan withValueFilter(Predicate predicate) {
        this.valueFilter = predicate;
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        Predicate filter = null;
        FieldStatsArraySerializer serializer = null;
        BinaryTableStats stats = null;
        if ((this.deletionVectorsEnabled || this.mergeEngine == CoreOptions.MergeEngine.FIRST_ROW) && entry.level() > 0 && this.valueFilter != null) {
            filter = this.valueFilter;
            serializer = this.fieldValueStatsConverters.getOrCreate(entry.file().schemaId());
            stats = entry.file().valueStats();
        }
        if (filter == null && this.keyFilter != null) {
            filter = this.keyFilter;
            serializer = this.fieldKeyStatsConverters.getOrCreate(entry.file().schemaId());
            stats = entry.file().keyStats();
        }
        if (filter == null) {
            return true;
        }
        return filter.test(entry.file().rowCount(), serializer.evolution(stats.minValues()), serializer.evolution(stats.maxValues()), serializer.evolution(stats.nullCounts(), entry.file().rowCount()));
    }

    @Override
    protected List<ManifestEntry> filterWholeBucketByStats(List<ManifestEntry> entries) {
        if (this.valueFilter == null) {
            return entries;
        }
        return KeyValueFileStoreScan.noOverlapping(entries) ? this.filterWholeBucketPerFile(entries) : this.filterWholeBucketAllFiles(entries);
    }

    private List<ManifestEntry> filterWholeBucketPerFile(List<ManifestEntry> entries) {
        ArrayList<ManifestEntry> filtered = new ArrayList<ManifestEntry>();
        for (ManifestEntry entry : entries) {
            if (!this.filterByValueFilter(entry)) continue;
            filtered.add(entry);
        }
        return filtered;
    }

    private List<ManifestEntry> filterWholeBucketAllFiles(List<ManifestEntry> entries) {
        for (ManifestEntry entry : entries) {
            if (!this.filterByValueFilter(entry)) continue;
            return entries;
        }
        return Collections.emptyList();
    }

    private boolean filterByValueFilter(ManifestEntry entry) {
        FieldStatsArraySerializer serializer = this.fieldValueStatsConverters.getOrCreate(entry.file().schemaId());
        BinaryTableStats stats = entry.file().valueStats();
        return this.valueFilter.test(entry.file().rowCount(), serializer.evolution(stats.minValues()), serializer.evolution(stats.maxValues()), serializer.evolution(stats.nullCounts(), entry.file().rowCount()));
    }

    private static boolean noOverlapping(List<ManifestEntry> entries) {
        if (entries.size() <= 1) {
            return true;
        }
        Integer previousLevel = null;
        for (ManifestEntry entry : entries) {
            int level = entry.file().level();
            if (level == 0) {
                return false;
            }
            if (previousLevel == null) {
                previousLevel = level;
                continue;
            }
            if (previousLevel == level) continue;
            return false;
        }
        return true;
    }
}

