/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.FileEntry;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;

public class SimpleFileEntry
implements FileEntry {
    private final FileKind kind;
    private final BinaryRow partition;
    private final int bucket;
    private final int level;
    private final String fileName;
    private final BinaryRow minKey;
    private final BinaryRow maxKey;

    public SimpleFileEntry(FileKind kind, BinaryRow partition, int bucket, int level, String fileName, BinaryRow minKey, BinaryRow maxKey) {
        this.kind = kind;
        this.partition = partition;
        this.bucket = bucket;
        this.level = level;
        this.fileName = fileName;
        this.minKey = minKey;
        this.maxKey = maxKey;
    }

    public static SimpleFileEntry from(ManifestEntry entry) {
        return new SimpleFileEntry(entry.kind(), entry.partition(), entry.bucket(), entry.level(), entry.fileName(), entry.minKey(), entry.maxKey());
    }

    public static List<SimpleFileEntry> from(List<ManifestEntry> entries) {
        return entries.stream().map(SimpleFileEntry::from).collect(Collectors.toList());
    }

    @Override
    public FileKind kind() {
        return this.kind;
    }

    @Override
    public BinaryRow partition() {
        return this.partition;
    }

    @Override
    public int bucket() {
        return this.bucket;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public String fileName() {
        return this.fileName;
    }

    @Override
    public FileEntry.Identifier identifier() {
        return new FileEntry.Identifier(this.partition, this.bucket, this.level, this.fileName);
    }

    @Override
    public BinaryRow minKey() {
        return this.minKey;
    }

    @Override
    public BinaryRow maxKey() {
        return this.maxKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleFileEntry that = (SimpleFileEntry)o;
        return this.bucket == that.bucket && this.level == that.level && this.kind == that.kind && Objects.equals(this.partition, that.partition) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.minKey, that.minKey) && Objects.equals(this.maxKey, that.maxKey);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.partition, this.bucket, this.level, this.fileName, this.minKey, this.maxKey});
    }

    public String toString() {
        return "{kind=" + (Object)((Object)this.kind) + ", partition=" + this.partition + ", bucket=" + this.bucket + ", level=" + this.level + ", fileName='" + this.fileName + '\'' + ", minKey=" + this.minKey + ", maxKey=" + this.maxKey + '}';
    }
}

