/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.graph;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableGraph;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozone.graph.Edge;
import org.apache.ozone.rocksdiff.CompactionNode;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphXAdapter;
import org.jgrapht.graph.DefaultDirectedGraph;

public class PrintableGraph {
    private final Graph<String, Edge> graph;

    public PrintableGraph(MutableGraph<CompactionNode> guavaGraph, GraphType graphType) {
        this.graph = this.getGraph(guavaGraph, graphType);
    }

    public void generateImage(String fileName) throws IOException {
        if (CollectionUtils.isEmpty((Collection)this.graph.vertexSet())) {
            throw new IOException("Graph is empty.");
        }
        JGraphXAdapter jGraphXAdapter = new JGraphXAdapter(this.graph);
        mxHierarchicalLayout mxIGraphLayout2 = new mxHierarchicalLayout((mxGraph)jGraphXAdapter);
        mxIGraphLayout2.execute(jGraphXAdapter.getDefaultParent());
        BufferedImage bufferedImage = mxCellRenderer.createBufferedImage((mxGraph)jGraphXAdapter, null, (double)2.0, (Color)Color.WHITE, (boolean)true, null);
        File newFIle = new File(fileName);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", newFIle);
    }

    public Graph<String, Edge> getGraph(MutableGraph<CompactionNode> guavaGraph, GraphType graphType) {
        DefaultDirectedGraph jgrapht = new DefaultDirectedGraph(Edge.class);
        for (CompactionNode node : guavaGraph.nodes()) {
            jgrapht.addVertex((Object)this.getVertex(node, graphType));
        }
        for (EndpointPair edge : guavaGraph.edges()) {
            jgrapht.addEdge((Object)this.getVertex((CompactionNode)edge.source(), graphType), (Object)this.getVertex((CompactionNode)edge.target(), graphType));
        }
        return jgrapht;
    }

    private String getVertex(CompactionNode node, GraphType graphType) {
        switch (graphType) {
            case KEY_SIZE: {
                return node.getFileName() + "::" + node.getTotalNumberOfKeys();
            }
            case CUMULATIVE_SIZE: {
                return node.getFileName() + "::" + node.getCumulativeKeysReverseTraversal();
            }
        }
        return node.getFileName();
    }

    public static enum GraphType {
        FILE_NAME,
        KEY_SIZE,
        CUMULATIVE_SIZE;

    }
}

