/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import java.time.Instant;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public class OzoneKey {
    private final String volumeName;
    private final String bucketName;
    private final String name;
    private final long dataSize;
    private Instant creationTime;
    private Instant modificationTime;
    private ReplicationConfig replicationConfig;

    @Deprecated
    public OzoneKey(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, ReplicationType type, int replicationFactor) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.name = keyName;
        this.dataSize = size;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
        this.replicationConfig = ReplicationConfig.fromTypeAndFactor((ReplicationType)type, (ReplicationFactor)ReplicationFactor.valueOf((int)replicationFactor));
    }

    public OzoneKey(String volumeName, String bucketName, String keyName, long size, long creationTime, long modificationTime, ReplicationConfig replicationConfig) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.name = keyName;
        this.dataSize = size;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
        this.replicationConfig = replicationConfig;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getName() {
        return this.name;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    @Deprecated
    public ReplicationType getReplicationType() {
        return ReplicationType.fromProto((HddsProtos.ReplicationType)this.replicationConfig.getReplicationType());
    }

    @Deprecated
    public int getReplicationFactor() {
        return this.replicationConfig.getRequiredNodes();
    }

    public ReplicationConfig getReplicationConfig() {
        return this.replicationConfig;
    }
}

