/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.EnumMap;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.hdds.upgrade.test.MockComponent;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestUpgradeFinalizerActions {
    @Test
    public void testRunPrefinalizeStateActions(@TempDir File file) throws IOException {
        MockLayoutFeature.VERSION_2.addAction(LayoutFeature.UpgradeActionType.VALIDATE_IN_PREFINALIZE, (LayoutFeature.UpgradeAction)new MockComponent.MockScmUpgradeAction());
        MockLayoutFeature.VERSION_3.addAction(LayoutFeature.UpgradeActionType.ON_FIRST_UPGRADE_START, (LayoutFeature.UpgradeAction)new MockComponent.MockDnUpgradeAction());
        MockLayoutVersionManager lvm = new MockLayoutVersionManager(1);
        MockUpgradeFinalizer uF = new MockUpgradeFinalizer(lvm);
        MockComponent mockObj = (MockComponent)Mockito.mock(MockComponent.class);
        File scmCurrent = Paths.get(file.toString(), "scm", "current").toFile();
        Assertions.assertTrue((boolean)scmCurrent.mkdirs());
        Storage storage = this.newStorage(file);
        uF.runPrefinalizeStateActions(storage, mockObj);
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)1))).mockMethodScm();
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)1))).mockMethodDn();
        uF.runPrefinalizeStateActions(storage, mockObj);
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)2))).mockMethodScm();
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)1))).mockMethodDn();
        lvm.finalized(MockLayoutFeature.VERSION_2);
        lvm.finalized(MockLayoutFeature.VERSION_3);
        uF.runPrefinalizeStateActions(storage, mockObj);
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)2))).mockMethodScm();
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)1))).mockMethodDn();
    }

    @Test
    public void testValidationFailureWorks(@TempDir File file) throws Exception {
        MockLayoutFeature.VERSION_2.addAction(LayoutFeature.UpgradeActionType.VALIDATE_IN_PREFINALIZE, (LayoutFeature.UpgradeAction)new MockFailingUpgradeAction());
        MockLayoutVersionManager lvm = new MockLayoutVersionManager(1);
        MockUpgradeFinalizer uF = new MockUpgradeFinalizer(lvm);
        MockComponent mockObj = (MockComponent)Mockito.mock(MockComponent.class);
        File scmCurrent = Paths.get(file.toString(), "scm", "current").toFile();
        Assertions.assertTrue((boolean)scmCurrent.mkdirs());
        Storage storage = this.newStorage(file);
        UpgradeException upgradeException = (UpgradeException)Assertions.assertThrows(UpgradeException.class, () -> uF.runPrefinalizeStateActions(storage, mockObj));
        Assertions.assertTrue((boolean)upgradeException.getMessage().contains("Exception while running pre finalize state validation"));
    }

    private Storage newStorage(File f) throws IOException {
        return new Storage(HddsProtos.NodeType.SCM, f, "scm", 1){

            protected Properties getNodeProperties() {
                return new Properties();
            }
        };
    }

    public static class MockFailingUpgradeAction
    implements HDDSUpgradeAction<MockComponent> {
        public void execute(MockComponent arg) throws Exception {
            throw new IllegalStateException("Failed action!!");
        }
    }

    static enum MockLayoutFeature implements LayoutFeature
    {
        VERSION_1(1),
        VERSION_2(2),
        VERSION_3(3);

        private int layoutVersion;
        private EnumMap<LayoutFeature.UpgradeActionType, LayoutFeature.UpgradeAction> actions = new EnumMap(LayoutFeature.UpgradeActionType.class);

        private MockLayoutFeature(int layoutVersion) {
            this.layoutVersion = layoutVersion;
        }

        public int layoutVersion() {
            return this.layoutVersion;
        }

        public String description() {
            return null;
        }

        public void addAction(LayoutFeature.UpgradeActionType type, LayoutFeature.UpgradeAction action) {
            this.actions.put(type, action);
        }

        public Optional<? extends LayoutFeature.UpgradeAction> action(LayoutFeature.UpgradeActionType phase) {
            return Optional.ofNullable(this.actions.get(phase));
        }
    }

    static class MockLayoutVersionManager
    extends AbstractLayoutVersionManager<MockLayoutFeature> {
        MockLayoutVersionManager(int lV) throws IOException {
            this.init(lV, MockLayoutFeature.values());
        }
    }

    static class MockUpgradeFinalizer
    extends BasicUpgradeFinalizer<MockComponent, MockLayoutVersionManager> {
        MockUpgradeFinalizer(MockLayoutVersionManager versionManager) {
            super((AbstractLayoutVersionManager)versionManager);
        }

        public void postFinalizeUpgrade(MockComponent c) {
        }

        public void finalizeLayoutFeature(LayoutFeature lf, MockComponent c) {
        }

        public void preFinalizeUpgrade(MockComponent c) {
        }

        public void runPrefinalizeStateActions(Storage storage, MockComponent mockComponent) throws IOException {
            super.runPrefinalizeStateActions(lf -> ((MockLayoutFeature)((Object)lf))::action, storage, (Object)mockComponent);
        }
    }
}

