/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.DefaultUpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestDefaultUpgradeFinalizationExecutor {
    @Test
    public void testPreFinalizeFailureThrowsException() {
        AbstractLayoutVersionManager mockLvm = (AbstractLayoutVersionManager)Mockito.mock(AbstractLayoutVersionManager.class);
        Mockito.when((Object)mockLvm.needsFinalization()).thenReturn((Object)true);
        BasicUpgradeFinalizer uf = new BasicUpgradeFinalizer(mockLvm){

            protected void preFinalizeUpgrade(Object service) throws IOException {
                throw new IOException("Failure!");
            }

            protected void postFinalizeUpgrade(Object service) {
            }

            public void finalizeLayoutFeature(LayoutFeature layoutFeatture, Object service) {
            }

            public void runPrefinalizeStateActions(Storage storage, Object service) {
            }
        };
        DefaultUpgradeFinalizationExecutor executor = new DefaultUpgradeFinalizationExecutor();
        IOException ioException = (IOException)Assertions.assertThrows(IOException.class, () -> executor.execute(new Object(), uf));
        Assertions.assertEquals((Object)"Failure!", (Object)ioException.getMessage());
    }

    @Test
    public void testPostFinalizeFailureDoesNotThrowException() throws Exception {
        AbstractLayoutVersionManager mockLvm = (AbstractLayoutVersionManager)Mockito.mock(AbstractLayoutVersionManager.class);
        Mockito.when((Object)mockLvm.needsFinalization()).thenReturn((Object)false);
        BasicUpgradeFinalizer uf = new BasicUpgradeFinalizer(mockLvm){

            protected void preFinalizeUpgrade(Object service) {
            }

            protected void postFinalizeUpgrade(Object service) throws IOException {
                throw new IOException("Failure!");
            }

            public void finalizeLayoutFeature(LayoutFeature lf, Object service) {
            }

            public void runPrefinalizeStateActions(Storage storage, Object service) {
            }
        };
        DefaultUpgradeFinalizationExecutor executor = new DefaultUpgradeFinalizationExecutor();
        executor.execute(new Object(), uf);
    }
}

