/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.InjectedUpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.TestUpgradeFinalizerActions;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.UpgradeTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBasicUpgradeFinalizer {
    private static final Logger LOG = LoggerFactory.getLogger(TestBasicUpgradeFinalizer.class);

    @Test
    public void testFinalizerPhasesAreInvokedInOrder() throws IOException {
        SimpleTestFinalizer finalizer = (SimpleTestFinalizer)((Object)Mockito.spy(SimpleTestFinalizer.class));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{finalizer});
        Object mockObj = Mockito.mock(Object.class);
        ((SimpleTestFinalizer)((Object)Mockito.doCallRealMethod().when((Object)finalizer))).finalize(ArgumentMatchers.anyString(), ArgumentMatchers.eq((Object)mockObj));
        finalizer.finalize("test-client-1", mockObj);
        UpgradeFinalizer.StatusAndMessages res = finalizer.reportStatus("test-client-1", false);
        Assertions.assertEquals((Object)UpgradeFinalizer.Status.FINALIZATION_DONE, (Object)res.status());
        ((SimpleTestFinalizer)((Object)inOrder.verify((Object)finalizer))).preFinalizeUpgrade(ArgumentMatchers.eq((Object)mockObj));
        ((SimpleTestFinalizer)((Object)inOrder.verify((Object)finalizer))).finalizeLayoutFeature((LayoutFeature)ArgumentMatchers.eq((Object)((Object)TestUpgradeFinalizerActions.MockLayoutFeature.VERSION_2)), ArgumentMatchers.eq((Object)mockObj));
        ((SimpleTestFinalizer)((Object)inOrder.verify((Object)finalizer))).finalizeLayoutFeature((LayoutFeature)ArgumentMatchers.eq((Object)((Object)TestUpgradeFinalizerActions.MockLayoutFeature.VERSION_3)), ArgumentMatchers.eq((Object)mockObj));
        ((SimpleTestFinalizer)((Object)inOrder.verify((Object)finalizer))).postFinalizeUpgrade(ArgumentMatchers.eq((Object)mockObj));
        Assertions.assertTrue((boolean)finalizer.isFinalizationDone());
        Assertions.assertTrue((finalizer.preCalled && finalizer.finalizeCalled && finalizer.postCalled ? 1 : 0) != 0);
    }

    @Test
    public void testAlreadyFinalizedDoesNotTriggerNewFinalization() throws IOException {
        SimpleTestFinalizer finalizer = new SimpleTestFinalizer(new TestUpgradeFinalizerActions.MockLayoutVersionManager(TestUpgradeFinalizerActions.MockLayoutFeature.VERSION_3.layoutVersion()));
        Object mockObj = Mockito.mock(Object.class);
        UpgradeFinalizer.StatusAndMessages res = finalizer.finalize("test-client-1", mockObj);
        Assertions.assertEquals((Object)UpgradeFinalizer.Status.ALREADY_FINALIZED, (Object)res.status());
        Assertions.assertFalse((finalizer.preCalled || finalizer.finalizeCalled || finalizer.postCalled ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentFinalization() throws Exception {
        CountDownLatch pauseLatch = new CountDownLatch(1);
        CountDownLatch unpauseLatch = new CountDownLatch(1);
        InjectedUpgradeFinalizationExecutor executor = UpgradeTestUtils.newPausingFinalizationExecutor(InjectedUpgradeFinalizationExecutor.UpgradeTestInjectionPoints.AFTER_PRE_FINALIZE_UPGRADE, pauseLatch, unpauseLatch, LOG);
        SimpleTestFinalizer finalizer = new SimpleTestFinalizer(new TestUpgradeFinalizerActions.MockLayoutVersionManager(TestUpgradeFinalizerActions.MockLayoutFeature.VERSION_1.layoutVersion()), (UpgradeFinalizationExecutor<Object>)executor);
        Future<?> firstFinalizeFuture = this.runFinalization(finalizer, UpgradeFinalizer.Status.STARTING_FINALIZATION);
        pauseLatch.await();
        Future<?> secondFinalizeFuture = this.runFinalization(finalizer, UpgradeFinalizer.Status.FINALIZATION_IN_PROGRESS);
        Future<?> finalizeQueryFuture = this.runFinalizationQuery((UpgradeFinalizer<Object>)finalizer, UpgradeFinalizer.Status.FINALIZATION_IN_PROGRESS);
        secondFinalizeFuture.get();
        finalizeQueryFuture.get();
        unpauseLatch.countDown();
        firstFinalizeFuture.get();
        ArrayList finalizeFutures = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            finalizeFutures.add(this.runFinalizationQuery((UpgradeFinalizer<Object>)finalizer, UpgradeFinalizer.Status.FINALIZATION_DONE));
        }
        for (Future future : finalizeFutures) {
            future.get();
        }
    }

    private Future<?> runFinalization(BasicUpgradeFinalizer<Object, TestUpgradeFinalizerActions.MockLayoutVersionManager> finalizer, UpgradeFinalizer.Status expectedStatus) {
        return Executors.newSingleThreadExecutor().submit(() -> {
            try {
                UpgradeFinalizer.StatusAndMessages result = finalizer.finalize("test", new Object());
                Assertions.assertEquals((Object)expectedStatus, (Object)result.status());
            }
            catch (Exception ex) {
                LOG.error("Finalization failed", (Throwable)ex);
                Assertions.fail((String)("Finalization failed with exception: " + ex.getMessage()));
            }
        });
    }

    private Future<?> runFinalizationQuery(UpgradeFinalizer<Object> finalizer, UpgradeFinalizer.Status expectedStatus) {
        return Executors.newSingleThreadExecutor().submit(() -> Assertions.assertEquals((Object)expectedStatus, (Object)finalizer.getStatus()));
    }

    static class SimpleTestFinalizer
    extends BasicUpgradeFinalizer<Object, TestUpgradeFinalizerActions.MockLayoutVersionManager> {
        private boolean preCalled = false;
        private boolean finalizeCalled = false;
        private boolean postCalled = false;

        SimpleTestFinalizer() throws IOException {
            super((AbstractLayoutVersionManager)new TestUpgradeFinalizerActions.MockLayoutVersionManager(TestUpgradeFinalizerActions.MockLayoutFeature.VERSION_1.layoutVersion()));
        }

        SimpleTestFinalizer(TestUpgradeFinalizerActions.MockLayoutVersionManager lvm) {
            super((AbstractLayoutVersionManager)lvm);
        }

        SimpleTestFinalizer(TestUpgradeFinalizerActions.MockLayoutVersionManager lvm, UpgradeFinalizationExecutor<Object> executor) {
            super((AbstractLayoutVersionManager)lvm, executor);
        }

        protected void preFinalizeUpgrade(Object service) throws IOException {
            super.preFinalizeUpgrade(service);
            this.preCalled = true;
        }

        protected void postFinalizeUpgrade(Object service) throws IOException {
            super.postFinalizeUpgrade(service);
            this.postCalled = true;
        }

        public void finalizeLayoutFeature(LayoutFeature lf, Object service) throws UpgradeException {
            Storage mockStorage = (Storage)Mockito.mock(Storage.class);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockStorage});
            super.finalizeLayoutFeature(lf, lf.action(LayoutFeature.UpgradeActionType.ON_FINALIZE), mockStorage);
            ((Storage)inOrder.verify((Object)mockStorage)).setLayoutVersion(ArgumentMatchers.eq((int)lf.layoutVersion()));
            try {
                ((Storage)inOrder.verify((Object)mockStorage)).persistCurrentState();
            }
            catch (IOException ex) {
                throw new UpgradeException((Throwable)ex, UpgradeException.ResultCodes.LAYOUT_FEATURE_FINALIZATION_FAILED);
            }
            this.finalizeCalled = true;
        }

        public void runPrefinalizeStateActions(Storage storage, Object service) {
        }
    }
}

