/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

public class TestAbstractLayoutVersionManager {
    @Spy
    private AbstractLayoutVersionManager<LayoutFeature> versionManager;

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @AfterEach
    public void close() {
        this.versionManager.close();
    }

    @Test
    public void testInitializationWithFeaturesToBeFinalized() throws Exception {
        this.versionManager.init(1, this.getTestLayoutFeatures(3));
        Assertions.assertEquals((int)3, (int)this.versionManager.features.size());
        Assertions.assertEquals((int)3, (int)this.versionManager.featureMap.size());
        Assertions.assertEquals((int)1, (int)this.versionManager.getMetadataLayoutVersion());
        Assertions.assertEquals((int)3, (int)this.versionManager.getSoftwareLayoutVersion());
        Assertions.assertTrue((boolean)this.versionManager.needsFinalization());
        Iterator it = this.versionManager.unfinalizedFeatures().iterator();
        Assertions.assertNotNull(it.next());
        Assertions.assertNotNull(it.next());
    }

    @Test
    public void testInitializationWithUpToDateMetadataVersion() throws Exception {
        this.versionManager.init(2, this.getTestLayoutFeatures(2));
        Assertions.assertEquals((int)2, (int)this.versionManager.features.size());
        Assertions.assertEquals((int)2, (int)this.versionManager.featureMap.size());
        Assertions.assertEquals((int)2, (int)this.versionManager.getMetadataLayoutVersion());
        Assertions.assertEquals((int)2, (int)this.versionManager.getSoftwareLayoutVersion());
        Assertions.assertFalse((boolean)this.versionManager.needsFinalization());
        Assertions.assertFalse((boolean)this.versionManager.unfinalizedFeatures().iterator().hasNext());
    }

    @Test
    public void testInitFailsIfNotEnoughLayoutFeaturesForVersion() {
        Assertions.assertThrowsExactly(IOException.class, () -> this.versionManager.init(3, this.getTestLayoutFeatures(2)), (String)"Cannot initialize VersionManager.");
    }

    @Test
    public void testFeatureFinalization() throws Exception {
        LayoutFeature[] lfs = this.getTestLayoutFeatures(3);
        this.versionManager.init(1, lfs);
        this.versionManager.finalized(lfs[1]);
        Assertions.assertEquals((int)3, (int)this.versionManager.features.size());
        Assertions.assertEquals((int)3, (int)this.versionManager.featureMap.size());
        Assertions.assertEquals((int)2, (int)this.versionManager.getMetadataLayoutVersion());
        Assertions.assertEquals((int)3, (int)this.versionManager.getSoftwareLayoutVersion());
        Assertions.assertTrue((boolean)this.versionManager.needsFinalization());
        Iterator it = this.versionManager.unfinalizedFeatures().iterator();
        Assertions.assertNotNull(it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testFeatureFinalizationFailsIfTheFinalizedFeatureIsNotTheNext() throws IOException {
        LayoutFeature[] lfs = this.getTestLayoutFeatures(3);
        this.versionManager.init(1, lfs);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.versionManager.finalized(lfs[2]));
    }

    @Test
    public void testFeatureFinalizationIfFeatureIsAlreadyFinalized() throws IOException {
        LayoutFeature[] lfs = this.getTestLayoutFeatures(3);
        this.versionManager.init(2, lfs);
        Assertions.assertEquals((int)2, (int)this.versionManager.getMetadataLayoutVersion());
        this.versionManager.finalized(lfs[0]);
        Assertions.assertEquals((int)2, (int)this.versionManager.getMetadataLayoutVersion());
        this.versionManager.finalized(lfs[1]);
        Assertions.assertEquals((int)2, (int)this.versionManager.getMetadataLayoutVersion());
    }

    @Test
    public void testUnfinalizedFeaturesAreNotAllowed() throws Exception {
        LayoutFeature[] lfs = this.getTestLayoutFeatures(3);
        this.versionManager.init(1, lfs);
        Assertions.assertTrue((boolean)this.versionManager.isAllowed(lfs[0].name()));
        Assertions.assertTrue((boolean)this.versionManager.isAllowed(lfs[0]));
        Assertions.assertFalse((boolean)this.versionManager.isAllowed(lfs[1].name()));
        Assertions.assertFalse((boolean)this.versionManager.isAllowed(lfs[1]));
        Assertions.assertFalse((boolean)this.versionManager.isAllowed(lfs[2].name()));
        Assertions.assertFalse((boolean)this.versionManager.isAllowed(lfs[2]));
        this.versionManager.finalized(lfs[1]);
        Assertions.assertTrue((boolean)this.versionManager.isAllowed(lfs[0].name()));
        Assertions.assertTrue((boolean)this.versionManager.isAllowed(lfs[0]));
        Assertions.assertTrue((boolean)this.versionManager.isAllowed(lfs[1].name()));
        Assertions.assertTrue((boolean)this.versionManager.isAllowed(lfs[1]));
        Assertions.assertFalse((boolean)this.versionManager.isAllowed(lfs[2].name()));
        Assertions.assertFalse((boolean)this.versionManager.isAllowed(lfs[2]));
    }

    @Test
    public void testJmx() throws Exception {
        int numLayoutFeatures = 3;
        boolean metadataLayoutVersion = true;
        this.versionManager.init(1, this.getTestLayoutFeatures(3));
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName bean = new ObjectName("Hadoop:service=LayoutVersionManager,name=" + this.versionManager.getClass().getSimpleName());
        Object mlv = mbs.getAttribute(bean, "MetadataLayoutVersion");
        Assertions.assertEquals((Object)1, (Object)mlv);
        Object slv = mbs.getAttribute(bean, "SoftwareLayoutVersion");
        Assertions.assertEquals((Object)3, (Object)slv);
    }

    private LayoutFeature[] getTestLayoutFeatures(int num) {
        LayoutFeature[] lfs = new LayoutFeature[num];
        int k = 0;
        int i = 1;
        while (i <= num) {
            final int finalI = i++;
            lfs[k++] = new LayoutFeature(){

                public String name() {
                    return "LF-" + finalI;
                }

                public int layoutVersion() {
                    return finalI;
                }

                public String description() {
                    return null;
                }
            };
        }
        return lfs;
    }
}

