/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lock;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.lock.LockManager;
import org.apache.hadoop.util.Daemon;
import org.apache.ozone.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestLockManager {
    @Test
    @Timeout(value=1L)
    public void testWriteLockWithDifferentResource() {
        LockManager manager = new LockManager((ConfigurationSource)new OzoneConfiguration());
        manager.writeLock((Object)"/resourceOne");
        manager.writeLock((Object)"/resourceTwo");
        manager.writeUnlock((Object)"/resourceOne");
        manager.writeUnlock((Object)"/resourceTwo");
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void testWriteLockWithSameResource() throws Exception {
        LockManager manager = new LockManager((ConfigurationSource)new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.writeLock((Object)"/resourceOne");
        new Thread(() -> {
            manager.writeLock((Object)"/resourceOne");
            gotLock.set(true);
            manager.writeUnlock((Object)"/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)gotLock.get());
        manager.writeUnlock((Object)"/resourceOne");
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)gotLock.get());
    }

    @Test
    @Timeout(value=1L)
    public void testReadLockWithDifferentResource() {
        LockManager manager = new LockManager((ConfigurationSource)new OzoneConfiguration());
        manager.readLock((Object)"/resourceOne");
        manager.readLock((Object)"/resourceTwo");
        manager.readUnlock((Object)"/resourceOne");
        manager.readUnlock((Object)"/resourceTwo");
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void testReadLockWithSameResource() throws Exception {
        LockManager manager = new LockManager((ConfigurationSource)new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.readLock((Object)"/resourceOne");
        new Thread(() -> {
            manager.readLock((Object)"/resourceOne");
            gotLock.set(true);
            manager.readUnlock((Object)"/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)gotLock.get());
        manager.readUnlock((Object)"/resourceOne");
    }

    @Test
    public void testWriteReadLockWithSameResource() throws Exception {
        LockManager manager = new LockManager((ConfigurationSource)new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.writeLock((Object)"/resourceOne");
        new Thread(() -> {
            manager.readLock((Object)"/resourceOne");
            gotLock.set(true);
            manager.readUnlock((Object)"/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)gotLock.get());
        manager.writeUnlock((Object)"/resourceOne");
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)gotLock.get());
    }

    @Test
    public void testReadWriteLockWithSameResource() throws Exception {
        LockManager manager = new LockManager((ConfigurationSource)new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.readLock((Object)"/resourceOne");
        new Thread(() -> {
            manager.writeLock((Object)"/resourceOne");
            gotLock.set(true);
            manager.writeUnlock((Object)"/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)gotLock.get());
        manager.readUnlock((Object)"/resourceOne");
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)gotLock.get());
    }

    @Test
    public void testMultiReadWriteLockWithSameResource() throws Exception {
        LockManager manager = new LockManager((ConfigurationSource)new OzoneConfiguration());
        AtomicBoolean gotLock = new AtomicBoolean(false);
        manager.readLock((Object)"/resourceOne");
        manager.readLock((Object)"/resourceOne");
        new Thread(() -> {
            manager.writeLock((Object)"/resourceOne");
            gotLock.set(true);
            manager.writeUnlock((Object)"/resourceOne");
        }).start();
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)gotLock.get());
        manager.readUnlock((Object)"/resourceOne");
        Thread.sleep(100L);
        Assertions.assertFalse((boolean)gotLock.get());
        manager.readUnlock((Object)"/resourceOne");
        Thread.sleep(100L);
        Assertions.assertTrue((boolean)gotLock.get());
    }

    @Test
    public void testConcurrentWriteLockWithDifferentResource() throws Exception {
        OzoneConfiguration conf = new OzoneConfiguration();
        int count = 100;
        LockManager manager = new LockManager((ConfigurationSource)conf);
        int sleep = 10;
        AtomicInteger done = new AtomicInteger();
        for (int i = 0; i < 100; ++i) {
            Integer id = i;
            Daemon d1 = new Daemon(() -> {
                try {
                    manager.writeLock((Object)id);
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    manager.writeUnlock((Object)id);
                }
                done.getAndIncrement();
            });
            d1.setName("Locker-" + i);
            d1.start();
        }
        GenericTestUtils.waitFor(() -> done.get() == 100, (int)100, (int)10000);
        Assertions.assertEquals((int)100, (int)done.get());
    }
}

