/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.pipeline.MockPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.utils.UniqueId;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.common.OzoneChecksumException;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerTestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerTestHelper.class);
    public static final long CONTAINER_MAX_SIZE = (long)StorageUnit.GB.toBytes(1.0);
    public static final String DATANODE_UUID = UUID.randomUUID().toString();
    private static final long DUMMY_CONTAINER_ID = 9999L;

    private ContainerTestHelper() {
    }

    public static ChunkInfo getChunk(long keyID, int seqNo, long offset, long len) {
        return new ChunkInfo(String.format("%d.data.%d", keyID, seqNo), offset, len);
    }

    public static ChunkBuffer getData(int len) {
        byte[] data = new byte[len];
        ThreadLocalRandom.current().nextBytes(data);
        return ChunkBuffer.wrap((ByteBuffer)ByteBuffer.wrap(data));
    }

    public static void setDataChecksum(ChunkInfo info, ChunkBuffer data) throws OzoneChecksumException {
        Checksum checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, 0x100000);
        info.setChecksumData(checksum.computeChecksum(data));
        data.rewind();
    }

    public static ContainerProtos.ContainerCommandRequestProto getWriteChunkRequest(Pipeline pipeline, BlockID blockID, int datalen) throws IOException {
        LOG.trace("writeChunk {} (blockID={}) to pipeline={}", new Object[]{datalen, blockID, pipeline});
        return ContainerTestHelper.newWriteChunkRequestBuilder(pipeline, blockID, datalen).build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getListBlockRequest(ContainerProtos.ContainerCommandRequestProto writeChunkRequest) {
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setContainerID(writeChunkRequest.getContainerID()).setCmdType(ContainerProtos.Type.ListBlock).setDatanodeUuid(writeChunkRequest.getDatanodeUuid()).setListBlock(ContainerProtos.ListBlockRequestProto.newBuilder().setCount(10).build()).build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getPutBlockRequest(ContainerProtos.ContainerCommandRequestProto writeChunkRequest) {
        ContainerProtos.BlockData.Builder block = ContainerProtos.BlockData.newBuilder().setSize(writeChunkRequest.getWriteChunk().getChunkData().getLen()).setBlockID(writeChunkRequest.getWriteChunk().getBlockID()).addChunks(writeChunkRequest.getWriteChunk().getChunkData());
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setContainerID(writeChunkRequest.getContainerID()).setCmdType(ContainerProtos.Type.PutBlock).setDatanodeUuid(writeChunkRequest.getDatanodeUuid()).setPutBlock(ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(block.build()).build()).build();
    }

    public static ContainerProtos.ContainerCommandRequestProto.Builder newWriteChunkRequestBuilder(Pipeline pipeline, BlockID blockID, int datalen) throws IOException {
        ChunkBuffer data = ContainerTestHelper.getData(datalen);
        return ContainerTestHelper.newWriteChunkRequestBuilder(pipeline, blockID, data, 0);
    }

    public static ContainerProtos.ContainerCommandRequestProto.Builder newWriteChunkRequestBuilder(Pipeline pipeline, BlockID blockID, ChunkBuffer data, int seq) throws IOException {
        LOG.trace("writeChunk {} (blockID={}) to pipeline={}", new Object[]{data.limit(), blockID, pipeline});
        ContainerProtos.WriteChunkRequestProto.Builder writeRequest = ContainerProtos.WriteChunkRequestProto.newBuilder();
        writeRequest.setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ChunkInfo info = ContainerTestHelper.getChunk(blockID.getLocalID(), seq, 0L, data.limit());
        ContainerTestHelper.setDataChecksum(info, data);
        writeRequest.setChunkData(info.getProtoBufMessage());
        writeRequest.setData(data.toByteString());
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.WriteChunk);
        request.setContainerID(blockID.getContainerID());
        request.setWriteChunk(writeRequest);
        request.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return request;
    }

    public static ContainerProtos.ContainerCommandRequestProto getWriteSmallFileRequest(Pipeline pipeline, BlockID blockID, int dataLen) throws Exception {
        ContainerProtos.PutSmallFileRequestProto.Builder smallFileRequest = ContainerProtos.PutSmallFileRequestProto.newBuilder();
        ChunkBuffer data = ContainerTestHelper.getData(dataLen);
        ChunkInfo info = ContainerTestHelper.getChunk(blockID.getLocalID(), 0, 0L, dataLen);
        ContainerTestHelper.setDataChecksum(info, data);
        ContainerProtos.PutBlockRequestProto.Builder putRequest = ContainerProtos.PutBlockRequestProto.newBuilder();
        BlockData blockData = new BlockData(blockID);
        LinkedList<ContainerProtos.ChunkInfo> newList = new LinkedList<ContainerProtos.ChunkInfo>();
        newList.add(info.getProtoBufMessage());
        blockData.setChunks(newList);
        putRequest.setBlockData(blockData.getProtoBufMessage());
        smallFileRequest.setChunkInfo(info.getProtoBufMessage());
        smallFileRequest.setData(data.toByteString());
        smallFileRequest.setBlock(putRequest);
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.PutSmallFile);
        request.setContainerID(blockID.getContainerID());
        request.setPutSmallFile(smallFileRequest);
        request.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return request.build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getReadSmallFileRequest(Pipeline pipeline, ContainerProtos.PutBlockRequestProto putKey) throws Exception {
        ContainerProtos.GetSmallFileRequestProto.Builder smallFileRequest = ContainerProtos.GetSmallFileRequestProto.newBuilder();
        ContainerProtos.ContainerCommandRequestProto getKey = ContainerTestHelper.getBlockRequest(pipeline, putKey);
        smallFileRequest.setBlock(getKey.getGetBlock());
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.GetSmallFile);
        request.setContainerID(getKey.getGetBlock().getBlockID().getContainerID());
        request.setGetSmallFile(smallFileRequest);
        request.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return request.build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getReadChunkRequest(Pipeline pipeline, ContainerProtos.WriteChunkRequestProto writeChunk) throws IOException {
        return ContainerTestHelper.newReadChunkRequestBuilder(pipeline, (ContainerProtos.WriteChunkRequestProtoOrBuilder)writeChunk).build();
    }

    public static ContainerProtos.ContainerCommandRequestProto.Builder newReadChunkRequestBuilder(Pipeline pipeline, ContainerProtos.WriteChunkRequestProtoOrBuilder writeChunk) throws IOException {
        LOG.trace("readChunk blockID={} from pipeline={}", (Object)writeChunk.getBlockID(), (Object)pipeline);
        ContainerProtos.ReadChunkRequestProto.Builder readRequest = ContainerProtos.ReadChunkRequestProto.newBuilder();
        readRequest.setBlockID(writeChunk.getBlockID());
        readRequest.setChunkData(writeChunk.getChunkData());
        readRequest.setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1);
        ContainerProtos.ContainerCommandRequestProto.Builder newRequest = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        newRequest.setCmdType(ContainerProtos.Type.ReadChunk);
        newRequest.setContainerID(readRequest.getBlockID().getContainerID());
        newRequest.setReadChunk(readRequest);
        newRequest.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return newRequest;
    }

    public static ContainerProtos.ContainerCommandRequestProto getCreateContainerRequest(long containerID, Pipeline pipeline) throws IOException {
        LOG.trace("addContainer: {}", (Object)containerID);
        return ContainerTestHelper.getContainerCommandRequestBuilder(containerID, pipeline).build();
    }

    private static ContainerProtos.ContainerCommandRequestProto.Builder getContainerCommandRequestBuilder(long containerID, Pipeline pipeline) throws IOException {
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CreateContainer);
        request.setContainerID(containerID);
        request.setCreateContainer(ContainerProtos.CreateContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return request;
    }

    public static ContainerProtos.ContainerCommandRequestProto getCreateContainerSecureRequest(long containerID, Pipeline pipeline, Token<?> token) throws IOException {
        LOG.trace("addContainer: {}", (Object)containerID);
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerTestHelper.getContainerCommandRequestBuilder(containerID, pipeline);
        if (token != null) {
            request.setEncodedToken(token.encodeToUrlString());
        }
        return request.build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getUpdateContainerRequest(long containerID, Map<String, String> metaData) throws IOException {
        String[] keys;
        ContainerProtos.UpdateContainerRequestProto.Builder updateRequestBuilder = ContainerProtos.UpdateContainerRequestProto.newBuilder();
        for (String key : keys = metaData.keySet().toArray(new String[0])) {
            ContainerProtos.KeyValue.Builder kvBuilder = ContainerProtos.KeyValue.newBuilder();
            kvBuilder.setKey(key);
            kvBuilder.setValue(metaData.get(key));
            updateRequestBuilder.addMetadata(kvBuilder.build());
        }
        Pipeline pipeline = MockPipeline.createSingleNodePipeline();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.UpdateContainer);
        request.setContainerID(containerID);
        request.setUpdateContainer(updateRequestBuilder.build());
        request.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return request.build();
    }

    public static ContainerProtos.ContainerCommandResponseProto getCreateContainerResponse(ContainerProtos.ContainerCommandRequestProto request) {
        ContainerProtos.ContainerCommandResponseProto.Builder response = ContainerProtos.ContainerCommandResponseProto.newBuilder();
        response.setCmdType(ContainerProtos.Type.CreateContainer);
        response.setTraceID(request.getTraceID());
        response.setCreateContainer(ContainerProtos.CreateContainerResponseProto.getDefaultInstance());
        response.setResult(ContainerProtos.Result.SUCCESS);
        return response.build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getPutBlockRequest(Pipeline pipeline, ContainerProtos.WriteChunkRequestProto writeRequest) throws IOException {
        return ContainerTestHelper.newPutBlockRequestBuilder(pipeline, (ContainerProtos.WriteChunkRequestProtoOrBuilder)writeRequest).build();
    }

    public static ContainerProtos.ContainerCommandRequestProto.Builder newPutBlockRequestBuilder(Pipeline pipeline, ContainerProtos.WriteChunkRequestProtoOrBuilder writeRequest) throws IOException {
        LOG.trace("putBlock: {} to pipeline={}", (Object)writeRequest.getBlockID(), (Object)pipeline);
        ContainerProtos.PutBlockRequestProto.Builder putRequest = ContainerProtos.PutBlockRequestProto.newBuilder();
        BlockData blockData = new BlockData(BlockID.getFromProtobuf((ContainerProtos.DatanodeBlockID)writeRequest.getBlockID()));
        LinkedList<ContainerProtos.ChunkInfo> newList = new LinkedList<ContainerProtos.ChunkInfo>();
        newList.add(writeRequest.getChunkData());
        blockData.setChunks(newList);
        blockData.setBlockCommitSequenceId(0L);
        putRequest.setBlockData(blockData.getProtoBufMessage());
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.PutBlock);
        request.setContainerID(blockData.getContainerID());
        request.setPutBlock(putRequest);
        request.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return request;
    }

    public static ContainerProtos.ContainerCommandRequestProto getBlockRequest(Pipeline pipeline, ContainerProtos.PutBlockRequestProto putBlockRequest) throws IOException {
        return ContainerTestHelper.newGetBlockRequestBuilder(pipeline, (ContainerProtos.PutBlockRequestProtoOrBuilder)putBlockRequest).build();
    }

    public static ContainerProtos.ContainerCommandRequestProto.Builder newGetBlockRequestBuilder(Pipeline pipeline, ContainerProtos.PutBlockRequestProtoOrBuilder putBlock) throws IOException {
        ContainerProtos.DatanodeBlockID blockID = putBlock.getBlockData().getBlockID();
        ContainerProtos.GetBlockRequestProto.Builder getRequest = ContainerProtos.GetBlockRequestProto.newBuilder();
        getRequest.setBlockID(blockID);
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.GetBlock);
        request.setContainerID(blockID.getContainerID());
        request.setGetBlock(getRequest);
        request.setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        return request;
    }

    public static void verifyGetBlock(ContainerProtos.ContainerCommandRequestProto request, ContainerProtos.ContainerCommandResponseProto response, int expectedChunksCount) {
        Assertions.assertEquals((Object)ContainerProtos.Result.SUCCESS, (Object)response.getResult());
        Assertions.assertEquals((int)expectedChunksCount, (int)response.getGetBlock().getBlockData().getChunksCount());
    }

    public static ContainerProtos.ContainerCommandRequestProto.Builder newGetCommittedBlockLengthBuilder(Pipeline pipeline, ContainerProtos.PutBlockRequestProtoOrBuilder putBlock) throws IOException {
        ContainerProtos.DatanodeBlockID blockID = putBlock.getBlockData().getBlockID();
        ContainerProtos.GetCommittedBlockLengthRequestProto.Builder req = ContainerProtos.GetCommittedBlockLengthRequestProto.newBuilder().setBlockID(blockID);
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetCommittedBlockLength).setContainerID(blockID.getContainerID()).setDatanodeUuid(pipeline.getFirstNode().getUuidString()).setGetCommittedBlockLength(req);
    }

    public static ContainerProtos.ContainerCommandRequestProto getCloseContainer(Pipeline pipeline, long containerID, Token<?> token) throws IOException {
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.CloseContainer).setContainerID(containerID).setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance()).setDatanodeUuid(pipeline.getFirstNode().getUuidString());
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        return builder.build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getCloseContainer(Pipeline pipeline, long containerID) throws IOException {
        return ContainerTestHelper.getCloseContainer(pipeline, containerID, null);
    }

    public static ContainerProtos.ContainerCommandRequestProto getRequestWithoutTraceId(Pipeline pipeline, long containerID) throws IOException {
        Preconditions.checkNotNull((Object)pipeline);
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.CloseContainer).setContainerID(containerID).setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance()).setDatanodeUuid(pipeline.getFirstNode().getUuidString()).build();
    }

    public static ContainerProtos.ContainerCommandRequestProto getDeleteContainer(Pipeline pipeline, long containerID, boolean forceDelete) throws IOException {
        Preconditions.checkNotNull((Object)pipeline);
        ContainerProtos.DeleteContainerRequestProto deleteRequest = ContainerProtos.DeleteContainerRequestProto.newBuilder().setForceDelete(forceDelete).build();
        return ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.DeleteContainer).setContainerID(containerID).setDeleteContainer(ContainerProtos.DeleteContainerRequestProto.getDefaultInstance()).setDeleteContainer(deleteRequest).setDatanodeUuid(pipeline.getFirstNode().getUuidString()).build();
    }

    private static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static BlockID getTestBlockID(long containerID) {
        return new BlockID(containerID, UniqueId.next());
    }

    public static long getTestContainerID() {
        return UniqueId.next();
    }

    public static String getFixedLengthString(String string, int length) {
        return String.format("%1$" + length + "s", string);
    }

    public static byte[] generateData(int length, boolean random) {
        byte[] data = new byte[length];
        if (random) {
            ThreadLocalRandom.current().nextBytes(data);
        } else {
            for (int i = 0; i < length; ++i) {
                data[i] = (byte)i;
            }
        }
        return data;
    }

    public static ContainerProtos.ContainerCommandRequestProto getDummyCommandRequestProto(ContainerProtos.Type cmdType) {
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(cmdType).setContainerID(9999L).setDatanodeUuid(DATANODE_UUID);
        ContainerProtos.DatanodeBlockID fakeBlockId = ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(9999L).setLocalID(1L).setBlockCommitSequenceId(101L).build();
        ContainerProtos.ChunkInfo fakeChunkInfo = ContainerProtos.ChunkInfo.newBuilder().setChunkName("dummy").setOffset(0L).setLen(100L).setChecksumData(ContainerProtos.ChecksumData.newBuilder().setBytesPerChecksum(1).setType(ContainerProtos.ChecksumType.CRC32).build()).build();
        switch (cmdType) {
            case ReadContainer: {
                builder.setReadContainer(ContainerProtos.ReadContainerRequestProto.newBuilder().build());
                break;
            }
            case GetBlock: {
                builder.setGetBlock(ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(fakeBlockId).build());
                break;
            }
            case GetCommittedBlockLength: {
                builder.setGetCommittedBlockLength(ContainerProtos.GetCommittedBlockLengthRequestProto.newBuilder().setBlockID(fakeBlockId).build());
                break;
            }
            case ReadChunk: {
                builder.setReadChunk(ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(fakeBlockId).setChunkData(fakeChunkInfo).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1).build());
                break;
            }
            case GetSmallFile: {
                builder.setGetSmallFile(ContainerProtos.GetSmallFileRequestProto.newBuilder().setBlock(ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(fakeBlockId).build()).build());
                break;
            }
            default: {
                Assertions.fail((String)("Unhandled request type " + cmdType + " in unit test"));
            }
        }
        return builder.build();
    }
}

