/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections.SetUtils;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;
import org.apache.hadoop.ozone.common.statemachine.StateMachine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStateMachine {
    @Test
    public void testStateMachineStates() throws InvalidStateTransitionException {
        HashSet<STATES> finals = new HashSet<STATES>();
        finals.add(STATES.FINAL);
        StateMachine stateMachine = new StateMachine((Enum)STATES.INIT, finals);
        stateMachine.addTransition((Enum)STATES.INIT, (Enum)STATES.CREATING, (Enum)EVENTS.ALLOCATE);
        stateMachine.addTransition((Enum)STATES.CREATING, (Enum)STATES.OPERATIONAL, (Enum)EVENTS.CREATE);
        stateMachine.addTransition((Enum)STATES.OPERATIONAL, (Enum)STATES.OPERATIONAL, (Enum)EVENTS.UPDATE);
        stateMachine.addTransition((Enum)STATES.OPERATIONAL, (Enum)STATES.CLEANUP, (Enum)EVENTS.DELETE);
        stateMachine.addTransition((Enum)STATES.OPERATIONAL, (Enum)STATES.CLOSED, (Enum)EVENTS.CLOSE);
        stateMachine.addTransition((Enum)STATES.CREATING, (Enum)STATES.CLEANUP, (Enum)EVENTS.TIMEOUT);
        Assertions.assertEquals((Object)((Object)STATES.INIT), (Object)stateMachine.getInitialState(), (String)"Initial State");
        Assertions.assertTrue((boolean)SetUtils.isEqualSet(finals, (Collection)stateMachine.getFinalStates()), (String)"Final States");
        Assertions.assertEquals((Object)((Object)STATES.OPERATIONAL), (Object)stateMachine.getNextState((Enum)STATES.CREATING, (Enum)EVENTS.CREATE), (String)"STATE should be OPERATIONAL after being created");
        Assertions.assertEquals((Object)((Object)STATES.OPERATIONAL), (Object)stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.UPDATE), (String)"STATE should be OPERATIONAL after being updated");
        Assertions.assertEquals((Object)((Object)STATES.CLEANUP), (Object)stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.DELETE), (String)"STATE should be CLEANUP after being deleted");
        Assertions.assertEquals((Object)((Object)STATES.CLEANUP), (Object)stateMachine.getNextState((Enum)STATES.CREATING, (Enum)EVENTS.TIMEOUT), (String)"STATE should be CLEANUP after being timeout");
        Assertions.assertEquals((Object)((Object)STATES.CLOSED), (Object)stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.CLOSE), (String)"STATE should be CLOSED after being closed");
        Assertions.assertThrowsExactly(InvalidStateTransitionException.class, () -> {
            STATES cfr_ignored_0 = (STATES)stateMachine.getNextState((Enum)STATES.OPERATIONAL, (Enum)EVENTS.CREATE);
        }, (String)"Invalid event");
        Assertions.assertThrowsExactly(InvalidStateTransitionException.class, () -> {
            STATES cfr_ignored_0 = (STATES)stateMachine.getNextState((Enum)STATES.CREATING, (Enum)EVENTS.CLOSE);
        }, (String)"Invalid event");
    }

    public static enum EVENTS {
        ALLOCATE,
        CREATE,
        UPDATE,
        CLOSE,
        DELETE,
        TIMEOUT;

    }

    public static enum STATES {
        INIT,
        CREATING,
        OPERATIONAL,
        CLOSED,
        CLEANUP,
        FINAL;

    }
}

