/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common;

import java.nio.charset.StandardCharsets;
import java.util.Random;
import java.util.zip.Checksum;
import org.apache.hadoop.ozone.common.ChecksumByteBuffer;
import org.apache.hadoop.ozone.common.ChecksumByteBufferFactory;
import org.apache.hadoop.util.PureJavaCrc32;
import org.apache.hadoop.util.PureJavaCrc32C;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestChecksumByteBuffer {
    @Test
    public void testPureJavaCrc32ByteBuffer() {
        PureJavaCrc32 expected = new PureJavaCrc32();
        ChecksumByteBuffer testee = ChecksumByteBufferFactory.crc32Impl();
        new VerifyChecksumByteBuffer((Checksum)expected, testee).testCorrectness();
    }

    @Test
    public void testPureJavaCrc32CByteBuffer() {
        PureJavaCrc32C expected = new PureJavaCrc32C();
        ChecksumByteBuffer testee = ChecksumByteBufferFactory.crc32CImpl();
        new VerifyChecksumByteBuffer((Checksum)expected, testee).testCorrectness();
    }

    static class VerifyChecksumByteBuffer {
        private final Checksum expected;
        private final ChecksumByteBuffer testee;

        VerifyChecksumByteBuffer(Checksum expected, ChecksumByteBuffer testee) {
            this.expected = expected;
            this.testee = testee;
        }

        void testCorrectness() {
            this.checkSame();
            this.checkBytes("hello world!".getBytes(StandardCharsets.UTF_8));
            Random random = new Random();
            byte[] bytes = new byte[1024];
            for (int i = 0; i < 1000; ++i) {
                random.nextBytes(bytes);
                this.checkBytes(bytes, random.nextInt(bytes.length));
            }
        }

        void checkBytes(byte[] bytes) {
            this.checkBytes(bytes, bytes.length);
        }

        void checkBytes(byte[] bytes, int length) {
            this.expected.reset();
            this.testee.reset();
            this.checkSame();
            for (byte b : bytes) {
                this.expected.update(b);
                this.testee.update((int)b);
                this.checkSame();
            }
            this.expected.reset();
            this.testee.reset();
            for (int i = 0; i < length; ++i) {
                this.expected.update(bytes, 0, i);
                this.testee.update(bytes, 0, i);
                this.checkSame();
            }
            this.expected.reset();
            this.testee.reset();
            this.checkSame();
        }

        private void checkSame() {
            Assertions.assertEquals((long)this.expected.getValue(), (long)this.testee.getValue());
        }
    }
}

