/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class Proto2CodecTestBase<T> {
    public abstract Codec<T> getCodec();

    @Test
    public void testInvalidProtocolBuffer() throws Exception {
        InvalidProtocolBufferException exception = (InvalidProtocolBufferException)Assertions.assertThrows(InvalidProtocolBufferException.class, () -> this.getCodec().fromPersistedFormat("random".getBytes(StandardCharsets.UTF_8)));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"the input ended unexpectedly"));
    }

    @Test
    public void testFromPersistedFormat() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getCodec().fromPersistedFormat(null));
    }

    @Test
    public void testToPersistedFormat() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> this.getCodec().toPersistedFormat(null));
    }
}

