/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CodecTestUtil {
    static final Logger LOG = LoggerFactory.getLogger(CodecTestUtil.class);

    private CodecTestUtil() {
    }

    public static void gc() throws InterruptedException {
        Object obj = new Object();
        WeakReference<Object> weakRef = new WeakReference<Object>(obj);
        obj = null;
        int i = 0;
        while (weakRef.get() != null) {
            LOG.info("gc {}", (Object)i);
            System.gc();
            Thread.sleep(100L);
            ++i;
        }
        CodecBuffer.assertNoLeaks();
    }

    public static <T> void runTest(Codec<T> codec, T original, Integer serializedSize, Codec<T> oldCodec) throws Exception {
        Assertions.assertTrue((boolean)codec.supportCodecBuffer());
        byte[] array = codec.toPersistedFormat(original);
        LOG.info("encoded length = " + array.length);
        if (serializedSize != null) {
            Assertions.assertEquals((Integer)serializedSize, (int)array.length);
        }
        if (oldCodec != null) {
            byte[] expected = oldCodec.toPersistedFormat(original);
            Assertions.assertArrayEquals((byte[])expected, (byte[])array);
        }
        Object fromArray = codec.fromPersistedFormat(array);
        Assertions.assertEquals(original, (Object)fromArray);
        CodecBuffer codecBuffer = codec.toCodecBuffer(original, CodecBuffer.Allocator.getHeap());
        Assertions.assertEquals((int)array.length, (int)codecBuffer.readableBytes());
        ByteBuffer byteBuffer = codecBuffer.asReadOnlyByteBuffer();
        Assertions.assertEquals((int)array.length, (int)byteBuffer.remaining());
        for (int i = 0; i < array.length; ++i) {
            Assertions.assertEquals((byte)array[i], (byte)byteBuffer.get(i));
        }
        if (oldCodec != null && oldCodec.supportCodecBuffer()) {
            try (CodecBuffer expected = oldCodec.toHeapCodecBuffer(original);){
                Assertions.assertEquals((Object)expected.asReadOnlyByteBuffer(), (Object)codecBuffer.asReadOnlyByteBuffer());
            }
        }
        Object fromBuffer = codec.fromCodecBuffer(codecBuffer);
        codecBuffer.release();
        Assertions.assertEquals(original, (Object)fromBuffer);
        CodecBuffer wrapped = CodecBuffer.wrap((byte[])array);
        Object fromWrappedArray = codec.fromCodecBuffer(wrapped);
        wrapped.release();
        Assertions.assertEquals(original, (Object)fromWrappedArray);
    }
}

