/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.util.concurrent.Striped;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.hdds.utils.SimpleStriped;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimpleStriped {
    @Test
    void testReadWriteLocks() {
        this.testReadWriteLocks(true);
        this.testReadWriteLocks(false);
    }

    private void testReadWriteLocks(boolean fair) {
        Striped striped = SimpleStriped.readWriteLock((int)128, (boolean)fair);
        Assertions.assertEquals((int)128, (int)striped.size());
        ReadWriteLock lock = (ReadWriteLock)striped.get((Object)"key1");
        Assertions.assertEquals((Object)fair, (Object)((ReentrantReadWriteLock)lock).isFair());
        Assertions.assertEquals((Object)lock, (Object)striped.get((Object)"key1"));
        Assertions.assertNotEquals((Object)lock, (Object)striped.get((Object)"key2"));
    }

    @Test
    void testCustomStripes() {
        int size = 128;
        Striped striped = SimpleStriped.custom((int)size, ReentrantLock::new);
        Assertions.assertEquals((int)128, (int)striped.size());
        Lock lock = (Lock)striped.get((Object)"key1");
        Assertions.assertEquals((Object)lock, (Object)striped.get((Object)"key1"));
        Assertions.assertNotEquals((Object)lock, (Object)striped.get((Object)"key2"));
    }
}

