/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.utils.Cache;
import org.apache.hadoop.hdds.utils.ResourceCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestResourceCache {
    private static final String ANY_VALUE = "asdf";

    @Test
    public void testResourceCache() throws InterruptedException {
        AtomicLong count = new AtomicLong(0L);
        ResourceCache resourceCache = new ResourceCache((k, v) -> k, 10L, P -> {
            if (P.wasEvicted()) {
                count.incrementAndGet();
            }
        });
        resourceCache.put((Object)6, (Object)"a");
        resourceCache.put((Object)4, (Object)"a");
        resourceCache.put((Object)4, (Object)"a");
        resourceCache.put((Object)1, (Object)"a");
        Assertions.assertNull((Object)resourceCache.get((Object)6));
        Assertions.assertTrue((count.get() == 1L ? 1 : 0) != 0);
        resourceCache.put((Object)5, (Object)"a");
        Assertions.assertNotNull((Object)resourceCache.get((Object)4));
        resourceCache.remove((Object)4);
        Assertions.assertNull((Object)resourceCache.get((Object)4));
        Assertions.assertTrue((count.get() == 1L ? 1 : 0) != 0);
    }

    @Test
    @Timeout(value=5L)
    public void testRemove() throws Exception {
        TestResourceCache.testRemove(cache -> cache.remove((Object)2), 2);
    }

    @Test
    @Timeout(value=5L)
    public void testRemoveIf() throws Exception {
        TestResourceCache.testRemove(cache -> cache.removeIf(k -> k <= 2), 1, 2);
    }

    @Test
    @Timeout(value=5L)
    public void testClear() throws Exception {
        TestResourceCache.testRemove(Cache::clear, 1, 2, 3);
    }

    private static void testRemove(Consumer<Cache<Integer, String>> op, int ... removedKeys) throws InterruptedException {
        int maxSize = 3;
        ResourceCache resourceCache = new ResourceCache((k, v) -> 1, 3L, null);
        for (int i = 1; i <= 3; ++i) {
            resourceCache.put((Object)i, (Object)ANY_VALUE);
        }
        op.accept((Cache<Integer, String>)resourceCache);
        int[] i = removedKeys;
        int n = i.length;
        for (int j = 0; j < n; ++j) {
            Integer k2 = i[j];
            Assertions.assertNull((Object)resourceCache.get((Object)k2));
        }
        for (int i2 = 1; i2 <= removedKeys.length; ++i2) {
            resourceCache.put((Object)(3 + i2), (Object)ANY_VALUE);
        }
    }
}

