/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.upgrade;

import java.util.Optional;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutFeature;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.hdds.upgrade.HDDSUpgradeAction;
import org.apache.hadoop.hdds.upgrade.test.MockComponent;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHDDSLayoutVersionManager {
    private static final String[] UPGRADE_ACTIONS_TEST_PACKAGES = new String[]{"org.apache.hadoop.hdds.upgrade.test"};

    @Test
    public void testUpgradeActionsRegistered() throws Exception {
        HDDSLayoutVersionManager lvm = new HDDSLayoutVersionManager(HDDSLayoutVersionManager.maxLayoutVersion());
        lvm.registerUpgradeActions((Object[])UPGRADE_ACTIONS_TEST_PACKAGES);
        Optional action = HDDSLayoutFeature.INITIAL_VERSION.scmAction(LayoutFeature.UpgradeActionType.ON_FINALIZE);
        Assertions.assertFalse((boolean)action.isPresent());
        action = HDDSLayoutFeature.DATANODE_SCHEMA_V2.datanodeAction(LayoutFeature.UpgradeActionType.ON_FIRST_UPGRADE_START);
        Assertions.assertFalse((boolean)action.isPresent());
        lvm = (HDDSLayoutVersionManager)Mockito.mock(HDDSLayoutVersionManager.class);
        Mockito.when((Object)lvm.getMetadataLayoutVersion()).thenReturn((Object)-1);
        ((HDDSLayoutVersionManager)Mockito.doCallRealMethod().when((Object)lvm)).registerUpgradeActions((Object[])ArgumentMatchers.any());
        lvm.registerUpgradeActions((Object[])UPGRADE_ACTIONS_TEST_PACKAGES);
        action = HDDSLayoutFeature.INITIAL_VERSION.scmAction(LayoutFeature.UpgradeActionType.ON_FINALIZE);
        Assertions.assertTrue((boolean)action.isPresent());
        Assertions.assertEquals(MockComponent.MockScmUpgradeAction.class, ((HDDSUpgradeAction)action.get()).getClass());
        Assertions.assertFalse((boolean)HDDSLayoutFeature.INITIAL_VERSION.datanodeAction(LayoutFeature.UpgradeActionType.ON_FINALIZE).isPresent());
        MockComponent mockObj = (MockComponent)Mockito.mock(MockComponent.class);
        ((HDDSUpgradeAction)action.get()).execute((Object)mockObj);
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)1))).mockMethodScm();
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)0))).mockMethodDn();
        action = HDDSLayoutFeature.DATANODE_SCHEMA_V2.datanodeAction(LayoutFeature.UpgradeActionType.ON_FIRST_UPGRADE_START);
        Assertions.assertTrue((boolean)action.isPresent());
        Assertions.assertEquals(MockComponent.MockDnUpgradeAction.class, ((HDDSUpgradeAction)action.get()).getClass());
        Assertions.assertFalse((boolean)HDDSLayoutFeature.DATANODE_SCHEMA_V2.scmAction(LayoutFeature.UpgradeActionType.ON_FIRST_UPGRADE_START).isPresent());
        mockObj = (MockComponent)Mockito.mock(MockComponent.class);
        ((HDDSUpgradeAction)action.get()).execute((Object)mockObj);
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)0))).mockMethodScm();
        ((MockComponent)Mockito.verify((Object)mockObj, (VerificationMode)Mockito.times((int)1))).mockMethodDn();
    }

    @Test
    public void testHDDSLayoutFeaturesHaveIncreasingLayoutVersion() {
        HDDSLayoutFeature[] values = HDDSLayoutFeature.values();
        int currVersion = -1;
        for (HDDSLayoutFeature lf : values) {
            Assertions.assertEquals((int)(currVersion + 1), (int)lf.layoutVersion());
            currVersion = lf.layoutVersion();
        }
    }
}

