/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.tracing;

import org.apache.hadoop.hdds.tracing.TraceAllMethod;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTraceAllMethod {
    @Test
    public void testUnknownMethod() {
        TraceAllMethod subject = new TraceAllMethod((Object)new ServiceImpl(), "service");
        Assertions.assertThrows(NoSuchMethodException.class, () -> subject.invoke(null, ServiceImpl.class.getMethod("no such method", new Class[0]), new Object[0]));
    }

    @Test
    public void testDefaultMethod() throws Throwable {
        TraceAllMethod subject = new TraceAllMethod((Object)new ServiceImpl(), "service");
        Assertions.assertEquals((Object)"Hello default", (Object)subject.invoke(null, ServiceImpl.class.getMethod("defaultMethod", new Class[0]), new Object[0]));
    }

    public static class ServiceImpl
    implements Service {
        @Override
        public String otherMethod(String name) {
            return "Hello " + name;
        }
    }

    public static interface Service {
        default public String defaultMethod() {
            return this.otherMethod("default");
        }

        public String otherMethod(String var1);
    }
}

