/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.TestDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.MockPipeline;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.ozone.ClientVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPipeline {
    @Test
    public void protoIncludesNewPortsOnlyForV1() throws IOException {
        Pipeline subject = MockPipeline.createPipeline(3);
        HddsProtos.Pipeline proto = subject.getProtobufMessage(ClientVersion.DEFAULT_VERSION.toProtoValue());
        for (HddsProtos.DatanodeDetailsProto dn : proto.getMembersList()) {
            TestDatanodeDetails.assertPorts(dn, DatanodeDetails.Port.Name.V0_PORTS);
        }
        HddsProtos.Pipeline protoV1 = subject.getProtobufMessage(ClientVersion.VERSION_HANDLES_UNKNOWN_DN_PORTS.toProtoValue());
        for (HddsProtos.DatanodeDetailsProto dn : protoV1.getMembersList()) {
            TestDatanodeDetails.assertPorts(dn, DatanodeDetails.Port.Name.ALL_PORTS);
        }
    }

    @Test
    public void getProtobufMessageEC() throws IOException {
        Pipeline subject = MockPipeline.createPipeline(3);
        HddsProtos.Pipeline protobufMessage = subject.getProtobufMessage(1);
        Assertions.assertEquals((int)0, (int)protobufMessage.getEcReplicationConfig().getData());
        subject = MockPipeline.createEcPipeline();
        protobufMessage = subject.getProtobufMessage(1);
        Assertions.assertEquals((int)3, (int)protobufMessage.getEcReplicationConfig().getData());
        Assertions.assertEquals((int)2, (int)protobufMessage.getEcReplicationConfig().getParity());
    }

    @Test
    public void testReplicaIndexesSerialisedCorrectly() throws IOException {
        Pipeline pipeline = MockPipeline.createEcPipeline();
        HddsProtos.Pipeline protobufMessage = pipeline.getProtobufMessage(1);
        Pipeline reloadedPipeline = Pipeline.getFromProtobuf((HddsProtos.Pipeline)protobufMessage);
        for (DatanodeDetails dn : pipeline.getNodes()) {
            Assertions.assertEquals((int)pipeline.getReplicaIndex(dn), (int)reloadedPipeline.getReplicaIndex(dn));
        }
    }

    @Test
    public void testECPipelineIsAlwaysHealthy() {
        Pipeline pipeline = MockPipeline.createEcPipeline();
        Assertions.assertTrue((boolean)pipeline.isHealthy());
    }

    @Test
    public void testBuilderCopiesAllFieldsFromOtherPipeline() {
        Pipeline original = MockPipeline.createEcPipeline();
        Pipeline copied = Pipeline.newBuilder((Pipeline)original).build();
        Assertions.assertEquals((Object)original.getId(), (Object)copied.getId());
        Assertions.assertEquals((Object)original.getReplicationConfig(), (Object)copied.getReplicationConfig());
        Assertions.assertEquals((Object)original.getPipelineState(), (Object)copied.getPipelineState());
        Assertions.assertEquals((Object)original.getId(), (Object)copied.getId());
        Assertions.assertEquals((Object)original.getId(), (Object)copied.getId());
        Assertions.assertEquals((Object)original.getId(), (Object)copied.getId());
        Assertions.assertEquals((Object)original.getNodeSet(), (Object)copied.getNodeSet());
        Assertions.assertEquals((Object)original.getNodesInOrder(), (Object)copied.getNodesInOrder());
        Assertions.assertEquals((Object)original.getLeaderId(), (Object)copied.getLeaderId());
        Assertions.assertEquals((Object)original.getCreationTimestamp(), (Object)copied.getCreationTimestamp());
        Assertions.assertEquals((Object)original.getSuggestedLeaderId(), (Object)copied.getSuggestedLeaderId());
        for (DatanodeDetails dn : original.getNodes()) {
            Assertions.assertEquals((int)original.getReplicaIndex(dn), (int)copied.getReplicaIndex(dn));
        }
    }
}

