/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.MockDatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;

public final class MockPipeline {
    public static Pipeline createSingleNodePipeline() throws IOException {
        return MockPipeline.createPipeline(1);
    }

    public static Pipeline createPipeline(int numNodes) throws IOException {
        Preconditions.checkArgument((numNodes >= 1 ? 1 : 0) != 0);
        ArrayList<DatanodeDetails> ids = new ArrayList<DatanodeDetails>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            ids.add(MockDatanodeDetails.randomLocalDatanodeDetails());
        }
        return MockPipeline.createPipeline(ids);
    }

    public static Pipeline createPipeline(Iterable<DatanodeDetails> ids) {
        Objects.requireNonNull(ids, "ids == null");
        Preconditions.checkArgument((boolean)ids.iterator().hasNext());
        ArrayList dns = new ArrayList();
        ids.forEach(dns::add);
        return Pipeline.newBuilder().setState(Pipeline.PipelineState.OPEN).setId(PipelineID.randomId()).setReplicationConfig((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE)).setNodes(dns).build();
    }

    public static Pipeline createRatisPipeline() {
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        nodes.add(MockDatanodeDetails.randomDatanodeDetails());
        nodes.add(MockDatanodeDetails.randomDatanodeDetails());
        nodes.add(MockDatanodeDetails.randomDatanodeDetails());
        return Pipeline.newBuilder().setState(Pipeline.PipelineState.OPEN).setId(PipelineID.randomId()).setReplicationConfig((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE)).setNodes(nodes).setLeaderId(UUID.randomUUID()).build();
    }

    public static Pipeline createEcPipeline() {
        return MockPipeline.createEcPipeline(new ECReplicationConfig(3, 2));
    }

    public static Pipeline createEcPipeline(ECReplicationConfig repConfig) {
        ArrayList<DatanodeDetails> nodes = new ArrayList<DatanodeDetails>();
        for (int i = 0; i < repConfig.getRequiredNodes(); ++i) {
            nodes.add(MockDatanodeDetails.randomDatanodeDetails());
        }
        HashMap<DatanodeDetails, Integer> nodeIndexes = new HashMap<DatanodeDetails, Integer>();
        int index = nodes.size() - 1;
        for (DatanodeDetails dn : nodes) {
            nodeIndexes.put(dn, index);
            --index;
        }
        return Pipeline.newBuilder().setState(Pipeline.PipelineState.OPEN).setId(PipelineID.randomId()).setReplicationConfig((ReplicationConfig)repConfig).setNodes(nodes).setReplicaIndexes(nodeIndexes).build();
    }

    private MockPipeline() {
        throw new UnsupportedOperationException("no instances");
    }
}

