/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.ozone.test.TestClock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExcludeList {
    private TestClock clock = new TestClock(Instant.now(), (ZoneId)ZoneOffset.UTC);

    @Test
    public void excludeNodesShouldBeCleanedBasedOnGivenTime() {
        ExcludeList list = new ExcludeList(10L, (Clock)this.clock);
        list.addDatanode(DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).setIpAddress("127.0.0.1").setHostName("localhost").addPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)2001)).build());
        Assertions.assertTrue((list.getDatanodes().size() == 1 ? 1 : 0) != 0);
        this.clock.fastForward(11L);
        Assertions.assertTrue((list.getDatanodes().size() == 0 ? 1 : 0) != 0);
        list.addDatanode(DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).setIpAddress("127.0.0.2").setHostName("localhost").addPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)2001)).build());
        list.addDatanode(DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).setIpAddress("127.0.0.3").setHostName("localhost").addPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)2001)).build());
        Assertions.assertTrue((list.getDatanodes().size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void excludeNodeShouldNotBeCleanedIfExpiryTimeIsZero() {
        ExcludeList list = new ExcludeList(0L, (Clock)this.clock);
        list.addDatanode(DatanodeDetails.newBuilder().setUuid(UUID.randomUUID()).setIpAddress("127.0.0.1").setHostName("localhost").addPort(DatanodeDetails.newPort((DatanodeDetails.Port.Name)DatanodeDetails.Port.Name.STANDALONE, (Integer)2001)).build());
        Assertions.assertTrue((list.getDatanodes().size() == 1 ? 1 : 0) != 0);
        this.clock.fastForward(1L);
        Assertions.assertTrue((list.getDatanodes().size() == 1 ? 1 : 0) != 0);
    }
}

