/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.ozone.test.TestClock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestContainerInfo {
    @Test
    void getProtobufRatis() {
        ContainerInfo container = TestContainerInfo.newBuilderForTest().setReplicationConfig((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE)).build();
        HddsProtos.ContainerInfoProto proto = container.getProtobuf();
        Assertions.assertFalse((boolean)proto.hasEcReplicationConfig());
        Assertions.assertEquals((Object)HddsProtos.ReplicationFactor.THREE, (Object)proto.getReplicationFactor());
        Assertions.assertEquals((Object)HddsProtos.ReplicationType.RATIS, (Object)proto.getReplicationType());
        ContainerInfo recovered = ContainerInfo.fromProtobuf((HddsProtos.ContainerInfoProto)proto);
        Assertions.assertEquals((Object)HddsProtos.ReplicationType.RATIS, (Object)recovered.getReplicationType());
        Assertions.assertEquals(RatisReplicationConfig.class, recovered.getReplicationConfig().getClass());
        Assertions.assertEquals((Object)HddsProtos.ReplicationFactor.THREE, (Object)recovered.getReplicationFactor());
    }

    @Test
    void getProtobufEC() {
        ContainerInfo container = TestContainerInfo.newBuilderForTest().setReplicationConfig((ReplicationConfig)new ECReplicationConfig(3, 2)).build();
        HddsProtos.ContainerInfoProto proto = container.getProtobuf();
        Assertions.assertEquals((int)3, (int)proto.getEcReplicationConfig().getData());
        Assertions.assertEquals((int)2, (int)proto.getEcReplicationConfig().getParity());
        Assertions.assertFalse((boolean)proto.hasReplicationFactor());
        Assertions.assertEquals((Object)HddsProtos.ReplicationType.EC, (Object)proto.getReplicationType());
        ContainerInfo recovered = ContainerInfo.fromProtobuf((HddsProtos.ContainerInfoProto)proto);
        Assertions.assertEquals((Object)HddsProtos.ReplicationType.EC, (Object)recovered.getReplicationType());
        Assertions.assertEquals(ECReplicationConfig.class, recovered.getReplicationConfig().getClass());
        ECReplicationConfig config = (ECReplicationConfig)recovered.getReplicationConfig();
        Assertions.assertEquals((int)3, (int)config.getData());
        Assertions.assertEquals((int)2, (int)config.getParity());
    }

    @Test
    void restoreState() {
        TestClock clock = TestClock.newInstance();
        ContainerInfo subject = TestContainerInfo.newBuilderForTest().setClock((Clock)clock).build();
        HddsProtos.LifeCycleState initialState = subject.getState();
        Instant initialStateEnterTime = subject.getStateEnterTime();
        clock.fastForward((TemporalAmount)Duration.ofMinutes(1L));
        subject.setState(HddsProtos.LifeCycleState.CLOSING);
        Assertions.assertEquals((Object)HddsProtos.LifeCycleState.CLOSING, (Object)subject.getState());
        Assertions.assertEquals((Object)clock.instant(), (Object)subject.getStateEnterTime());
        subject.revertState();
        Assertions.assertEquals((Object)initialState, (Object)subject.getState());
        Assertions.assertEquals((Object)initialStateEnterTime, (Object)subject.getStateEnterTime());
        Assertions.assertThrows(IllegalStateException.class, () -> ((ContainerInfo)subject).revertState());
    }

    public static ContainerInfo.Builder newBuilderForTest() {
        return new ContainerInfo.Builder().setContainerID(1234L).setPipelineID(PipelineID.randomId()).setState(HddsProtos.LifeCycleState.OPEN).setOwner("scm");
    }
}

