/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.ratis.conf;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.ratis.conf.RatisClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRaftClientConfig {
    TestRaftClientConfig() {
    }

    @Test
    void defaults() {
        RatisClientConfig.RaftConfig subject = new RatisClientConfig.RaftConfig();
        RatisClientConfig.RaftConfig fromConfig = (RatisClientConfig.RaftConfig)new OzoneConfiguration().getObject(RatisClientConfig.RaftConfig.class);
        Assertions.assertEquals((int)fromConfig.getMaxOutstandingRequests(), (int)subject.getMaxOutstandingRequests());
        Assertions.assertEquals((Object)fromConfig.getRpcRequestTimeout(), (Object)subject.getRpcRequestTimeout());
        Assertions.assertEquals((Object)fromConfig.getRpcWatchRequestTimeout(), (Object)subject.getRpcWatchRequestTimeout());
    }

    @Test
    void setAndGet() {
        RatisClientConfig.RaftConfig subject = new RatisClientConfig.RaftConfig();
        int maxOutstandingRequests = 42;
        Duration rpcRequestTimeout = Duration.ofMillis(12313L);
        Duration rpcWatchRequestTimeout = Duration.ofSeconds(99L);
        subject.setMaxOutstandingRequests(42);
        subject.setRpcRequestTimeout(rpcRequestTimeout);
        subject.setRpcWatchRequestTimeout(rpcWatchRequestTimeout);
        Assertions.assertEquals((int)42, (int)subject.getMaxOutstandingRequests());
        Assertions.assertEquals((Object)rpcRequestTimeout, (Object)subject.getRpcRequestTimeout());
        Assertions.assertEquals((Object)rpcWatchRequestTimeout, (Object)subject.getRpcWatchRequestTimeout());
    }
}

