/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdds.fs.DedicatedDiskSpaceUsage;
import org.apache.hadoop.hdds.fs.TestDU;
import org.apache.ozone.test.GenericTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestDedicatedDiskSpaceUsage {
    private static final File DIR = GenericTestUtils.getTestDir((String)TestDedicatedDiskSpaceUsage.class.getSimpleName());
    private static final int FILE_SIZE = 1024;

    @BeforeEach
    public void setUp() {
        FileUtil.fullyDelete((File)DIR);
        Assertions.assertTrue((boolean)DIR.mkdirs());
    }

    @AfterEach
    public void tearDown() throws IOException {
        FileUtil.fullyDelete((File)DIR);
    }

    @Test
    public void testGetUsed() throws IOException {
        File file = new File(DIR, "data");
        TestDU.createFile(file, 1024);
        DedicatedDiskSpaceUsage subject = new DedicatedDiskSpaceUsage(DIR);
        Assertions.assertTrue((subject.getUsedSpace() >= 1004L ? 1 : 0) != 0);
    }
}

