/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.io.File;
import java.time.Duration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.fs.DU;
import org.apache.hadoop.hdds.fs.DUFactory;
import org.apache.hadoop.hdds.fs.SaveSpaceUsageToFile;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.TestSpaceUsageFactory;
import org.apache.ozone.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDUFactory {
    @Test
    public void testCreateViaConfig() {
        TestSpaceUsageFactory.testCreateViaConfig(DUFactory.class);
    }

    @Test
    public void testParams() {
        File dir = GenericTestUtils.getTestDir((String)this.getClass().getSimpleName());
        Duration refresh = Duration.ofHours(1L);
        OzoneConfiguration conf = new OzoneConfiguration();
        DUFactory.Conf duConf = (DUFactory.Conf)conf.getObject(DUFactory.Conf.class);
        duConf.setRefreshPeriod(refresh);
        conf.setFromObject((Object)duConf);
        SpaceUsageCheckParams params = new DUFactory().setConfiguration((ConfigurationSource)conf).paramsFor(dir);
        Assertions.assertSame((Object)dir, (Object)params.getDir());
        Assertions.assertEquals((Object)refresh, (Object)params.getRefresh());
        Assertions.assertSame(DU.class, params.getSource().getClass());
        Assertions.assertSame(SaveSpaceUsageToFile.class, params.getPersistence().getClass());
    }
}

