/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.fs;

import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.fs.SpaceUsagePersistence;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;

public final class MockSpaceUsagePersistence {
    public static SpaceUsagePersistence inMemory(AtomicLong target) {
        return new Memory(target);
    }

    private MockSpaceUsagePersistence() {
        throw new UnsupportedOperationException("no instances");
    }

    private static class Memory
    implements SpaceUsagePersistence {
        private final AtomicLong target;

        Memory(AtomicLong target) {
            this.target = target;
        }

        public OptionalLong load() {
            return OptionalLong.of(this.target.get());
        }

        public void save(SpaceUsageSource source) {
            this.target.set(source.getUsedSpace());
        }
    }
}

