/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.SimpleConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestOzoneConfiguration {
    private OzoneConfiguration conf;

    @BeforeEach
    public void setUp() throws Exception {
        this.conf = new OzoneConfiguration();
    }

    private void startConfig(BufferedWriter out) throws IOException {
        out.write("<?xml version=\"1.0\"?>\n");
        out.write("<configuration>\n");
    }

    private void endConfig(BufferedWriter out) throws IOException {
        out.write("</configuration>\n");
        out.flush();
        out.close();
    }

    @Test
    public void testGetAllPropertiesByTags(@TempDir File tempDir) throws Exception {
        File coreDefault = new File(tempDir, "core-default-test.xml");
        File coreSite = new File(tempDir, "core-site-test.xml");
        FileOutputStream coreDefaultStream = new FileOutputStream(coreDefault);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)coreDefaultStream, StandardCharsets.UTF_8));){
            this.startConfig(out);
            this.appendProperty(out, "hadoop.tags.system", "YARN,HDFS,NAMENODE");
            this.appendProperty(out, "hadoop.tags.custom", "MYCUSTOMTAG");
            this.appendPropertyByTag(out, "dfs.cblock.trace.io", "false", "YARN");
            this.appendPropertyByTag(out, "dfs.replication", "1", "HDFS");
            this.appendPropertyByTag(out, "dfs.namenode.logging.level", "INFO", "NAMENODE");
            this.appendPropertyByTag(out, "dfs.random.key", "XYZ", "MYCUSTOMTAG");
            this.endConfig(out);
            Path fileResource = new Path(coreDefault.getAbsolutePath());
            this.conf.addResource(fileResource);
            Assertions.assertEquals((Object)"XYZ", (Object)this.conf.getAllPropertiesByTag("MYCUSTOMTAG").getProperty("dfs.random.key"));
        }
        FileOutputStream coreSiteStream = new FileOutputStream(coreSite);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)coreSiteStream, StandardCharsets.UTF_8));){
            this.startConfig(out);
            this.appendProperty(out, "dfs.random.key", "ABC");
            this.appendProperty(out, "dfs.replication", "3");
            this.appendProperty(out, "dfs.cblock.trace.io", "true");
            this.endConfig(out);
            Path fileResource = new Path(coreSite.getAbsolutePath());
            this.conf.addResource(fileResource);
        }
        Assertions.assertEquals((Object)"3", (Object)this.conf.getAllPropertiesByTag("HDFS").getProperty("dfs.replication"));
        Assertions.assertEquals((Object)"ABC", (Object)this.conf.getAllPropertiesByTag("MYCUSTOMTAG").getProperty("dfs.random.key"));
        Assertions.assertEquals((Object)"true", (Object)this.conf.getAllPropertiesByTag("YARN").getProperty("dfs.cblock.trace.io"));
    }

    @Test
    public void getConfigurationObject() {
        OzoneConfiguration ozoneConfig = new OzoneConfiguration();
        ozoneConfig.set("test.scm.client.address", "address");
        ozoneConfig.set("test.scm.client.bind.host", "host");
        ozoneConfig.setBoolean("test.scm.client.enabled", true);
        ozoneConfig.setInt("test.scm.client.port", 5555);
        ozoneConfig.setTimeDuration("test.scm.client.wait", 10L, TimeUnit.MINUTES);
        ozoneConfig.setTimeDuration("test.scm.client.duration", 3L, TimeUnit.SECONDS);
        ozoneConfig.set("test.scm.client.class", Integer.class.getName());
        ozoneConfig.setDouble("test.scm.client.threshold", 10.5);
        SimpleConfiguration configuration = (SimpleConfiguration)((Object)ozoneConfig.getObject(SimpleConfiguration.class));
        Assertions.assertEquals((Object)"host", (Object)configuration.getBindHost());
        Assertions.assertEquals((Object)"address", (Object)configuration.getClientAddress());
        Assertions.assertTrue((boolean)configuration.isEnabled());
        Assertions.assertEquals((int)5555, (int)configuration.getPort());
        Assertions.assertEquals((long)600L, (long)configuration.getWaitTime());
        Assertions.assertSame(Integer.class, configuration.getMyClass());
        Assertions.assertEquals((double)10.5, (double)configuration.getThreshold());
        Assertions.assertEquals((Object)Duration.ofSeconds(3L), (Object)configuration.getDuration());
    }

    @Test
    public void getConfigurationObjectWithDefault() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        SimpleConfiguration configuration = (SimpleConfiguration)((Object)ozoneConfiguration.getObject(SimpleConfiguration.class));
        Assertions.assertTrue((boolean)configuration.isEnabled());
        Assertions.assertEquals((int)9878, (int)configuration.getPort());
        Assertions.assertSame(Object.class, configuration.getMyClass());
        Assertions.assertEquals((double)10.0, (double)configuration.getThreshold());
        Assertions.assertEquals((Object)Duration.ofHours(1L), (Object)configuration.getDuration());
    }

    @Test
    public void setConfigFromObject() {
        SimpleConfiguration object = new SimpleConfiguration();
        object.setBindHost("host");
        object.setClientAddress("address");
        object.setEnabled(true);
        object.setPort(5555);
        object.setWaitTime(600L);
        object.setMyClass(this.getClass());
        object.setThreshold(10.5);
        object.setDuration(Duration.ofMillis(100L));
        OzoneConfiguration subject = new OzoneConfiguration();
        subject.setFromObject((Object)object);
        Assertions.assertEquals((Object)object.getBindHost(), (Object)subject.get("test.scm.client.bind.host"));
        Assertions.assertEquals((Object)object.getClientAddress(), (Object)subject.get("test.scm.client.address"));
        Assertions.assertEquals((Object)object.isEnabled(), (Object)subject.getBoolean("test.scm.client.enabled", false));
        Assertions.assertEquals((int)object.getPort(), (int)subject.getInt("test.scm.client.port", 0));
        Assertions.assertEquals((long)TimeUnit.SECONDS.toMinutes(object.getWaitTime()), (long)subject.getTimeDuration("test.scm.client.wait", 0L, TimeUnit.MINUTES));
        Assertions.assertSame(this.getClass(), (Object)subject.getClass("test.scm.client.class", null));
        Assertions.assertEquals((double)object.getThreshold(), (double)subject.getDouble("test.scm.client.threshold", 20.5));
        Assertions.assertEquals((long)object.getDuration().toMillis(), (long)subject.getTimeDuration("test.scm.client.duration", 0L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void setConfigFromObjectWithConfigDefaults() {
        OzoneConfiguration subject = new OzoneConfiguration();
        SimpleConfiguration object = (SimpleConfiguration)((Object)subject.getObject(SimpleConfiguration.class));
        subject.setFromObject((Object)object);
        Assertions.assertEquals((Object)"0.0.0.0", (Object)subject.get("test.scm.client.bind.host"));
        Assertions.assertEquals((Object)"localhost", (Object)subject.get("test.scm.client.address"));
        Assertions.assertTrue((boolean)subject.getBoolean("test.scm.client.enabled", false));
        Assertions.assertEquals((int)9878, (int)subject.getInt("test.scm.client.port", 123));
        Assertions.assertEquals((long)TimeUnit.MINUTES.toSeconds(30L), (long)subject.getTimeDuration("test.scm.client.wait", 555L, TimeUnit.SECONDS));
        Assertions.assertEquals((double)10.0, (double)subject.getDouble("test.scm.client.threshold", 20.5));
    }

    @Test
    public void testInstantiationWithInputConfiguration(@TempDir File tempDir) throws IOException {
        String key = "hdds.scm.init.default.layout.version";
        String val = "Test1";
        Configuration configuration = new Configuration(true);
        File ozoneSite = new File(tempDir, "ozone-site.xml");
        FileOutputStream ozoneSiteStream = new FileOutputStream(ozoneSite);
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)ozoneSiteStream, StandardCharsets.UTF_8));){
            this.startConfig(out);
            this.appendProperty(out, key, val);
            this.endConfig(out);
        }
        configuration.addResource(new URL("file:///" + ozoneSite.getAbsolutePath()));
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration(configuration);
        Assertions.assertEquals((Object)val, (Object)ozoneConfiguration.get(key));
        Assertions.assertEquals((Object)val, (Object)configuration.get(key));
        Assertions.assertNotEquals((Object)val, (Object)new OzoneConfiguration().get(key));
    }

    @Test
    public void setConfigFromObjectWithObjectDefaults() {
        SimpleConfiguration object = new SimpleConfiguration();
        OzoneConfiguration subject = new OzoneConfiguration();
        subject.setFromObject((Object)object);
        Assertions.assertEquals((Object)"0.0.0.0", (Object)subject.get("test.scm.client.bind.host"));
        Assertions.assertEquals((Object)"localhost", (Object)subject.get("test.scm.client.address"));
        Assertions.assertFalse((boolean)subject.getBoolean("test.scm.client.enabled", false));
        Assertions.assertEquals((int)0, (int)subject.getInt("test.scm.client.port", 123));
        Assertions.assertEquals((long)0L, (long)subject.getTimeDuration("test.scm.client.wait", 555L, TimeUnit.SECONDS));
        Assertions.assertEquals((double)0.0, (double)subject.getDouble("test.scm.client.threshold", 20.5));
    }

    @Test
    public void postConstructValidation() {
        OzoneConfiguration ozoneConfiguration = new OzoneConfiguration();
        ozoneConfiguration.setInt("test.scm.client.port", -3);
        Assertions.assertThrows(NumberFormatException.class, () -> {
            SimpleConfiguration cfr_ignored_0 = (SimpleConfiguration)((Object)((Object)ozoneConfiguration.getObject(SimpleConfiguration.class)));
        });
    }

    @ParameterizedTest
    @EnumSource
    void tagIsRecognized(ConfigTag tag) {
        OzoneConfiguration subject = new OzoneConfiguration();
        Assertions.assertTrue((boolean)subject.isPropertyTag(tag.name()), () -> tag + " should be recognized as config tag");
    }

    @Test
    void unknownTag() {
        OzoneConfiguration subject = new OzoneConfiguration();
        Assertions.assertFalse((boolean)subject.isPropertyTag("not-a-tag"));
    }

    private void appendProperty(BufferedWriter out, String name, String val) throws IOException {
        this.appendProperty(out, name, val, false);
    }

    private void appendProperty(BufferedWriter out, String name, String val, boolean isFinal) throws IOException {
        out.write("<property>");
        out.write("<name>");
        out.write(name);
        out.write("</name>");
        out.write("<value>");
        out.write(val);
        out.write("</value>");
        if (isFinal) {
            out.write("<final>true</final>");
        }
        out.write("</property>\n");
    }

    private void appendPropertyByTag(BufferedWriter out, String name, String val, String tags) throws IOException {
        this.appendPropertyByTag(out, name, val, false, tags);
    }

    private void appendPropertyByTag(BufferedWriter out, String name, String val, boolean isFinal, String tag) throws IOException {
        out.write("<property>");
        out.write("<name>");
        out.write(name);
        out.write("</name>");
        out.write("<value>");
        out.write(val);
        out.write("</value>");
        if (isFinal) {
            out.write("<final>true</final>");
        }
        out.write("<tag>");
        out.write(tag);
        out.write("</tag>");
        out.write("</property>\n");
    }
}

