/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.conf;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.apache.hadoop.hdds.conf.SimpleConfigurationParent;

@ConfigGroup(prefix="test.scm.client")
public class SimpleConfiguration
extends SimpleConfigurationParent {
    @Config(key="address", defaultValue="localhost", description="Client address (To test string injection).", tags={ConfigTag.MANAGEMENT})
    private String clientAddress;
    @Config(key="bind.host", defaultValue="0.0.0.0", description="Bind host(To test string injection).", tags={ConfigTag.MANAGEMENT})
    private String bindHost;
    @Config(key="compression.enabled", defaultValue="true", reconfigurable=true, description="Compression enabled. (Just to test boolean flag)", tags={ConfigTag.MANAGEMENT})
    private boolean compressionEnabled;
    @Config(key="port", defaultValue="9878", description="Port number config (To test int injection)", tags={ConfigTag.MANAGEMENT})
    private int port;
    @Config(key="wait", type=ConfigType.TIME, timeUnit=TimeUnit.SECONDS, defaultValue="30m", reconfigurable=true, description="Wait time (To test TIME config type)", tags={ConfigTag.MANAGEMENT})
    private long waitTime;
    @Config(key="duration", type=ConfigType.TIME, timeUnit=TimeUnit.MINUTES, defaultValue="1h", description="N/A", tags={ConfigTag.MANAGEMENT})
    private Duration duration;
    @Config(key="class", type=ConfigType.CLASS, defaultValue="java.lang.Object", description="", tags={ConfigTag.OZONE})
    private Class<?> myClass = Object.class;
    @Config(key="threshold", type=ConfigType.DOUBLE, defaultValue="10", description="Threshold (To test DOUBLE config type)", tags={ConfigTag.MANAGEMENT})
    private double threshold;

    @PostConstruct
    public void validate() {
        if (this.port < 0) {
            throw new NumberFormatException("Please use a positive port number");
        }
        if (this.waitTime < 42L) {
            throw new IllegalArgumentException("Wait time less than 42 seconds: " + this.waitTime);
        }
    }

    public void setClientAddress(String clientAddress) {
        this.clientAddress = clientAddress;
    }

    public void setBindHost(String bindHost) {
        this.bindHost = bindHost;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public String getBindHost() {
        return this.bindHost;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public int getPort() {
        return this.port;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public Class<?> getMyClass() {
        return this.myClass;
    }

    public void setMyClass(Class<?> aClass) {
        this.myClass = aClass;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }
}

