/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfigValidator;
import org.apache.hadoop.hdds.client.StandaloneReplicationConfig;
import org.apache.hadoop.hdds.conf.InMemoryConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
class TestReplicationConfigValidator {
    private ReplicationConfigValidator defaultValidator;
    private ReplicationConfigValidator disabledValidator;

    TestReplicationConfigValidator() {
    }

    @BeforeAll
    void setup() {
        this.defaultValidator = (ReplicationConfigValidator)new InMemoryConfiguration().getObject(ReplicationConfigValidator.class);
        InMemoryConfiguration disabled = new InMemoryConfiguration();
        disabled.set("ozone.replication.allowed-configs", "");
        this.disabledValidator = (ReplicationConfigValidator)disabled.getObject(ReplicationConfigValidator.class);
    }

    static List<String> validConfigsForEC() {
        LinkedList<String> configs = new LinkedList<String>();
        for (ECReplicationConfig.EcCodec codec : ECReplicationConfig.EcCodec.values()) {
            for (String dataParity : Arrays.asList("3-2", "6-3", "10-4")) {
                String[] parts = dataParity.split("-");
                int data = Integer.parseInt(parts[0]);
                int parity = Integer.parseInt(parts[1]);
                for (int chunkSize : Arrays.asList(512, 1024, 2048, 4096)) {
                    ECReplicationConfig config = new ECReplicationConfig(data, parity, codec, chunkSize * 1024);
                    configs.add(config.getReplication());
                }
            }
        }
        return configs;
    }

    static String[] invalidConfigsForEC() {
        return new String[]{"rs-6-4-1024k", "xor-3-2-1024", "rs-6-3-1234k"};
    }

    @Test
    void acceptsRatis() {
        this.defaultValidator.validate((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE));
        this.defaultValidator.validate((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE));
    }

    @Test
    void acceptsStandalone() {
        this.defaultValidator.validate((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE));
        this.defaultValidator.validate((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE));
    }

    @ParameterizedTest
    @MethodSource(value={"validConfigsForEC"})
    void acceptsValidEC(String config) {
        this.defaultValidator.validate((ReplicationConfig)new ECReplicationConfig(config));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidConfigsForEC"})
    void rejectsInvalidEC(String config) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.defaultValidator.validate((ReplicationConfig)new ECReplicationConfig(config)));
    }

    @ParameterizedTest
    @MethodSource(value={"invalidConfigsForEC"})
    void disabledAcceptsInvalidEC(String config) {
        this.disabledValidator.validate((ReplicationConfig)new ECReplicationConfig(config));
    }

    @Test
    void disabledAcceptsRatis() {
        this.disabledValidator.validate((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE));
        this.disabledValidator.validate((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE));
    }

    @Test
    void disabledAcceptsStandalone() {
        this.disabledValidator.validate((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE));
        this.disabledValidator.validate((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE));
        this.disabledValidator.validate((ReplicationConfig)StandaloneReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ZERO));
    }

    @Test
    void testCustomValidation() {
        InMemoryConfiguration config = new InMemoryConfiguration();
        config.set("ozone.replication.allowed-configs", "RATIS/THREE");
        ReplicationConfigValidator validator = (ReplicationConfigValidator)config.getObject(ReplicationConfigValidator.class);
        validator.validate((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE));
        Assertions.assertThrows(IllegalArgumentException.class, () -> validator.validate((ReplicationConfig)RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.ONE)));
    }
}

