/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

class TestECReplicationConfig {
    TestECReplicationConfig() {
    }

    @Test
    void testSuccessfulStringParsing() {
        HashMap<String, ECReplicationConfig> valid = new HashMap<String, ECReplicationConfig>();
        valid.put("rs-3-2-1024", new ECReplicationConfig(3, 2, ECReplicationConfig.EcCodec.RS, 1024));
        valid.put("RS-3-2-1024", new ECReplicationConfig(3, 2, ECReplicationConfig.EcCodec.RS, 1024));
        valid.put("rs-3-2-1024k", new ECReplicationConfig(3, 2, ECReplicationConfig.EcCodec.RS, 0x100000));
        valid.put("rs-3-2-1024K", new ECReplicationConfig(3, 2, ECReplicationConfig.EcCodec.RS, 0x100000));
        valid.put("xor-10-4-1", new ECReplicationConfig(10, 4, ECReplicationConfig.EcCodec.XOR, 1));
        valid.put("XOR-6-3-12345", new ECReplicationConfig(6, 3, ECReplicationConfig.EcCodec.XOR, 12345));
        for (Map.Entry e : valid.entrySet()) {
            ECReplicationConfig ec = new ECReplicationConfig((String)e.getKey());
            Assertions.assertEquals((int)((ECReplicationConfig)e.getValue()).getData(), (int)ec.getData());
            Assertions.assertEquals((int)((ECReplicationConfig)e.getValue()).getParity(), (int)ec.getParity());
            Assertions.assertEquals((Object)((ECReplicationConfig)e.getValue()).getCodec(), (Object)ec.getCodec());
            Assertions.assertEquals((int)((ECReplicationConfig)e.getValue()).getEcChunkSize(), (int)ec.getEcChunkSize());
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"3-2-1024", "rss-3-2-1024", "rs-3-0-1024", "rs-3-2-0k", "rs-3-2", "x3-2"})
    void testUnsuccessfulStringParsing(String invalidValue) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ECReplicationConfig(invalidValue));
    }

    @Test
    void testSerializeToProtoAndBack() {
        ECReplicationConfig orig = new ECReplicationConfig(6, 3, ECReplicationConfig.EcCodec.XOR, 1024);
        HddsProtos.ECReplicationConfig proto = orig.toProto();
        ECReplicationConfig recovered = new ECReplicationConfig(proto);
        Assertions.assertEquals((int)orig.getData(), (int)recovered.getData());
        Assertions.assertEquals((int)orig.getParity(), (int)recovered.getParity());
        Assertions.assertEquals((Object)orig.getCodec(), (Object)recovered.getCodec());
        Assertions.assertEquals((int)orig.getEcChunkSize(), (int)recovered.getEcChunkSize());
        Assertions.assertEquals((Object)orig, (Object)recovered);
    }
}

