/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.resource.spi.se;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import javax.annotation.Resource;
import javax.enterprise.inject.Produces;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.resource.spi.se.StandaloneResourceProcessor;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.SecurityUtil;

public class StandaloneResourceInjectionService
implements ResourceInjectionService {
    private final StandaloneResourceProcessor processor = StandaloneResourceProcessor.getProcessor();
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(StandaloneResourceInjectionService.class);

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        if (resourceReference.supports(Resource.class)) {
            Resource resource = (Resource)resourceReference.getAnnotation(Resource.class);
            return this.processor.getResource(resource, resourceReference.getResourceType());
        }
        if (resourceReference.supports(WebServiceRef.class)) {
            WebServiceRef resource = (WebServiceRef)resourceReference.getAnnotation(WebServiceRef.class);
            return this.processor.getWebServiceResource(resource, resourceReference.getResourceType());
        }
        if (resourceReference.supports(PersistenceContext.class)) {
            PersistenceContext persistenceContext = (PersistenceContext)resourceReference.getAnnotation(PersistenceContext.class);
            return this.processor.getEntityManager(persistenceContext, resourceReference.getResourceType());
        }
        if (resourceReference.supports(PersistenceUnit.class)) {
            PersistenceUnit persistenceUnit = (PersistenceUnit)resourceReference.getAnnotation(PersistenceUnit.class);
            return this.processor.getEntityManagerFactory(persistenceUnit, resourceReference.getResourceType());
        }
        return null;
    }

    public void injectJavaEEResources(Object managedBeanInstance) throws Exception {
        Field[] fields;
        for (Field field : fields = SecurityUtil.doPrivilegedGetDeclaredFields(managedBeanInstance.getClass())) {
            Annotation ann;
            if (field.isAnnotationPresent(Produces.class) || Modifier.isStatic(field.getModifiers()) || (ann = AnnotationUtil.hasOwbInjectableResource((Annotation[])field.getDeclaredAnnotations())) == null) continue;
            ResourceReference resourceRef = new ResourceReference(field.getDeclaringClass(), field.getName(), field.getType(), ann);
            boolean acess = field.isAccessible();
            try {
                SecurityUtil.doPrivilegedSetAccessible((AccessibleObject)field, (boolean)true);
                field.set(managedBeanInstance, this.getResourceReference(resourceRef));
            }
            catch (Exception e) {
                logger.error("ERROR_0025", (Throwable)e, new Object[]{field});
                throw new WebBeansException(MessageFormat.format(logger.getTokenString("ERROR_0025"), field), (Throwable)e);
            }
            finally {
                SecurityUtil.doPrivilegedSetAccessible((AccessibleObject)field, (boolean)acess);
            }
        }
    }

    public void clear() {
        this.processor.clear();
    }
}

