/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.resource.spi.se;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Resource;
import javax.enterprise.inject.Produces;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.apache.webbeans.api.ResourceReference;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.resource.spi.se.StandaloneResourceProcessor;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.util.AnnotationUtil;

public class StandaloneResourceInjectionService
implements ResourceInjectionService {
    private static final StandaloneResourceProcessor processor = StandaloneResourceProcessor.getProcessor();
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(StandaloneResourceInjectionService.class);

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        if (resourceReference.supports(Resource.class)) {
            Resource resource = (Resource)resourceReference.getAnnotation(Resource.class);
            return processor.getResource(resource, resourceReference.getResourceType());
        }
        if (resourceReference.supports(WebServiceRef.class)) {
            return null;
        }
        if (resourceReference.supports(PersistenceContext.class)) {
            PersistenceContext persistenceContext = (PersistenceContext)resourceReference.getAnnotation(PersistenceContext.class);
            return processor.getEntityManager(persistenceContext, resourceReference.getResourceType());
        }
        if (resourceReference.supports(PersistenceUnit.class)) {
            PersistenceUnit persistenceUnit = (PersistenceUnit)resourceReference.getAnnotation(PersistenceUnit.class);
            return processor.getEntityManagerFactory(persistenceUnit, resourceReference.getResourceType());
        }
        return null;
    }

    public void injectJavaEEResources(Object managedBeanInstance) throws Exception {
        Field[] fields;
        for (Field field : fields = managedBeanInstance.getClass().getDeclaredFields()) {
            Annotation ann;
            if (field.isAnnotationPresent(Produces.class) || Modifier.isStatic(field.getModifiers()) || (ann = AnnotationUtil.hasOwbInjectableResource((Annotation[])field.getDeclaredAnnotations())) == null) continue;
            ResourceReference resourceRef = new ResourceReference(field.getDeclaringClass(), field.getName(), field.getType(), ann);
            boolean acess = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(managedBeanInstance, this.getResourceReference(resourceRef));
            }
            catch (Exception e) {
                logger.error("Unable to inject field : " + field, (Throwable)e);
                throw new WebBeansException("Unable to inject field : " + field, (Throwable)e);
            }
            finally {
                field.setAccessible(acess);
            }
        }
    }

    public void clear() {
        processor.clear();
    }
}

