/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.Nonbinding;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.deployment.stereotype.IStereoTypeModel;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ArrayUtil;
import org.apache.webbeans.util.Asserts;

public final class AnnotationManager {
    private Map<Class<? extends Annotation>, Boolean> checkedQualifierAnnotations = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();
    private Map<Class<? extends Annotation>, Boolean> checkedStereotypeAnnotations = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();
    private final BeanManagerImpl beanManagerImpl;
    private final WebBeansContext webBeansContext;
    private final boolean strictValidation;

    public AnnotationManager(WebBeansContext context) {
        this.webBeansContext = context;
        this.beanManagerImpl = context.getBeanManagerImpl();
        this.strictValidation = context.getOpenWebBeansConfiguration().strictDynamicValidation();
    }

    public Annotation getDeclaredScopeAnnotation(Class<?> beanClass) {
        for (Annotation annotation : beanClass.getDeclaredAnnotations()) {
            if (!this.beanManagerImpl.isScope(annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    public boolean isInterceptorBindingAnnotation(Class<? extends Annotation> clazz) {
        Asserts.nullCheckForClass(clazz);
        return clazz.isAnnotationPresent(InterceptorBinding.class) || this.webBeansContext.getInterceptorsManager().hasInterceptorBindingType(clazz);
    }

    public Set<Annotation> getInterceptorAnnotations(Set<Annotation> typeAnns) {
        Annotation[] anns;
        HashMap<Class<? extends Annotation>, Annotation> bindings = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation ann : anns = this.getInterceptorBindingMetaAnnotations(typeAnns)) {
            Annotation oldBinding = (Annotation)bindings.get(ann.annotationType());
            if (oldBinding != null && !AnnotationUtil.isCdiAnnotationEqual(oldBinding, ann)) {
                throw new WebBeansConfigurationException("Illegal interceptor binding: annotation of type " + ann.annotationType().getName() + " is present twice with diffenent values: " + oldBinding.toString() + " and " + ann.toString());
            }
            bindings.put(ann.annotationType(), ann);
        }
        Annotation[] stereoTypes = this.getStereotypeMetaAnnotations(typeAnns.toArray(new Annotation[typeAnns.size()]));
        HashMap<Class<? extends Annotation>, Annotation> annotationsFromSteretypes = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation stereoType : stereoTypes) {
            Annotation[] steroInterceptorBindings;
            if (!this.hasInterceptorBindingMetaAnnotation(stereoType.annotationType().getDeclaredAnnotations())) continue;
            for (Annotation ann : steroInterceptorBindings = this.getInterceptorBindingMetaAnnotations(stereoType.annotationType().getDeclaredAnnotations())) {
                Annotation oldBinding = (Annotation)bindings.get(ann.annotationType());
                if (oldBinding == null) {
                    bindings.put(ann.annotationType(), ann);
                } else if (annotationsFromSteretypes.containsKey(ann.annotationType()) && !AnnotationUtil.isCdiAnnotationEqual(oldBinding, ann)) {
                    throw new WebBeansConfigurationException("Illegal interceptor binding: annotation of type " + ann.annotationType().getName() + " is present twice with diffenent values: " + oldBinding.toString() + " and " + ann.toString());
                }
                annotationsFromSteretypes.put(ann.annotationType(), ann);
            }
        }
        return new HashSet<Annotation>(bindings.values());
    }

    public boolean hasInterceptorBindingMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "Annotation");
        for (Annotation ann : anns) {
            if (!this.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getInterceptorBindingMetaAnnotations(Set<Annotation> anns) {
        return this.getInterceptorBindingMetaAnnotations(AnnotationUtil.asArray(anns));
    }

    public Annotation[] getInterceptorBindingMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "Annotation");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            if (ann.annotationType().getName().startsWith("java.lang.") || !this.isInterceptorBindingAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            Annotation[] transitives = this.getInterceptorBindingMetaAnnotations(ann.annotationType().getDeclaredAnnotations());
            Collections.addAll(interAnns, transitives);
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    public boolean isQualifierAnnotation(Class<? extends Annotation> clazz) {
        Boolean checkedAnnotationResult = this.checkedQualifierAnnotations.get(clazz);
        if (checkedAnnotationResult != null) {
            return checkedAnnotationResult;
        }
        boolean result = false;
        Asserts.nullCheckForClass(clazz);
        if (clazz.isAnnotationPresent(Qualifier.class)) {
            result = true;
        } else if (this.beanManagerImpl.getAdditionalQualifiers().contains(clazz)) {
            result = true;
        }
        this.checkedQualifierAnnotations.put(clazz, result);
        return result;
    }

    public <X> Annotation[] getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(AnnotatedMethod<X> annotatedMethod, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(annotatedMethod, "annotatedMethod");
        Asserts.nullCheckForClass(clazz);
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        List parameters = annotatedMethod.getParameters();
        for (AnnotatedParameter parameter : parameters) {
            Annotation[] anns;
            if (!parameter.isAnnotationPresent(clazz)) continue;
            for (Annotation ann : anns = AnnotationUtil.asArray(parameter.getAnnotations())) {
                if (!this.isQualifierAnnotation(ann.annotationType())) continue;
                list.add(ann);
            }
        }
        Annotation[] finalAnns = new Annotation[list.size()];
        finalAnns = list.toArray(finalAnns);
        return finalAnns;
    }

    public Annotation[] getMethodFirstParameterQualifierWithGivenAnnotation(Method method, Class<? extends Annotation> clazz) {
        Asserts.assertNotNull(method, "Method");
        Asserts.nullCheckForClass(clazz);
        Annotation[][] parameterAnns = method.getParameterAnnotations();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation[] parameters : parameterAnns) {
            boolean found = false;
            for (Annotation param : parameters) {
                Class<? extends Annotation> btype = param.annotationType();
                if (btype.equals(clazz)) {
                    found = true;
                    continue;
                }
                if (!this.isQualifierAnnotation(btype)) continue;
                list.add(param);
            }
            if (!found) continue;
            Annotation[] result = new Annotation[list.size()];
            result = list.toArray(result);
            return result;
        }
        Annotation[] result = AnnotationUtil.EMPTY_ANNOTATION_ARRAY;
        return result;
    }

    public Annotation[] getQualifierAnnotations(Annotation ... annotations) {
        Set<Annotation> qualifiers = this.getQualifierAnnotations(Arrays.asList(annotations));
        return qualifiers.toArray(new Annotation[qualifiers.size()]);
    }

    public Set<Annotation> getQualifierAnnotations(Collection<Annotation> anns) {
        Asserts.assertNotNull(anns, "Annotation");
        if (anns.isEmpty()) {
            return DefaultLiteral.SET;
        }
        HashSet<Annotation> set = new HashSet<Annotation>();
        for (Annotation annot : anns) {
            if (!this.isQualifierAnnotation(annot.annotationType())) continue;
            set.add(annot);
        }
        if (set.isEmpty()) {
            return DefaultLiteral.SET;
        }
        return set;
    }

    public void checkQualifierConditions(Annotation ... qualifierAnnots) {
        Set<Annotation> annSet;
        if (qualifierAnnots == null || qualifierAnnots.length == 0) {
            return;
        }
        if (qualifierAnnots.length == 1) {
            this.checkQualifierConditions(qualifierAnnots[0]);
        }
        if (qualifierAnnots.length != (annSet = ArrayUtil.asSet(qualifierAnnots)).size()) {
            throw new IllegalArgumentException("Qualifier annotations can not contain duplicate qualifiers:" + Arrays.toString(qualifierAnnots));
        }
        this.checkQualifierConditions(annSet);
    }

    public void checkQualifierConditions(Set<Annotation> qualifierAnnots) {
        HashSet<Class<? extends Annotation>> usedQualifiers = this.strictValidation ? new HashSet<Class<? extends Annotation>>(qualifierAnnots.size()) : null;
        for (Annotation ann : qualifierAnnots) {
            if (usedQualifiers != null && usedQualifiers.contains(ann.annotationType()) && ann.annotationType().getAnnotation(Repeatable.class) == null) {
                throw new IllegalArgumentException("Qualifier list must not contain multiple annotations or the same non-Repeatable type: " + ann.annotationType().getName());
            }
            if (usedQualifiers != null) {
                usedQualifiers.add(ann.annotationType());
            }
            this.checkQualifierConditions(ann);
        }
    }

    private void checkQualifierConditions(Annotation ann) {
        Method[] methods;
        if (ann == DefaultLiteral.INSTANCE || ann == AnyLiteral.INSTANCE || ann.annotationType().equals(Default.class) || ann.annotationType().equals(Any.class) || ann.annotationType().equals(Named.class)) {
            return;
        }
        for (Method method : methods = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(ann.annotationType())) {
            Class<?> clazz = method.getReturnType();
            if (!clazz.isArray() && !clazz.isAnnotation() || AnnotationUtil.hasAnnotation(method.getDeclaredAnnotations(), Nonbinding.class)) continue;
            throw new WebBeansConfigurationException("@Qualifier : " + ann.annotationType().getName() + " must have @NonBinding valued members for its array-valued and annotation valued members");
        }
        if (!this.isQualifierAnnotation(ann.annotationType())) {
            throw new IllegalArgumentException("Qualifier annotations must be annotated with @Qualifier");
        }
    }

    public boolean isStereoTypeAnnotation(Class<? extends Annotation> clazz) {
        return this.isStereoTypeAnnotation(clazz, new HashSet<Class<? extends Annotation>>());
    }

    private boolean isStereoTypeAnnotation(Class<? extends Annotation> clazz, Set<Class<? extends Annotation>> checkedAnnotations) {
        Asserts.nullCheckForClass(clazz);
        Boolean checkedAnnotationResult = this.checkedStereotypeAnnotations.get(clazz);
        if (checkedAnnotationResult != null) {
            return checkedAnnotationResult;
        }
        boolean result = false;
        if (clazz.isAnnotationPresent(Stereotype.class) || this.webBeansContext.getStereoTypeManager().getStereoTypeModel(clazz.getName()) != null) {
            result = true;
        } else {
            for (Annotation annotation : clazz.getAnnotations()) {
                if (checkedAnnotations.contains(annotation.annotationType())) continue;
                checkedAnnotations.add(annotation.annotationType());
                if (!this.isStereoTypeAnnotation(annotation.annotationType(), checkedAnnotations)) continue;
                result = true;
                break;
            }
        }
        this.checkedStereotypeAnnotations.put(clazz, result);
        return result;
    }

    public boolean hasStereoTypeMetaAnnotation(Set<Class<? extends Annotation>> anns) {
        Asserts.assertNotNull(anns, "Annotation");
        for (Class<? extends Annotation> ann : anns) {
            if (!this.isStereoTypeAnnotation(ann)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStereoTypeMetaAnnotation(Annotation[] anns) {
        Asserts.assertNotNull(anns, "Annotation");
        for (Annotation ann : anns) {
            if (!this.isStereoTypeAnnotation(ann.annotationType())) continue;
            return true;
        }
        return false;
    }

    public Annotation[] getStereotypeMetaAnnotations(Annotation[] anns) {
        Asserts.assertNotNull(anns, "Annotation");
        ArrayList<Annotation> interAnns = new ArrayList<Annotation>();
        for (Annotation ann : anns) {
            if (!this.isStereoTypeAnnotation(ann.annotationType())) continue;
            interAnns.add(ann);
            Annotation[] transitives = this.getTransitiveStereoTypes(ann.annotationType().getDeclaredAnnotations());
            Collections.addAll(interAnns, transitives);
        }
        Annotation[] ret = new Annotation[interAnns.size()];
        ret = interAnns.toArray(ret);
        return ret;
    }

    public Set<Class<? extends Annotation>> getStereotypeMetaAnnotations(Set<Class<? extends Annotation>> stereotypes) {
        Asserts.assertNotNull(stereotypes, "Annotation");
        HashSet<Class<? extends Annotation>> interAnns = new HashSet<Class<? extends Annotation>>();
        for (Class<? extends Annotation> ann : stereotypes) {
            Annotation[] transitives;
            if (!this.isStereoTypeAnnotation(ann)) continue;
            interAnns.add(ann);
            for (Annotation transitive : transitives = this.getTransitiveStereoTypes(ann.getDeclaredAnnotations())) {
                interAnns.add(transitive.annotationType());
            }
        }
        return interAnns;
    }

    private Annotation[] getTransitiveStereoTypes(Annotation[] anns) {
        return this.getStereotypeMetaAnnotations(anns);
    }

    public Set<Class<? extends Annotation>> getStereotypes(Set<Class<? extends Annotation>> anns) {
        Asserts.assertNotNull(anns, "Annotation");
        if (this.hasStereoTypeMetaAnnotation(anns)) {
            return this.getStereotypeMetaAnnotations(anns);
        }
        return Collections.emptySet();
    }

    public boolean hasNamedOnStereoTypes(Set<Class<? extends Annotation>> stereotypes) {
        Set<Class<? extends Annotation>> types = this.getStereotypes(stereotypes);
        for (Class<? extends Annotation> ann : types) {
            if (AnnotationUtil.hasClassAnnotation(ann, Named.class)) {
                return true;
            }
            IStereoTypeModel model = this.webBeansContext.getStereoTypeManager().getStereoTypeModel(ann.getName());
            if (model == null || !model.isNamed()) continue;
            return true;
        }
        return false;
    }

    public void checkStereoTypeClass(Class<? extends Annotation> clazz, Annotation ... annotations) {
        Asserts.nullCheckForClass(clazz);
        boolean scopeTypeFound = false;
        for (Annotation annotation : annotations) {
            Named name;
            Class<? extends Annotation> annotType = annotation.annotationType();
            if (annotType.isAnnotationPresent(NormalScope.class) || annotType.isAnnotationPresent(Scope.class)) {
                if (scopeTypeFound) {
                    throw new WebBeansConfigurationException("@StereoType annotation can not contain more than one @Scope/@NormalScope annotation");
                }
                scopeTypeFound = true;
                continue;
            }
            if (!annotType.equals(Named.class) || (name = (Named)annotation).value().equals("")) continue;
            throw new WebBeansConfigurationException("@StereoType annotation can not define @Named annotation with value");
        }
        this.checkedStereotypeAnnotations.remove(clazz);
    }

    public void checkInterceptorResolverParams(Annotation ... interceptorBindings) {
        if (interceptorBindings == null || interceptorBindings.length == 0) {
            throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array argument can not be empty");
        }
        HashSet<Class<? extends Annotation>> usedInterceptors = this.strictValidation ? new HashSet<Class<? extends Annotation>>(interceptorBindings.length) : null;
        for (Annotation interceptorBinding : interceptorBindings) {
            if (!this.isInterceptorBindingAnnotation(interceptorBinding.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveInterceptors() method parameter interceptor bindings array can not contain other annotation that is not @InterceptorBinding");
            }
            if (usedInterceptors != null && usedInterceptors.contains(interceptorBinding.annotationType()) && interceptorBinding.annotationType().getAnnotation(Repeatable.class) == null) {
                throw new IllegalArgumentException("InterceptorBinding list must not contain multiple annotations or the same non-Repeatable type: " + interceptorBinding.annotationType().getName());
            }
            if (usedInterceptors == null) continue;
            usedInterceptors.add(interceptorBinding.annotationType());
        }
    }

    public void checkDecoratorResolverParams(Set<Type> apiTypes, Annotation ... qualifiers) {
        this.checkQualifiersParams(apiTypes, qualifiers);
        Annotation old = null;
        for (Annotation qualifier : qualifiers) {
            if (old == null) {
                old = qualifier;
                continue;
            }
            if (old.annotationType().equals(qualifier.annotationType())) {
                throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array argument can not define duplicate qualifier annotation with name : @" + old.annotationType().getName());
            }
            old = qualifier;
        }
    }

    public void checkQualifiersParams(Set<Type> apiTypes, Annotation ... qualifiers) {
        if (apiTypes == null || apiTypes.size() == 0) {
            throw new IllegalArgumentException("method parameter api types argument can not be empty");
        }
        for (Annotation qualifier : qualifiers) {
            if (this.isQualifierAnnotation(qualifier.annotationType())) continue;
            throw new IllegalArgumentException("Manager.resolveDecorators() method parameter qualifiers array can not contain other annotation that is not @Qualifier");
        }
    }

    public Annotation[] checkForNewQualifierForDeployment(Type type, Class<?> clazz, String name, Annotation[] annotations) {
        Asserts.assertNotNull(type, "Type argument");
        Asserts.nullCheckForClass(clazz);
        Asserts.assertNotNull(annotations, "Annotations argument");
        Annotation[] as = this.getQualifierAnnotations(annotations);
        for (Annotation a : annotations) {
            if (!a.annotationType().equals(New.class) || as.length <= 1) continue;
            throw new WebBeansConfigurationException("@New binding annotation can not have any binding annotation in class : " + clazz.getName() + " in field/method : " + name);
        }
        return as;
    }

    public boolean isSuperMethodNamed(AbstractOwbBean<?> component, Method method, Method superMethod) {
        Asserts.assertNotNull(component, "component");
        Asserts.assertNotNull(method, "method");
        Asserts.assertNotNull(superMethod, "superMethod");
        boolean hasName = false;
        if (AnnotationUtil.hasMethodAnnotation(superMethod, Named.class)) {
            hasName = true;
        } else {
            Annotation[] anns;
            for (Annotation ann : anns = this.getStereotypeMetaAnnotations(superMethod.getAnnotations())) {
                if (!ann.annotationType().isAnnotationPresent(Stereotype.class)) continue;
                hasName = true;
                break;
            }
        }
        if (hasName && AnnotationUtil.hasMethodAnnotation(method, Named.class)) {
            throw new WebBeansConfigurationException("Specialized method : " + method.getName() + " in class : " + component.getReturnType().getName() + " may not define @Named annotation");
        }
        return hasName;
    }

    public <X> Method getDisposalWithGivenAnnotatedMethod(AnnotatedType<X> annotatedType, Type beanType, Annotation[] qualifiers) {
        Set<AnnotatedMethod<X>> annotatedMethods = this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(annotatedType);
        if (annotatedMethods != null) {
            for (AnnotatedMethod<X> annotatedMethod : annotatedMethods) {
                AnnotatedMethod<X> annt = annotatedMethod;
                List parameters = annt.getParameters();
                if (parameters == null) continue;
                boolean found = false;
                for (AnnotatedParameter parameter : parameters) {
                    if (!parameter.isAnnotationPresent(Disposes.class)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                Type type = AnnotationUtil.getFirstAnnotatedParameter(annotatedMethod, Disposes.class).getBaseType();
                Annotation[] annots = this.getAnnotatedMethodFirstParameterQualifierWithGivenAnnotation(annotatedMethod, Disposes.class);
                if (!type.equals(beanType)) continue;
                for (Annotation qualifier : qualifiers) {
                    if (qualifier.annotationType() == Default.class) continue;
                    for (Annotation ann : annots) {
                        if (AnnotationUtil.isCdiAnnotationEqual(qualifier, ann)) continue;
                        return null;
                    }
                }
                return annotatedMethod.getJavaMember();
            }
        }
        return null;
    }

    public void checkInjectionPointForInjectInjectionPoint(Class<?> clazz) {
        Field[] fields;
        Asserts.nullCheckForClass(clazz);
        for (Field field : fields = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredFields(clazz)) {
            Annotation[] anns;
            if (field.getAnnotation(Inject.class) == null || field.getType() != InjectionPoint.class || !AnnotationUtil.hasAnnotation(anns = this.getQualifierAnnotations(field.getDeclaredAnnotations()), Default.class)) continue;
            throw new WebBeansConfigurationException("Java EE Component class :  " + clazz + " can not inject InjectionPoint");
        }
    }

    public Method getRepeatableMethod(Class<?> type) {
        Method value;
        try {
            value = type.getMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        if (!value.getReturnType().isArray()) {
            return null;
        }
        Class<?> componentType = value.getReturnType().getComponentType();
        Repeatable repeatable = componentType.getAnnotation(Repeatable.class);
        if (repeatable == null || repeatable.value() != type) {
            return null;
        }
        return value;
    }
}

