/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.configurator.BeanAttributesConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.BeanAttributesConfiguratorImpl;
import org.apache.webbeans.portable.events.EventBase;

public class ProcessBeanAttributesImpl<T>
extends EventBase
implements ProcessBeanAttributes<T> {
    private final WebBeansContext webBeansContext;
    private Annotated annotated;
    private BeanAttributes<T> attributes;
    private boolean veto;
    private Throwable definitionError;
    private boolean ignoreFinalMethods;
    private BeanAttributesConfiguratorImpl beanAttributesConfigurator;

    public ProcessBeanAttributesImpl(WebBeansContext webBeansContext, Annotated annotated, BeanAttributes<T> attributes) {
        this.webBeansContext = webBeansContext;
        this.annotated = annotated;
        this.attributes = attributes;
    }

    public Annotated getAnnotated() {
        this.checkState();
        return this.annotated;
    }

    public BeanAttributes<T> getBeanAttributes() {
        this.checkState();
        return this.attributes;
    }

    public void setBeanAttributes(BeanAttributes<T> tBeanAttributes) {
        this.checkState();
        this.attributes = tBeanAttributes;
        this.beanAttributesConfigurator = null;
    }

    public void veto() {
        this.checkState();
        this.veto = true;
    }

    public void addDefinitionError(Throwable throwable) {
        this.checkState();
        this.definitionError = throwable;
    }

    public void ignoreFinalMethods() {
        this.ignoreFinalMethods = true;
    }

    public BeanAttributesConfigurator<T> configureBeanAttributes() {
        this.checkState();
        if (this.beanAttributesConfigurator == null) {
            this.beanAttributesConfigurator = new BeanAttributesConfiguratorImpl<T>(this.webBeansContext, this.attributes);
        }
        return this.beanAttributesConfigurator;
    }

    public BeanAttributes<T> getAttributes() {
        if (this.beanAttributesConfigurator != null) {
            return this.beanAttributesConfigurator.getBeanAttributes();
        }
        return this.attributes;
    }

    public boolean isVeto() {
        return this.veto;
    }

    public boolean isIgnoreFinalMethods() {
        return this.ignoreFinalMethods;
    }

    public Throwable getDefinitionError() {
        return this.definitionError;
    }
}

