/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.portable.events.EventBase;

public class ProcessAnnotatedTypeImpl<X>
extends EventBase
implements ProcessAnnotatedType<X> {
    private final WebBeansContext webBeansContext;
    private AnnotatedType<X> annotatedType;
    private boolean veto;
    private boolean modifiedAnnotatedType;
    private AnnotatedTypeConfiguratorImpl configurator;

    public ProcessAnnotatedTypeImpl(WebBeansContext webBeansContext, AnnotatedType<X> annotatedType) {
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public AnnotatedType<X> getAnnotatedType() {
        this.checkState();
        if (this.configurator == null) {
            return this.annotatedType;
        }
        return this.configurator.getNewAnnotatedType();
    }

    public void setAnnotatedType(AnnotatedType<X> type) {
        this.checkState();
        this.annotatedType = type;
        this.modifiedAnnotatedType = true;
        this.configurator = null;
    }

    public boolean isModifiedAnnotatedType() {
        return this.modifiedAnnotatedType || this.configurator != null;
    }

    public void veto() {
        this.checkState();
        this.veto = true;
    }

    public AnnotatedTypeConfigurator<X> configureAnnotatedType() {
        this.checkState();
        if (this.configurator == null) {
            this.configurator = new AnnotatedTypeConfiguratorImpl<X>(this.webBeansContext, this.annotatedType);
        }
        return this.configurator;
    }

    public boolean isVeto() {
        return this.veto;
    }
}

