/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.ObservesAsync;
import jakarta.enterprise.inject.Disposes;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansCreationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableConstructor;
import org.apache.webbeans.inject.InjectableField;
import org.apache.webbeans.inject.InjectableMethod;
import org.apache.webbeans.intercept.ConstructorInterceptorInvocationContext;
import org.apache.webbeans.intercept.DefaultInterceptorHandler;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.intercept.LifecycleInterceptorInvocationContext;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.portable.AnnotatedConstructorImpl;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.proxy.NormalScopeProxyFactory;
import org.apache.webbeans.proxy.OwbInterceptorProxy;
import org.apache.webbeans.proxy.OwbNormalScopeProxy;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ExceptionUtil;

public class InjectionTargetImpl<T>
extends AbstractProducer<T>
implements InjectionTarget<T> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected volatile AnnotatedConstructor<T> constructor;
    private List<AnnotatedMethod<?>> postConstructMethods;
    private List<Interceptor<?>> postConstructInterceptors;
    private List<AnnotatedMethod<?>> preDestroyMethods;
    private List<Interceptor<?>> preDestroyInterceptors;
    private List<Interceptor<?>> aroundConstructInterceptors;

    public InjectionTargetImpl(AnnotatedType<T> annotatedType, Set<InjectionPoint> injectionPoints, WebBeansContext webBeansContext, List<AnnotatedMethod<?>> postConstructMethods, List<AnnotatedMethod<?>> preDestroyMethods) {
        super(injectionPoints);
        Asserts.assertNotNull(annotatedType);
        Asserts.assertNotNull(webBeansContext);
        this.annotatedType = annotatedType;
        this.webBeansContext = webBeansContext;
        this.postConstructMethods = postConstructMethods;
        this.preDestroyMethods = preDestroyMethods;
    }

    @Override
    protected void defineLifecycleInterceptors(Bean<T> bean, AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
        InterceptorResolutionService.BeanInterceptorInfo interceptorInfo = this.getInterceptorInfo();
        this.postConstructInterceptors = this.getLifecycleInterceptors(interceptorInfo.getEjbInterceptors(), interceptorInfo.getCdiInterceptors(), InterceptionType.POST_CONSTRUCT);
        this.preDestroyInterceptors = this.getLifecycleInterceptors(interceptorInfo.getEjbInterceptors(), interceptorInfo.getCdiInterceptors(), InterceptionType.PRE_DESTROY);
        InterceptorResolutionService.BusinessMethodInterceptorInfo constructorInterceptorInfo = interceptorInfo.getConstructorInterceptorInfos().get(this.getConstructor().getJavaMember());
        Interceptor<?>[] constructorEjbInterceptorArray = constructorInterceptorInfo == null ? null : constructorInterceptorInfo.getEjbInterceptors();
        List<Interceptor<?>> constructorEjbInterceptors = constructorEjbInterceptorArray == null ? Collections.emptyList() : Arrays.asList(constructorEjbInterceptorArray);
        this.aroundConstructInterceptors = this.getLifecycleInterceptors(constructorEjbInterceptors, interceptorInfo.getConstructorCdiInterceptors(), InterceptionType.AROUND_CONSTRUCT);
    }

    @Override
    public T produce(Map<Interceptor<?>, ?> interceptorInstances, CreationalContextImpl<T> creationalContext) {
        if (this.hasAroundConstruct()) {
            try {
                Constructor cons = this.getConstructor().getJavaMember();
                InjectableConstructor<T> injectableConstructor = new InjectableConstructor<T>(cons, this, creationalContext);
                ConstructorInstanceProvider provider = new ConstructorInstanceProvider();
                ConstructorInterceptorInvocationContext invocationContext = new ConstructorInterceptorInvocationContext(provider, this.aroundConstructInterceptors, interceptorInstances, cons, injectableConstructor.createParameters());
                provider.setContext(invocationContext);
                invocationContext.proceed();
                Object newInstance = invocationContext.getNewInstance();
                if (newInstance == null) {
                    invocationContext.directProceed();
                    newInstance = invocationContext.getNewInstance();
                }
                return (T)newInstance;
            }
            catch (Exception e) {
                throw ExceptionUtil.throwAsRuntimeException(e);
            }
        }
        return this.newInstance(creationalContext);
    }

    @Override
    protected boolean needsProxy() {
        return super.needsProxy() || !this.postConstructInterceptors.isEmpty() || !this.preDestroyInterceptors.isEmpty();
    }

    protected boolean hasAroundConstruct() {
        return this.aroundConstructInterceptors != null && !this.aroundConstructInterceptors.isEmpty();
    }

    protected T newInstance(CreationalContextImpl<T> creationalContext) {
        return new InjectableConstructor<T>(this.getConstructor().getJavaMember(), this, creationalContext).doInjection();
    }

    public void inject(T instance, CreationalContext<T> context) {
        this.inject(instance.getClass(), this.unwrapProxyInstance(instance), (CreationalContextImpl)context);
    }

    private void inject(Class<?> type, T instance, CreationalContextImpl<T> context) {
        if (type == null || type.equals(Object.class)) {
            return;
        }
        this.inject(type.getSuperclass(), instance, context);
        this.injectFields(type, instance, context);
        this.injectMethods(type, instance, context);
        this.injectInitializerMethods(type, instance, context);
        this.injectResources(instance);
    }

    private void injectFields(Class<?> type, T instance, CreationalContextImpl<T> context) {
        for (InjectionPoint injectionPoint : this.getInjectionPoints()) {
            if (!injectionPoint.getMember().getDeclaringClass().equals(type) || !(injectionPoint.getMember() instanceof Field)) continue;
            new InjectableField<T>((Field)injectionPoint.getMember(), instance, this, context).doInjection();
        }
    }

    private void injectMethods(Class<?> type, T instance, CreationalContextImpl<T> context) {
        HashSet<Member> injectedMethods = new HashSet<Member>();
        for (InjectionPoint injectionPoint : this.getInjectionPoints()) {
            if (!injectionPoint.getMember().getDeclaringClass().equals(type) || !(injectionPoint.getMember() instanceof Method) || injectedMethods.contains(injectionPoint.getMember()) || this.isProducerMethod(injectionPoint) || this.isDisposalMethod(injectionPoint) || this.isObserverMethod(injectionPoint)) continue;
            new InjectableMethod<T>((Method)injectionPoint.getMember(), instance, this, context).doInjection();
            injectedMethods.add(injectionPoint.getMember());
        }
    }

    private void injectInitializerMethods(Class<?> declaringType, T instance, CreationalContextImpl<T> context) {
        for (AnnotatedMethod<T> method : this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType)) {
            if (!method.getDeclaringType().getJavaClass().equals(declaringType) || !method.isAnnotationPresent(Inject.class) || !method.getParameters().isEmpty()) continue;
            new InjectableMethod<T>(method.getJavaMember(), instance, this, context).doInjection();
        }
    }

    private void injectResources(T instance) {
        try {
            ResourceInjectionService service = null;
            try {
                service = this.webBeansContext.getService(ResourceInjectionService.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (service != null) {
                service.injectJavaEEResources(instance);
            }
        }
        catch (Exception e) {
            throw new WebBeansException(MessageFormat.format(WebBeansLoggerFacade.getTokenString("ERROR_0023"), instance), e);
        }
    }

    public void postConstruct(T instance) {
        Map<Interceptor<?>, ?> interceptorInstances = null;
        T internalInstance = instance;
        if (this.getInterceptorInfo() != null && instance instanceof OwbInterceptorProxy) {
            InterceptorHandler ih = this.getProxyFactory().getInterceptorHandler((OwbInterceptorProxy)instance);
            if (ih instanceof DefaultInterceptorHandler) {
                DefaultInterceptorHandler dih = (DefaultInterceptorHandler)ih;
                interceptorInstances = dih.getInstances();
                internalInstance = dih.getTarget();
            }
        } else if (this.postConstructMethods == null || this.postConstructMethods.isEmpty()) {
            return;
        }
        LifecycleInterceptorInvocationContext<T> ic = new LifecycleInterceptorInvocationContext<T>(internalInstance, InterceptionType.POST_CONSTRUCT, this.postConstructInterceptors, interceptorInstances, this.postConstructMethods);
        try {
            ic.proceed();
        }
        catch (Exception e) {
            throw ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    public void preDestroy(T instance) {
        if (instance instanceof OwbNormalScopeProxy) {
            instance = NormalScopeProxyFactory.unwrapInstance(instance);
        }
        Map<Interceptor<?>, ?> interceptorInstances = null;
        T internalInstance = instance;
        if (this.getInterceptorInfo() != null && instance instanceof OwbInterceptorProxy) {
            InterceptorDecoratorProxyFactory pf = this.webBeansContext.getInterceptorDecoratorProxyFactory();
            InterceptorHandler ih = pf.getInterceptorHandler((OwbInterceptorProxy)instance);
            if (ih instanceof DefaultInterceptorHandler) {
                DefaultInterceptorHandler dih = (DefaultInterceptorHandler)ih;
                interceptorInstances = dih.getInstances();
                internalInstance = dih.getTarget();
            }
        } else if (this.preDestroyMethods == null || this.preDestroyMethods.isEmpty()) {
            return;
        }
        LifecycleInterceptorInvocationContext<T> ic = new LifecycleInterceptorInvocationContext<T>(internalInstance, InterceptionType.PRE_DESTROY, this.preDestroyInterceptors, interceptorInstances, this.preDestroyMethods);
        try {
            ic.proceed();
        }
        catch (Exception e) {
            ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    protected AnnotatedConstructor<T> getConstructor() {
        if (this.constructor == null) {
            this.constructor = this.createConstructor();
        }
        return this.constructor;
    }

    protected AnnotatedConstructor<T> createConstructor() {
        AnnotatedConstructor constructor = null;
        for (InjectionPoint injectionPoint : this.getInjectionPoints()) {
            if (!(injectionPoint.getMember() instanceof Constructor) || constructor != null) continue;
            constructor = (AnnotatedConstructor)((AnnotatedParameter)injectionPoint.getAnnotated()).getDeclaringCallable();
            return constructor;
        }
        Constructor<T> defaultConstructor = this.getDefaultConstructor();
        if (defaultConstructor == null) {
            throw new WebBeansCreationException("No default constructor for " + this.annotatedType.getJavaClass().getName());
        }
        return new AnnotatedConstructorImpl<T>(this.webBeansContext, defaultConstructor, this.annotatedType);
    }

    private Constructor<T> getDefaultConstructor() {
        return this.webBeansContext.getWebBeansUtil().getNoArgConstructor(this.annotatedType.getJavaClass());
    }

    private boolean isProducerMethod(InjectionPoint injectionPoint) {
        return ((AnnotatedElement)((Object)injectionPoint.getMember())).isAnnotationPresent(Produces.class);
    }

    private boolean isObserverMethod(InjectionPoint injectionPoint) {
        if (!(injectionPoint.getMember() instanceof Method)) {
            return false;
        }
        Method method = (Method)injectionPoint.getMember();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Observes.class) && !annotation.annotationType().equals(ObservesAsync.class)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDisposalMethod(InjectionPoint injectionPoint) {
        if (!(injectionPoint.getMember() instanceof Method)) {
            return false;
        }
        Method method = (Method)injectionPoint.getMember();
        Annotation[][] annotationArray = method.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = annotationArray[i]) {
                if (!annotation.annotationType().equals(Disposes.class)) continue;
                return true;
            }
        }
        return false;
    }

    private List<Interceptor<?>> getLifecycleInterceptors(Collection<Interceptor<?>> ejbInterceptors, List<Interceptor<?>> cdiInterceptors, InterceptionType interceptionType) {
        ArrayList lifecycleInterceptors = new ArrayList();
        for (Interceptor<?> ejbInterceptor : ejbInterceptors) {
            if (!ejbInterceptor.intercepts(interceptionType)) continue;
            lifecycleInterceptors.add(ejbInterceptor);
        }
        for (Interceptor<?> cdiInterceptor : cdiInterceptors) {
            if (!cdiInterceptor.intercepts(interceptionType)) continue;
            lifecycleInterceptors.add(cdiInterceptor);
        }
        return lifecycleInterceptors;
    }

    private static class ConstructorInstanceProvider<T>
    implements Provider<T> {
        private ConstructorInterceptorInvocationContext<T> context;

        private ConstructorInstanceProvider() {
        }

        public T get() {
            return (T)this.context.getNewInstance();
        }

        public void setContext(ConstructorInterceptorInvocationContext<T> context) {
            this.context = context;
        }
    }
}

