/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.New;
import jakarta.enterprise.inject.UnproxyableResolutionException;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanCacheKey;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.InjectionExceptionUtil;
import org.apache.webbeans.util.SingleItemSet;
import org.apache.webbeans.util.WebBeansUtil;

public class InjectionResolver {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(InjectionResolver.class);
    private WebBeansContext webBeansContext;
    private AlternativesManager alternativesManager;
    private Map<BeanCacheKey, Set<Bean<?>>> resolvedBeansByType = new ConcurrentHashMap();
    private Map<String, Set<Bean<?>>> resolvedBeansByName = new ConcurrentHashMap();
    private boolean startup;
    private boolean fastMatching;
    private Bean<Instance<Object>> instanceBean;
    private Bean<Event<Object>> eventBean;

    public InjectionResolver(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.alternativesManager = webBeansContext.getAlternativesManager();
        this.startup = true;
        this.fastMatching = false;
        this.instanceBean = webBeansContext.getWebBeansUtil().getInstanceBean();
        this.eventBean = webBeansContext.getWebBeansUtil().getEventBean();
    }

    public void setFastMatching(boolean fastMatching) {
        this.fastMatching = fastMatching;
    }

    public void setStartup(boolean startup) {
        this.startup = startup;
    }

    public void clearCaches() {
        this.resolvedBeansByName.clear();
        this.resolvedBeansByType.clear();
    }

    public void checkInjectionPointType(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define Type Variable generic type");
        }
        if (type == Event.class) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " needs to define type argument for " + Event.class.getName());
        }
        if (type == Instance.class) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " needs to define type argument for " + Instance.class.getName());
        }
        Bean bean = this.resolve(this.implResolveByType(false, type, injectionPoint.getQualifiers().toArray(new Annotation[injectionPoint.getQualifiers().size()])), injectionPoint);
        if (bean != null && ManagedBean.class.isInstance(bean)) {
            try {
                ((ManagedBean)ManagedBean.class.cast(bean)).valid();
            }
            catch (UnproxyableResolutionException ure) {
                throw new WebBeansDeploymentException(ure);
            }
        }
    }

    public void checkInjectionPoint(InjectionPoint injectionPoint) {
        WebBeansUtil.checkInjectionPointNamedQualifier(injectionPoint);
        Type type = injectionPoint.getType();
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " type can not be defined as Typevariable or Wildcard type!");
        }
        if (this.webBeansContext.getBeanManagerImpl().isAfterBeanDiscoveryDone()) {
            Bean bean;
            Set<Bean<?>> beanSet;
            Annotation[] qualifiers = new Annotation[injectionPoint.getQualifiers().size()];
            qualifiers = injectionPoint.getQualifiers().toArray(qualifiers);
            Class injectionPointClass = Object.class;
            Bean injectionPointBean = injectionPoint.getBean();
            if (injectionPointBean != null) {
                injectionPointClass = injectionPointBean.getBeanClass();
            }
            if (injectionPointClass == null && type instanceof Class) {
                injectionPointClass = (Class)type;
            }
            if ((beanSet = this.implResolveByType(injectionPoint.isDelegate(), type, injectionPointClass, qualifiers)).isEmpty() && qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
                this.createNewBean(injectionPoint, type, qualifiers, beanSet);
            }
            if ((bean = this.resolve(beanSet, injectionPoint)) == null) {
                Class clazz;
                if (type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)type;
                    clazz = (Class)pt.getRawType();
                } else {
                    clazz = (Class)type;
                }
                InjectionExceptionUtil.throwUnsatisfiedResolutionException(clazz, injectionPoint, qualifiers);
            }
        }
    }

    public Bean<?> getInjectionPointBean(InjectionPoint injectionPoint) {
        Class clazz;
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        Set qualSet = injectionPoint.getQualifiers();
        Annotation[] qualifiers = qualSet.toArray(new Annotation[qualSet.size()]);
        Set<Bean<?>> beanSet = this.implResolveByType(injectionPoint.isDelegate(), type, clazz, qualifiers);
        if (beanSet.isEmpty()) {
            if (qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
                this.createNewBean(injectionPoint, type, qualifiers, beanSet);
            } else {
                InjectionExceptionUtil.throwUnsatisfiedResolutionException(clazz, injectionPoint, qualifiers);
            }
        }
        return this.resolve(beanSet, injectionPoint);
    }

    private void createNewBean(InjectionPoint injectionPoint, Type type, Annotation[] qualifiers, Set<Bean<?>> beanSet) {
        New newQualifier = (New)qualifiers[0];
        Class newType = newQualifier.value() == New.class ? ClassUtil.getClass(type) : newQualifier.value();
        Set<Bean<?>> beans = this.implResolveByType(injectionPoint.isDelegate(), (Type)newType, injectionPoint.getBean().getBeanClass(), new Annotation[]{AnyLiteral.INSTANCE});
        if (beans.isEmpty()) {
            beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(newType));
        } else {
            for (Bean<?> bean : beans) {
                if (!(bean instanceof InjectionTargetBean)) continue;
                beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent((OwbBean)bean, newType));
                break;
            }
            if (beanSet.isEmpty()) {
                beanSet.add(this.webBeansContext.getWebBeansUtil().createNewComponent(newType));
            }
        }
    }

    private Bean<?> getInstanceOrEventInjectionBean(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Class clazz = (Class)pt.getRawType();
            if (clazz.isAssignableFrom(Instance.class)) {
                return this.instanceBean;
            }
            if (clazz.isAssignableFrom(Event.class)) {
                return this.eventBean;
            }
        }
        return null;
    }

    public Set<Bean<?>> implResolveByName(String name) {
        Asserts.assertNotNull(name, "name parameter");
        String cacheKey = name;
        Set<Bean<?>> resolvedComponents = this.resolvedBeansByName.get(cacheKey);
        if (resolvedComponents != null) {
            return resolvedComponents;
        }
        resolvedComponents = new HashSet();
        Set<Bean<?>> deployedComponents = this.webBeansContext.getBeanManagerImpl().getBeans();
        for (Bean<?> component : deployedComponents) {
            if (component.getName() == null || !component.getName().equals(name)) continue;
            resolvedComponents.add(component);
        }
        if (resolvedComponents.isEmpty()) {
            this.resolvedBeansByName.put(cacheKey, Collections.EMPTY_SET);
        } else {
            this.resolvedBeansByName.put(cacheKey, resolvedComponents);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DEBUG_ADD_BYNAME_CACHE_BEANS", cacheKey);
        }
        return resolvedComponents;
    }

    public Set<Bean<?>> implResolveByType(boolean isDelegate, Type injectionPointType, Annotation ... qualifiers) {
        return this.implResolveByType(isDelegate, injectionPointType, (Class<?>)null, qualifiers);
    }

    private String getBDABeansXMLPath(Class<?> injectionPointBeanClass) {
        if (injectionPointBeanClass == null) {
            return null;
        }
        ScannerService scannerService = this.webBeansContext.getScannerService();
        BDABeansXmlScanner beansXMLScanner = scannerService.getBDABeansXmlScanner();
        return beansXMLScanner.getBeansXml(injectionPointBeanClass);
    }

    public Set<Bean<?>> implResolveByType(boolean isDelegate, Type injectionPointType, Class<?> injectionPointClass, Annotation ... qualifiers) {
        Bean<?> specialBean;
        Set<Object> resolvedComponents;
        ScannerService scannerService = this.webBeansContext.getScannerService();
        String bdaBeansXMLFilePath = null;
        if (scannerService.isBDABeansXmlScanningEnabled()) {
            bdaBeansXMLFilePath = this.getBDABeansXMLPath(injectionPointClass);
        }
        boolean currentQualifier = false;
        if (qualifiers.length == 0) {
            qualifiers = DefaultLiteral.ARRAY;
            currentQualifier = true;
        }
        BeanCacheKey cacheKey = null;
        if (!this.startup) {
            this.validateInjectionPointType(injectionPointType);
            cacheKey = new BeanCacheKey(isDelegate, injectionPointType, bdaBeansXMLFilePath, this::findQualifierModel, qualifiers);
            resolvedComponents = this.resolvedBeansByType.get(cacheKey);
            if (resolvedComponents != null) {
                return resolvedComponents;
            }
        }
        resolvedComponents = new HashSet();
        boolean returnAll = injectionPointType.equals(Object.class) && currentQualifier;
        block0: for (Bean<?> component : this.webBeansContext.getBeanManagerImpl().getBeans()) {
            if (!((OwbBean)component).isEnabled()) continue;
            if (returnAll) {
                resolvedComponents.add(component);
                continue;
            }
            if (this.fastMatching) {
                for (Type componentApiType : component.getTypes()) {
                    if (!ClassUtil.isRawClassEquals(injectionPointType, componentApiType)) continue;
                    resolvedComponents.add(component);
                    continue block0;
                }
                continue;
            }
            for (Type componentApiType : component.getTypes()) {
                if (!GenericsUtil.satisfiesDependency(isDelegate, AbstractProducerBean.class.isInstance(component), injectionPointType, componentApiType, new HashMap<Type, Integer>())) continue;
                resolvedComponents.add(component);
                continue block0;
            }
        }
        if (!returnAll) {
            Set<Bean<?>> byParameterizedType = this.findByParameterizedType(resolvedComponents = this.findByQualifier(resolvedComponents, injectionPointType, qualifiers), injectionPointType, isDelegate);
            resolvedComponents = byParameterizedType.isEmpty() ? this.findByBeanType(resolvedComponents, injectionPointType, isDelegate) : byParameterizedType;
        }
        if (resolvedComponents.isEmpty() && (specialBean = this.getInstanceOrEventInjectionBean(injectionPointType)) != null) {
            resolvedComponents.add(specialBean);
        }
        if (resolvedComponents.isEmpty()) {
            this.findNewBean(resolvedComponents, injectionPointType, qualifiers);
        }
        if (!this.startup && !resolvedComponents.isEmpty()) {
            this.resolvedBeansByType.put(cacheKey, resolvedComponents);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "DEBUG_ADD_BYTYPE_CACHE_BEANS", cacheKey);
            }
        }
        return resolvedComponents;
    }

    private void findNewBean(Set<Bean<?>> resolvedComponents, Type injectionPointType, Annotation[] qualifiers) {
        if (qualifiers.length == 1 && New.class.equals(qualifiers[0].annotationType())) {
            New newQualifier = (New)qualifiers[0];
            Class beanClass = newQualifier.value() != New.class ? newQualifier.value() : GenericsUtil.getRawType(injectionPointType);
            resolvedComponents.add(this.webBeansContext.getWebBeansUtil().createNewComponent(beanClass));
        }
    }

    private Set<Bean<?>> findByBeanType(Set<Bean<?>> allComponents, Type injectionPointType, boolean isDelegate) {
        HashSet resolved = new HashSet();
        for (Bean<?> bean : allComponents) {
            boolean isProducer = AbstractProducerBean.class.isInstance(bean);
            for (Type type : bean.getTypes()) {
                if (GenericsUtil.satisfiesDependency(isDelegate, isProducer, injectionPointType, type, new HashMap<Type, Integer>())) {
                    resolved.add(bean);
                }
                if (ClassUtil.isParametrizedType(injectionPointType) || !ClassUtil.isRawClassEquals(injectionPointType, type)) continue;
                resolved.add(bean);
            }
        }
        return resolved;
    }

    private Set<Bean<?>> findByParameterizedType(Set<Bean<?>> allComponents, Type injectionPointType, boolean isDelegate) {
        Bean<?> rawProducerBean = null;
        HashSet resolvedComponents = new HashSet();
        block0: for (Bean<?> component : allComponents) {
            boolean isProducer = AbstractProducerBean.class.isInstance(component);
            for (Type componentApiType : component.getTypes()) {
                if (GenericsUtil.satisfiesDependency(isDelegate, isProducer, injectionPointType, componentApiType, new HashMap<Type, Integer>())) {
                    resolvedComponents.add(component);
                    continue block0;
                }
                if (!isProducer || !(componentApiType instanceof Class) || !ClassUtil.isRawClassEquals(injectionPointType, componentApiType)) continue;
                rawProducerBean = component;
            }
        }
        if (resolvedComponents.isEmpty() && rawProducerBean != null) {
            resolvedComponents.add(rawProducerBean);
        }
        return resolvedComponents;
    }

    private void validateInjectionPointType(Type injectionPointType) {
        if (injectionPointType instanceof TypeVariable || injectionPointType instanceof WildcardType || injectionPointType instanceof GenericArrayType) {
            throw new WebBeansConfigurationException("Injection point cannot define Type Variable " + injectionPointType);
        }
        if (!(injectionPointType instanceof Class) && !(injectionPointType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Unsupported type " + injectionPointType.getClass());
        }
    }

    public <X> Set<Bean<? extends X>> findByAlternatives(Set<Bean<? extends X>> beans) {
        List<Class<?>> prioritizedAlternatives = this.alternativesManager.getPrioritizedAlternatives();
        for (Class<?> alternativeClazz : prioritizedAlternatives) {
            for (Bean<X> bean : beans) {
                if (!alternativeClazz.equals(bean.getBeanClass())) continue;
                return new SingleItemSet<Bean<? extends X>>(bean);
            }
        }
        HashSet<Bean<X>> alternativeSet = new HashSet<Bean<X>>();
        HashSet<Bean<X>> enableSet = new HashSet<Bean<X>>();
        for (Bean<X> bean : beans) {
            AbstractOwbBean temp;
            if (bean.isAlternative() || bean instanceof AbstractProducerBean && ((AbstractProducerBean)bean).getOwnerComponent().isAlternative()) {
                alternativeSet.add(bean);
                continue;
            }
            if (!alternativeSet.isEmpty() || !(temp = (AbstractOwbBean)bean).isEnabled()) continue;
            enableSet.add(bean);
        }
        if (!alternativeSet.isEmpty()) {
            return alternativeSet;
        }
        return enableSet;
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans, InjectionPoint injectionPoint) {
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        if (beans.size() == 1) {
            return beans.iterator().next();
        }
        Set<Bean<?>> set = this.resolveAll(beans);
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() > 1) {
            InjectionExceptionUtil.throwAmbiguousResolutionException(set, null, injectionPoint, new Annotation[0]);
        }
        return set.iterator().next();
    }

    public <X> Set<Bean<? extends X>> resolveAll(Set<Bean<? extends X>> beans) {
        if (beans == null || beans.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Bean<X>> set = this.findByAlternatives(beans);
        if (set == null || set.isEmpty()) {
            return Collections.emptySet();
        }
        return set;
    }

    private Set<Bean<?>> findByQualifier(Set<Bean<?>> remainingSet, Type type, Annotation ... annotations) {
        Iterator<Bean<?>> it = remainingSet.iterator();
        HashSet result = new HashSet();
        while (it.hasNext()) {
            Bean<?> component = it.next();
            Set qTypes = component.getQualifiers();
            int i = 0;
            for (Annotation annot : annotations) {
                for (Annotation qualifier : qTypes) {
                    if (!annot.annotationType().equals(qualifier.annotationType())) continue;
                    AnnotatedType<? extends Annotation> at = this.findQualifierModel(qualifier.annotationType());
                    if (at == null) {
                        if (!AnnotationUtil.isCdiAnnotationEqual(qualifier, annot)) continue;
                        ++i;
                        continue;
                    }
                    if (!AnnotationUtil.isCdiAnnotationEqual(at, qualifier, annot)) continue;
                    ++i;
                }
            }
            if (i != annotations.length) continue;
            result.add(component);
        }
        return result;
    }

    private AnnotatedType<? extends Annotation> findQualifierModel(Class<?> qualifier) {
        return this.webBeansContext.getBeanManagerImpl().getAdditionalAnnotatedTypeQualifiers().get(qualifier);
    }
}

