/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.config.OwbGenericArrayTypeImpl;
import org.apache.webbeans.config.OwbParametrizedTypeImpl;
import org.apache.webbeans.config.OwbTypeVariableImpl;
import org.apache.webbeans.config.OwbWildcardTypeImpl;
import org.apache.webbeans.util.ClassUtil;

public final class GenericsUtil {
    public static boolean satisfiesDependency(boolean isDelegateOrEvent, boolean isProducer, Type injectionPointType, Type beanType) {
        Type beanRawType;
        if (beanType instanceof TypeVariable || beanType instanceof WildcardType || beanType instanceof GenericArrayType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, beanType);
        }
        Type injectionPointRawType = injectionPointType instanceof ParameterizedType ? ((ParameterizedType)injectionPointType).getRawType() : injectionPointType;
        Type type = beanRawType = beanType instanceof ParameterizedType ? ((ParameterizedType)beanType).getRawType() : beanType;
        if (ClassUtil.isSame(injectionPointRawType, beanRawType)) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, beanType);
        }
        return false;
    }

    public static boolean satisfiesDependencyRaw(boolean isDelegateOrEvent, boolean isProducer, Type injectionPointType, Type beanType) {
        Type beanRawType;
        if (beanType instanceof TypeVariable || beanType instanceof WildcardType || beanType instanceof GenericArrayType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, beanType);
        }
        Type injectionPointRawType = injectionPointType instanceof ParameterizedType ? ((ParameterizedType)injectionPointType).getRawType() : injectionPointType;
        Type type = beanRawType = beanType instanceof ParameterizedType ? ((ParameterizedType)beanType).getRawType() : beanType;
        if (ClassUtil.isSame(injectionPointRawType, beanRawType)) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointRawType, beanRawType);
        }
        Class bean = (Class)beanType;
        if (bean.getSuperclass() != null && ClassUtil.isRawClassEquals(injectionPointType, bean.getSuperclass())) {
            return true;
        }
        Class<?>[] interfaces = bean.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return false;
        }
        for (Class<?> clazz : interfaces) {
            if (!ClassUtil.isRawClassEquals(injectionPointType, clazz)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(boolean isDelegateOrEvent, boolean isProducer, Type requiredType, Type beanType) {
        if (requiredType instanceof Class) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, (Class)requiredType, beanType);
        }
        if (requiredType instanceof ParameterizedType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, (ParameterizedType)requiredType, beanType);
        }
        if (requiredType instanceof TypeVariable) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, (TypeVariable)requiredType, beanType);
        }
        if (requiredType instanceof GenericArrayType) {
            return Class.class.isInstance(beanType) && ((Class)Class.class.cast(beanType)).isArray() && GenericsUtil.isAssignableFrom(isDelegateOrEvent, (GenericArrayType)requiredType, beanType);
        }
        if (requiredType instanceof WildcardType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, (WildcardType)requiredType, beanType);
        }
        throw new IllegalArgumentException("Unsupported type " + requiredType.getClass());
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, Class<?> injectionPointType, Type beanType) {
        if (beanType instanceof Class) {
            return GenericsUtil.isAssignableFrom(injectionPointType, (Class)beanType);
        }
        if (beanType instanceof TypeVariable) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType, (TypeVariable)beanType);
        }
        if (beanType instanceof ParameterizedType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType, (ParameterizedType)beanType);
        }
        if (beanType instanceof GenericArrayType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType, (GenericArrayType)beanType);
        }
        if (beanType instanceof WildcardType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType, (WildcardType)beanType);
        }
        throw new IllegalArgumentException("Unsupported type " + injectionPointType.getClass());
    }

    private static boolean isAssignableFrom(Class<?> injectionPointType, Class<?> beanType) {
        return ClassUtil.isClassAssignableFrom(injectionPointType, beanType);
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, Class<?> injectionPointType, TypeVariable<?> beanType) {
        for (Type bounds : beanType.getBounds()) {
            if (!GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType, bounds)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, Class<?> injectionPointType, ParameterizedType beanType) {
        if (beanType.getRawType() != injectionPointType) {
            return false;
        }
        for (Type typeArgument : beanType.getActualTypeArguments()) {
            if (typeArgument == Object.class) continue;
            if (!(typeArgument instanceof TypeVariable)) {
                return false;
            }
            TypeVariable typeVariable = (TypeVariable)typeArgument;
            for (Type bounds : typeVariable.getBounds()) {
                if (bounds == Object.class) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, Class<?> injectionPointType, GenericArrayType beanType) {
        return injectionPointType.isArray() && GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType.getComponentType(), beanType.getGenericComponentType());
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, Type injectionPointType, WildcardType beanType) {
        for (Type bounds : beanType.getLowerBounds()) {
            if (GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, bounds, injectionPointType)) continue;
            return false;
        }
        for (Type bounds : beanType.getUpperBounds()) {
            if (!GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, injectionPointType, bounds)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, boolean isProducer, ParameterizedType injectionPointType, Type beanType) {
        if (beanType instanceof Class) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, (Class)beanType);
        }
        if (beanType instanceof TypeVariable) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, (TypeVariable)beanType);
        }
        if (beanType instanceof ParameterizedType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType, (ParameterizedType)beanType);
        }
        if (beanType instanceof WildcardType) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, (Type)injectionPointType, (WildcardType)beanType);
        }
        if (beanType instanceof GenericArrayType) {
            return false;
        }
        throw new IllegalArgumentException("Unsupported type " + beanType.getClass());
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, boolean isProducer, ParameterizedType injectionPointType, Class<?> beanType) {
        Class rawInjectionPointType = GenericsUtil.getRawType(injectionPointType);
        if (rawInjectionPointType.equals(beanType)) {
            if (isProducer) {
                for (Type t : injectionPointType.getActualTypeArguments()) {
                    if (TypeVariable.class.isInstance(t) && GenericsUtil.isNotBound(((TypeVariable)TypeVariable.class.cast(t)).getBounds()) || Class.class.isInstance(t) && Object.class == t) continue;
                    return false;
                }
            }
            return true;
        }
        if (!rawInjectionPointType.isAssignableFrom(beanType)) {
            return false;
        }
        if (beanType.getSuperclass() != null && GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, beanType.getGenericSuperclass())) {
            return true;
        }
        for (Type genericInterface : beanType.getGenericInterfaces()) {
            if (!GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, genericInterface)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, boolean isProducer, ParameterizedType injectionPointType, TypeVariable<?> beanType) {
        Type[] types = beanType.getBounds();
        if (GenericsUtil.isNotBound(types)) {
            return true;
        }
        for (Type bounds : types) {
            if (!GenericsUtil.isAssignableFrom(isDelegateOrEvent, isProducer, injectionPointType, bounds)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, ParameterizedType injectionPointType, ParameterizedType beanType) {
        if (injectionPointType.getRawType() != beanType.getRawType()) {
            return false;
        }
        boolean swapParams = !isDelegateOrEvent;
        Type[] injectionPointTypeArguments = injectionPointType.getActualTypeArguments();
        Type[] beanTypeArguments = beanType.getActualTypeArguments();
        for (int i = 0; i < injectionPointTypeArguments.length; ++i) {
            Type injectionPointTypeArgument = injectionPointTypeArguments[i];
            Type beanTypeArgument = beanTypeArguments[i];
            if (swapParams && (injectionPointTypeArgument instanceof Class || injectionPointTypeArgument instanceof TypeVariable) && beanTypeArgument instanceof TypeVariable) {
                Type[] bounds = ((TypeVariable)beanTypeArgument).getBounds();
                boolean isNotBound = GenericsUtil.isNotBound(bounds);
                if (isNotBound) continue;
                for (Type upperBound : bounds) {
                    if (GenericsUtil.isAssignableFrom(true, false, upperBound, injectionPointTypeArgument)) continue;
                    return false;
                }
                continue;
            }
            if (swapParams && injectionPointTypeArgument instanceof TypeVariable) {
                return false;
            }
            if (isDelegateOrEvent && injectionPointTypeArgument instanceof Class && beanTypeArgument instanceof Class) {
                return injectionPointTypeArgument.equals(beanTypeArgument);
            }
            if (GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, injectionPointTypeArgument, beanTypeArgument)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNotBound(Type ... bounds) {
        return bounds == null || bounds.length == 0 || bounds.length == 1 && Object.class == bounds[0];
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, TypeVariable<?> injectionPointType, Type beanType) {
        for (Type bounds : injectionPointType.getBounds()) {
            if (GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, bounds, beanType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, GenericArrayType injectionPointType, Type beanType) {
        Type genericComponentType = injectionPointType.getGenericComponentType();
        Class<?> componentType = ((Class)Class.class.cast(beanType)).getComponentType();
        if (Class.class.isInstance(genericComponentType)) {
            return ((Class)Class.class.cast(genericComponentType)).isAssignableFrom(componentType);
        }
        if (ParameterizedType.class.isInstance(genericComponentType)) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, ((ParameterizedType)ParameterizedType.class.cast(genericComponentType)).getRawType(), componentType);
        }
        return GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, genericComponentType, componentType);
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, WildcardType injectionPointType, Type beanType) {
        if (beanType instanceof TypeVariable) {
            return GenericsUtil.isAssignableFrom(isDelegateOrEvent, injectionPointType, (TypeVariable)beanType);
        }
        for (Type bounds : injectionPointType.getLowerBounds()) {
            if (GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, beanType, bounds)) continue;
            return false;
        }
        for (Type bounds : injectionPointType.getUpperBounds()) {
            Set<Type> beanTypeClosure = GenericsUtil.getTypeClosure(beanType);
            boolean isAssignable = false;
            for (Type beanSupertype : beanTypeClosure) {
                if (!GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, bounds, beanSupertype) && (!Class.class.isInstance(bounds) || !ParameterizedType.class.isInstance(beanSupertype) || bounds != ((ParameterizedType)ParameterizedType.class.cast(beanSupertype)).getRawType())) continue;
                isAssignable = true;
                break;
            }
            if (isAssignable) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignableFrom(boolean isDelegateOrEvent, WildcardType injectionPointType, TypeVariable<?> beanType) {
        for (Type upperBound : injectionPointType.getUpperBounds()) {
            for (Type bound : beanType.getBounds()) {
                if (GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, upperBound, bound) || GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, bound, upperBound)) continue;
                return false;
            }
        }
        for (Type lowerBound : injectionPointType.getLowerBounds()) {
            for (Type bound : beanType.getBounds()) {
                if (GenericsUtil.isAssignableFrom(isDelegateOrEvent, false, bound, lowerBound)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean containsTypeVariable(Type type) {
        if (type instanceof Class) {
            return false;
        }
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return GenericsUtil.containTypeVariable(parameterizedType.getActualTypeArguments());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return GenericsUtil.containTypeVariable(wildcardType.getUpperBounds()) || GenericsUtil.containTypeVariable(wildcardType.getLowerBounds());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return GenericsUtil.containsTypeVariable(arrayType.getGenericComponentType());
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    public static boolean containTypeVariable(Collection<? extends Type> types) {
        return GenericsUtil.containTypeVariable(types.toArray(new Type[types.size()]));
    }

    public static boolean containTypeVariable(Type[] types) {
        for (Type type : types) {
            if (!GenericsUtil.containsTypeVariable(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWildcardType(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        for (Type typeArgument : GenericsUtil.getParameterizedType(type).getActualTypeArguments()) {
            if (!(ClassUtil.isParametrizedType(typeArgument) ? GenericsUtil.containsWildcardType(typeArgument) : ClassUtil.isWildCardType(typeArgument))) continue;
            return true;
        }
        return false;
    }

    public static Type resolveType(Class<?> subclass, Field field) {
        return GenericsUtil.resolveType(field.getGenericType(), subclass, GenericsUtil.newSeenList());
    }

    public static Type resolveReturnType(Class<?> subclass, Method method) {
        return GenericsUtil.resolveType(method.getGenericReturnType(), subclass, GenericsUtil.newSeenList());
    }

    public static Type[] resolveParameterTypes(Class<?> subclass, Constructor<?> constructor) {
        return GenericsUtil.resolveTypes(constructor.getGenericParameterTypes(), subclass);
    }

    public static Type[] resolveParameterTypes(Class<?> subclass, Method method) {
        return GenericsUtil.resolveTypes(method.getGenericParameterTypes(), subclass);
    }

    public static Type resolveType(Type type, Class<?> subclass, Member member) {
        return GenericsUtil.resolveType(type, subclass, GenericsUtil.newSeenList());
    }

    public static Type resolveType(Type type, Class<?> subclass, Member member, Collection<TypeVariable<?>> seen) {
        return GenericsUtil.resolveType(type, subclass, seen);
    }

    public static Type resolveType(Type type, Type actualType, Collection<TypeVariable<?>> seen) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] resolvedTypeArguments = Enum.class.equals((Object)parameterizedType.getRawType()) ? new Type[]{new OwbWildcardTypeImpl(new Type[]{Enum.class}, ClassUtil.NO_TYPES)} : GenericsUtil.resolveTypes(parameterizedType.getActualTypeArguments(), actualType, seen);
            return new OwbParametrizedTypeImpl(parameterizedType.getOwnerType(), parameterizedType.getRawType(), resolvedTypeArguments);
        }
        if (type instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)type;
            return GenericsUtil.resolveTypeVariable(variable, actualType, seen);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type[] upperBounds = GenericsUtil.resolveTypes(wildcardType.getUpperBounds(), actualType, seen);
            Type[] lowerBounds = GenericsUtil.resolveTypes(wildcardType.getLowerBounds(), actualType, seen);
            return new OwbWildcardTypeImpl(upperBounds, lowerBounds);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return GenericsUtil.createArrayType(GenericsUtil.resolveType(arrayType.getGenericComponentType(), actualType, seen));
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    public static Type[] resolveTypes(Type[] types, Type actualType, Collection<TypeVariable<?>> seen) {
        Type[] resolvedTypeArguments = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            Type type = GenericsUtil.resolveType(types[i], actualType, seen);
            if (type == null) continue;
            resolvedTypeArguments[i] = type;
        }
        return resolvedTypeArguments;
    }

    public static Type[] resolveTypes(Type[] types, Type actualType) {
        Type[] resolvedTypeArguments = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            resolvedTypeArguments[i] = GenericsUtil.resolveType(types[i], actualType, GenericsUtil.newSeenList());
        }
        return resolvedTypeArguments;
    }

    public static Set<Type> getTypeClosure(Class<?> type) {
        return GenericsUtil.getTypeClosure(type, type);
    }

    public static Set<Type> getTypeClosure(Type actualType) {
        return GenericsUtil.getTypeClosure(actualType, actualType);
    }

    public static Set<Type> getTypeClosure(Type type, Type actualType) {
        Class actualRawType;
        Class rawType = GenericsUtil.getRawType(type);
        if (rawType.isAssignableFrom(actualRawType = GenericsUtil.getRawType(actualType)) && rawType != actualRawType) {
            return GenericsUtil.getTypeClosure(actualType, type);
        }
        if (GenericsUtil.hasTypeParameters(type)) {
            type = GenericsUtil.getParameterizedType(type);
        }
        return GenericsUtil.getDirectTypeClosure(type, actualType);
    }

    public static Set<Type> getDirectTypeClosure(Type type, Type actualType) {
        HashSet<Type> typeClosure = new HashSet<Type>();
        typeClosure.add((Type)((Object)Object.class));
        GenericsUtil.fillTypeHierarchy(typeClosure, type, actualType);
        return typeClosure;
    }

    private static void fillTypeHierarchy(Set<Type> set, Type type, Type actualType) {
        if (type == null) {
            return;
        }
        Type resolvedType = GenericsUtil.resolveType(type, actualType, GenericsUtil.newSeenList());
        set.add(resolvedType);
        Class resolvedClass = GenericsUtil.getRawType(resolvedType, actualType);
        if (resolvedClass.getSuperclass() != null) {
            GenericsUtil.fillTypeHierarchy(set, resolvedClass.getGenericSuperclass(), resolvedType);
        }
        for (Type interfaceType : resolvedClass.getGenericInterfaces()) {
            GenericsUtil.fillTypeHierarchy(set, interfaceType, resolvedType);
        }
    }

    private static Collection<TypeVariable<?>> newSeenList() {
        return new ArrayList();
    }

    public static boolean hasTypeParameters(Type type) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            return classType.getTypeParameters().length > 0;
        }
        return false;
    }

    public static ParameterizedType getParameterizedType(Type type) {
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            return new OwbParametrizedTypeImpl(classType.getDeclaringClass(), classType, classType.getTypeParameters());
        }
        throw new IllegalArgumentException(type.getClass().getSimpleName() + " is not supported");
    }

    public static <T> Class<T> getRawType(Type type) {
        return GenericsUtil.getRawType(type, null);
    }

    static <T> Class<T> getRawType(Type type, Type actualType) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return GenericsUtil.getRawType(parameterizedType.getRawType(), actualType);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type mostSpecificType = GenericsUtil.getMostSpecificType(GenericsUtil.getRawTypes(typeVariable.getBounds(), actualType), typeVariable.getBounds());
            return GenericsUtil.getRawType(mostSpecificType, actualType);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type mostSpecificType = GenericsUtil.getMostSpecificType(GenericsUtil.getRawTypes(wildcardType.getUpperBounds(), actualType), wildcardType.getUpperBounds());
            return GenericsUtil.getRawType(mostSpecificType, actualType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return GenericsUtil.getRawType(GenericsUtil.createArrayType(GenericsUtil.getRawType(arrayType.getGenericComponentType(), actualType)), actualType);
        }
        throw new IllegalArgumentException("Unsupported type " + type.getClass().getName());
    }

    private static <T> Class<T>[] getRawTypes(Type[] types) {
        return GenericsUtil.getRawTypes(types, null);
    }

    private static <T> Class<T>[] getRawTypes(Type[] types, Type actualType) {
        Class[] rawTypes = new Class[types.length];
        for (int i = 0; i < types.length; ++i) {
            rawTypes[i] = GenericsUtil.getRawType(types[i], actualType);
        }
        return rawTypes;
    }

    private static Type getMostSpecificType(Class<?>[] types, Type[] genericTypes) {
        Class<?> mostSpecificType = types[0];
        int mostSpecificIndex = 0;
        for (int i = 0; i < types.length; ++i) {
            if (!mostSpecificType.isAssignableFrom(types[i])) continue;
            mostSpecificType = types[i];
            mostSpecificIndex = i;
        }
        return genericTypes[mostSpecificIndex];
    }

    private static Class<?>[] getClassTypes(Class<?>[] rawTypes) {
        ArrayList classTypes = new ArrayList();
        for (Class<?> rawType : rawTypes) {
            if (rawType.isInterface()) continue;
            classTypes.add(rawType);
        }
        return classTypes.toArray(new Class[classTypes.size()]);
    }

    private static Type resolveTypeVariable(TypeVariable<?> variable, Type actualType, Collection<TypeVariable<?>> seen) {
        if (actualType == null) {
            return variable;
        }
        Class<?> declaringClass = GenericsUtil.getDeclaringClass(variable.getGenericDeclaration());
        Class actualClass = GenericsUtil.getRawType(actualType);
        if (actualClass == declaringClass) {
            return GenericsUtil.resolveTypeVariable(variable, variable.getGenericDeclaration(), GenericsUtil.getParameterizedType(actualType), seen);
        }
        if (actualClass.isAssignableFrom(declaringClass)) {
            Class<?> directSubclass = GenericsUtil.getDirectSubclass(declaringClass, actualClass);
            Type[] typeArguments = GenericsUtil.resolveTypeArguments(directSubclass, actualType);
            OwbParametrizedTypeImpl directSubtype = new OwbParametrizedTypeImpl(directSubclass.getDeclaringClass(), directSubclass, typeArguments);
            return GenericsUtil.resolveTypeVariable(variable, directSubtype, seen);
        }
        Type genericSuperclass = GenericsUtil.getGenericSuperclass(actualClass, declaringClass);
        if (genericSuperclass == null) {
            return variable;
        }
        if (genericSuperclass instanceof Class) {
            Class superclass = (Class)genericSuperclass;
            genericSuperclass = new OwbParametrizedTypeImpl(superclass.getDeclaringClass(), superclass, GenericsUtil.getRawTypes(superclass.getTypeParameters()));
        } else {
            ParameterizedType genericSupertype = GenericsUtil.getParameterizedType(genericSuperclass);
            Type[] typeArguments = GenericsUtil.resolveTypeArguments(GenericsUtil.getParameterizedType(actualType), genericSupertype);
            genericSuperclass = new OwbParametrizedTypeImpl(genericSupertype.getOwnerType(), genericSupertype.getRawType(), typeArguments);
        }
        Type resolvedType = GenericsUtil.resolveTypeVariable(variable, genericSuperclass, seen);
        if (resolvedType instanceof TypeVariable) {
            TypeVariable resolvedTypeVariable = (TypeVariable)resolvedType;
            TypeVariable<Class<T>>[] typeParameters = actualClass.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (!typeParameters[i].getName().equals(resolvedTypeVariable.getName())) continue;
                resolvedType = GenericsUtil.getParameterizedType(actualType).getActualTypeArguments()[i];
                break;
            }
        }
        return resolvedType;
    }

    private static Class<?> getDeclaringClass(GenericDeclaration declaration) {
        if (declaration instanceof Class) {
            return (Class)declaration;
        }
        if (declaration instanceof Member) {
            return ((Member)((Object)declaration)).getDeclaringClass();
        }
        throw new IllegalArgumentException("Unsupported type " + declaration.getClass());
    }

    private static Type resolveTypeVariable(TypeVariable<?> variable, GenericDeclaration declaration, ParameterizedType type, Collection<TypeVariable<?>> seen) {
        int index = GenericsUtil.getIndex(declaration, variable);
        if (declaration instanceof Class) {
            if (index >= 0) {
                return type.getActualTypeArguments()[index];
            }
            index = GenericsUtil.getIndex(type, variable);
            if (index >= 0) {
                return declaration.getTypeParameters()[index];
            }
        } else {
            if (seen.contains(variable)) {
                return null;
            }
            seen.add(variable);
            Type[] resolvedBounds = GenericsUtil.resolveTypes(declaration.getTypeParameters()[index].getBounds(), type, seen);
            return OwbTypeVariableImpl.createTypeVariable(variable, resolvedBounds);
        }
        return variable;
    }

    private static int getIndex(GenericDeclaration declaration, TypeVariable<?> variable) {
        TypeVariable<?>[] typeParameters = declaration.getTypeParameters();
        for (int i = 0; i < typeParameters.length; ++i) {
            TypeVariable<?> variableArgument;
            if (!(typeParameters[i] instanceof TypeVariable) || !(variableArgument = typeParameters[i]).getName().equals(variable.getName())) continue;
            return i;
        }
        return -1;
    }

    private static int getIndex(ParameterizedType type, TypeVariable<?> variable) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            TypeVariable variableArgument;
            if (!(actualTypeArguments[i] instanceof TypeVariable) || !(variableArgument = (TypeVariable)actualTypeArguments[i]).getName().equals(variable.getName())) continue;
            return i;
        }
        return -1;
    }

    private static Class<?> getDirectSubclass(Class<?> declaringClass, Class<?> actualClass) {
        if (actualClass.isInterface()) {
            Class<?> subclass = declaringClass;
            for (Class<?> iface : declaringClass.getInterfaces()) {
                if (iface == actualClass) {
                    return subclass;
                }
                subclass = actualClass.isAssignableFrom(iface) ? iface : declaringClass.getSuperclass();
            }
            return GenericsUtil.getDirectSubclass(subclass, actualClass);
        }
        Class<?> directSubclass = declaringClass;
        while (directSubclass.getSuperclass() != actualClass) {
            directSubclass = directSubclass.getSuperclass();
        }
        return directSubclass;
    }

    private static Type getGenericSuperclass(Class<?> subclass, Class<?> superclass) {
        if (!superclass.isInterface()) {
            return subclass.getGenericSuperclass();
        }
        for (Type genericInterface : subclass.getGenericInterfaces()) {
            if (GenericsUtil.getRawType(genericInterface) != superclass) continue;
            return genericInterface;
        }
        return superclass;
    }

    private static Type[] resolveTypeArguments(Class<?> subclass, Type supertype) {
        if (supertype instanceof ParameterizedType) {
            ParameterizedType parameterizedSupertype = (ParameterizedType)supertype;
            return GenericsUtil.resolveTypeArguments(subclass, parameterizedSupertype);
        }
        return subclass.getTypeParameters();
    }

    private static Type[] resolveTypeArguments(Class<?> subclass, ParameterizedType parameterizedSupertype) {
        Type genericSuperclass = GenericsUtil.getGenericSuperclass(subclass, GenericsUtil.getRawType(parameterizedSupertype));
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return subclass.getTypeParameters();
        }
        ParameterizedType parameterizedSuperclass = (ParameterizedType)genericSuperclass;
        Type[] typeParameters = subclass.getTypeParameters();
        Type[] actualTypeArguments = parameterizedSupertype.getActualTypeArguments();
        return GenericsUtil.resolveTypeArguments(parameterizedSuperclass, typeParameters, actualTypeArguments);
    }

    private static Type[] resolveTypeArguments(ParameterizedType subtype, ParameterizedType parameterizedSupertype) {
        return GenericsUtil.resolveTypeArguments(GenericsUtil.getParameterizedType(GenericsUtil.getRawType(subtype)), parameterizedSupertype.getActualTypeArguments(), subtype.getActualTypeArguments());
    }

    private static Type[] resolveTypeArguments(ParameterizedType parameterizedType, Type[] typeParameters, Type[] actualTypeArguments) {
        Type[] resolvedTypeArguments = new Type[typeParameters.length];
        for (int i = 0; i < typeParameters.length; ++i) {
            resolvedTypeArguments[i] = GenericsUtil.resolveTypeArgument(parameterizedType, typeParameters[i], actualTypeArguments);
        }
        return resolvedTypeArguments;
    }

    private static Type resolveTypeArgument(ParameterizedType parameterizedType, Type typeParameter, Type[] actualTypeArguments) {
        if (typeParameter instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)typeParameter;
            int index = GenericsUtil.getIndex(parameterizedType, variable);
            if (index == -1) {
                return typeParameter;
            }
            return actualTypeArguments[index];
        }
        if (typeParameter instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)typeParameter;
            return GenericsUtil.createArrayType(GenericsUtil.resolveTypeArgument(parameterizedType, array.getGenericComponentType(), actualTypeArguments));
        }
        return typeParameter;
    }

    private static Type createArrayType(Type componentType) {
        if (componentType instanceof Class) {
            return Array.newInstance((Class)componentType, 0).getClass();
        }
        return new OwbGenericArrayTypeImpl(componentType);
    }

    public static Type resolveType(ParameterizedType parameterizedType, Type metadataType) {
        return GenericsUtil.resolveType((Type)parameterizedType, metadataType, GenericsUtil.newSeenList());
    }
}

