/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.webbeans.config.PropertyLoader;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class OpenWebBeansConfiguration {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(OpenWebBeansConfiguration.class);
    public static final String CONVERSATION_PERIODIC_DELAY = "org.apache.webbeans.conversation.Conversation.periodicDelay";
    public static final String CONVERSATION_TIMEOUT_INTERVAL = "org.apache.webbeans.conversation.Conversation.timeoutInterval";
    public static final String INTERCEPTOR_FORCE_NO_CHECKED_EXCEPTIONS = "org.apache.webbeans.forceNoCheckedExceptions";
    public static final String USE_EJB_DISCOVERY = "org.apache.webbeans.spi.deployer.useEjbMetaDataDiscoveryService";
    public static final String CONTAINER_LIFECYCLE = "org.apache.webbeans.spi.ContainerLifecycle";
    public static final String JNDI_SERVICE = "org.apache.webbeans.spi.JNDIService";
    public static final String SCANNER_SERVICE = "org.apache.webbeans.spi.ScannerService";
    public static final String CONTEXTS_SERVICE = "org.apache.webbeans.spi.ContextsService";
    public static final String CONVERSATION_SERVICE = "org.apache.webbeans.spi.ConversationService";
    public static final String RESOURCE_INJECTION_SERVICE = "org.apache.webbeans.spi.ResourceInjectionService";
    public static final String SECURITY_SERVICE = "org.apache.webbeans.spi.SecurityService";
    public static final String VALIDATOR_SERVICE = "org.apache.webbeans.spi.ValidatorService";
    public static final String TRANSACTION_SERVICE = "org.apache.webbeans.spi.TransactionService";
    public static final String APPLICATION_IS_JSP = "org.apache.webbeans.application.jsp";
    public static final String APPLICATION_SUPPORTS_CONVERSATION = "org.apache.webbeans.application.supportsConversation";
    public static final String PRODUCER_INTERCEPTION_SUPPORT = "org.apache.webbeans.application.supportsProducerInterception";
    public static final String EL_ADAPTOR_CLASS = "org.apache.webbeans.spi.adaptor.ELAdaptor";
    public static final String PROXY_MAPPING_PREFIX = "org.apache.webbeans.proxy.mapping.";
    public static final String USE_BDA_BEANSXML_SCANNER = "org.apache.webbeans.useBDABeansXMLScanner";
    public static final String IGNORED_INTERFACES = "org.apache.webbeans.ignoredDecoratorInterfaces";
    public static final String EAGER_SESSION_INITIALISATION = "org.apache.webbeans.web.eagerSessionInitialisation";
    public static final String GENERATOR_JAVA_VERSIN = "org.apache.webbeans.generator.javaVersion";
    private static final String DEFAULT_CONFIG_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans.properties";
    private static final String AUTO_CONFIG = "auto";
    private final Properties configProperties = new Properties();
    private Set<String> ignoredInterfaces;

    public OpenWebBeansConfiguration(Properties properties) {
        this();
        this.configProperties.putAll((Map<?, ?>)properties);
    }

    public OpenWebBeansConfiguration() {
        this.parseConfiguration();
    }

    public synchronized void parseConfiguration() throws WebBeansConfigurationException {
        Properties newConfigProperties = PropertyLoader.getProperties(DEFAULT_CONFIG_PROPERTIES_NAME);
        this.configProperties.clear();
        if (newConfigProperties != null) {
            this.overrideWithGlobalSettings(newConfigProperties);
            this.configProperties.putAll((Map<?, ?>)newConfigProperties);
        }
    }

    private void overrideWithGlobalSettings(Properties configProperties) {
        logger.fine("Overriding properties from System and Env properties");
        Properties systemProperties = System.getSecurityManager() != null ? this.doPrivilegedGetSystemProperties() : System.getProperties();
        Map<String, String> systemEnvironment = System.getenv();
        for (Map.Entry<Object, Object> property : configProperties.entrySet()) {
            String key = (String)property.getKey();
            String value = (String)property.getValue();
            value = systemProperties.getProperty(key) != null ? systemProperties.getProperty(key) : value;
            value = systemEnvironment.get(key) != null ? systemEnvironment.get(key) : value;
            configProperties.put(key, value);
        }
    }

    private Properties doPrivilegedGetSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    public String getProperty(String key) {
        return this.configProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.configProperties.getProperty(key, defaultValue);
    }

    public synchronized void setProperty(String key, Object value) {
        this.configProperties.put(key, value);
    }

    public boolean isJspApplication() {
        String value = this.getProperty(APPLICATION_IS_JSP);
        return Boolean.valueOf(value);
    }

    public boolean supportsConversation() {
        String value = this.getProperty(APPLICATION_SUPPORTS_CONVERSATION);
        return Boolean.valueOf(value);
    }

    public synchronized Set<String> getIgnoredInterfaces() {
        if (this.ignoredInterfaces == null) {
            String ignoredInterfacesString = this.getProperty(IGNORED_INTERFACES);
            this.ignoredInterfaces = ignoredInterfacesString != null ? new HashSet<String>(Arrays.asList(ignoredInterfacesString.split("[,\\p{javaWhitespace}]"))) : Collections.emptySet();
        }
        return this.ignoredInterfaces;
    }

    public boolean supportsInterceptionOnProducers() {
        return "true".equals(this.getProperty(PRODUCER_INTERCEPTION_SUPPORT, "true"));
    }

    public String getGeneratorJavaVersion() {
        String generatorJavaVersion = this.getProperty(GENERATOR_JAVA_VERSIN);
        if (generatorJavaVersion == null || AUTO_CONFIG.equals(generatorJavaVersion)) {
            return System.getProperty("java.version");
        }
        return generatorJavaVersion;
    }
}

