/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.persistence.query.Expression;
import org.apache.openjpa.persistence.query.ExpressionImpl;

class AliasContext {
    private Stack<Object> _operating = new Stack();
    private Map<ExpressionImpl, String> _aliases = new HashMap<ExpressionImpl, String>();
    private final MetaDataRepository _repos;

    public AliasContext(MetaDataRepository repos) {
        this._repos = repos;
    }

    public String getAlias(ExpressionImpl path) {
        String alias = this._aliases.get(path);
        if (alias != null) {
            return alias;
        }
        return this.setAlias(path);
    }

    public String setAlias(ExpressionImpl path) {
        if (this._aliases.containsKey(path)) {
            return this._aliases.get(path);
        }
        String alias = path.getAliasHint(this).substring(0, 1).toLowerCase();
        int i = 2;
        while (this._aliases.containsValue(alias)) {
            alias = alias.substring(0, 1) + i;
            ++i;
        }
        this._aliases.put(path, alias);
        return alias;
    }

    public boolean hasAlias(Expression path) {
        return this._aliases.containsKey(path);
    }

    public AliasContext push(Object e) {
        if (this._operating.contains(e)) {
            throw new RuntimeException(e + " is already in this ctx");
        }
        this._operating.add(e);
        return this;
    }

    public String getEntityName(Class cls) {
        return cls.getSimpleName();
    }
}

