/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.datacache;

import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Clearable;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.UserException;

public class ClearableScheduler
implements Runnable {
    private static final Localizer _loc = Localizer.forPackage(ClearableScheduler.class);
    private Map<Clearable, Schedule> _clearables = new ConcurrentHashMap<Clearable, Schedule>();
    private boolean _stop = false;
    private int _interval = 1;
    private Log _log;
    private Thread _thread;

    public ClearableScheduler(OpenJPAConfiguration conf) {
        this._log = conf.getLogFactory().getLog("openjpa.DataCache");
    }

    public int getInterval() {
        return this._interval;
    }

    public void setInterval(int interval) {
        this._interval = interval;
    }

    public synchronized void stop() {
        this._stop = true;
    }

    private boolean isStopped() {
        return this._stop;
    }

    public synchronized void scheduleEviction(Clearable clearable, String times) {
        if (times == null) {
            return;
        }
        Schedule schedule = new Schedule(times);
        this._clearables.put(clearable, schedule);
        this._stop = false;
        if (this._thread == null) {
            this._thread = (Thread)AccessController.doPrivileged(J2DoPrivHelper.newDaemonThreadAction((Runnable)this, (String)_loc.get("scheduler-name").getMessage()));
            this._thread.start();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("scheduler-start", (Object)this._thread.getName()));
            }
        }
    }

    public synchronized void removeFromSchedule(Clearable clearable) {
        this._clearables.remove(clearable);
        if (this._clearables.size() == 0) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("scheduler-interval", (Object)("" + this._interval)));
        }
        Date lastRun = new Date();
        SimpleDateFormat fom = new SimpleDateFormat("E HH:mm:ss");
        while (!this.isStopped()) {
            try {
                Thread.sleep(this._interval * 60 * 1000);
                Date now = new Date();
                for (Map.Entry<Clearable, Schedule> entry : this._clearables.entrySet()) {
                    Clearable clearable = entry.getKey();
                    Schedule schedule = entry.getValue();
                    if (!schedule.matches(lastRun, now)) continue;
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)_loc.get("scheduler-clear", (Object)clearable, (Object)fom.format(now)));
                    }
                    this.evict(clearable);
                }
                lastRun = now;
            }
            catch (Exception e) {
                throw new InvalidStateException(_loc.get("scheduler-fail"), (Object)e).setFatal(true);
            }
        }
        this._log.info((Object)_loc.get("scheduler-stop"));
        ClearableScheduler clearableScheduler = this;
        synchronized (clearableScheduler) {
            if (this.isStopped()) {
                this._thread = null;
            }
        }
    }

    protected void evict(Clearable cache) {
        cache.clear();
    }

    private static class Schedule {
        static final int[] WILDCARD = new int[0];
        static final int[] UNITS = new int[]{2, 5, 7, 11, 12};
        final int[] month;
        final int[] dayOfMonth;
        final int[] dayOfWeek;
        final int[] hour;
        final int[] min;

        public Schedule(String date) {
            int[] tmin = null;
            if (date.startsWith("+")) {
                Calendar cal = Calendar.getInstance();
                int interval = Integer.parseInt(date.substring(1));
                int currMin = cal.get(12);
                tmin = new int[60 / interval];
                for (int i = 0; i < tmin.length; ++i) {
                    int temp = i == 0 ? currMin + interval : tmin[i - 1] + interval;
                    if (temp >= 60) {
                        temp -= 60;
                    }
                    tmin[i] = temp;
                }
                Arrays.sort(tmin);
                this.min = tmin;
                this.hour = WILDCARD;
                this.dayOfMonth = WILDCARD;
                this.month = WILDCARD;
                this.dayOfWeek = WILDCARD;
            } else {
                StringTokenizer token = new StringTokenizer(date, " \t");
                if (token.countTokens() != 5) {
                    throw new UserException(_loc.get("bad-count", (Object)date)).setFatal(true);
                }
                try {
                    this.min = this.parse(token.nextToken(), 0, 60);
                    this.hour = this.parse(token.nextToken(), 0, 24);
                    this.dayOfMonth = this.parse(token.nextToken(), 1, 31);
                    this.month = this.parse(token.nextToken(), 1, 13);
                    this.dayOfWeek = this.parse(token.nextToken(), 1, 8);
                }
                catch (Throwable t) {
                    throw new UserException(_loc.get("bad-schedule", (Object)date), t).setFatal(true);
                }
            }
        }

        private int[] parse(String token, int min, int max) {
            if ("*".equals(token.trim())) {
                return WILDCARD;
            }
            String[] tokens = StringUtil.split((String)token, (String)",", (int)0);
            int[] times = new int[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                try {
                    times[i] = Integer.parseInt(tokens[i]);
                }
                catch (Throwable t) {
                    throw new UserException(_loc.get("not-number", (Object)token)).setFatal(true);
                }
                if (times[i] >= min && times[i] < max) continue;
                throw new UserException(_loc.get("not-range", (Object)token, (Object)String.valueOf(min), (Object)String.valueOf(max))).setFatal(true);
            }
            return times;
        }

        boolean matches(Date last, Date now) {
            Calendar time = Calendar.getInstance();
            time.setTime(now);
            time.set(13, 0);
            time.set(14, 0);
            int[][] all = new int[][]{this.month, this.dayOfMonth, this.dayOfWeek, this.hour, this.min};
            return this.matches(last, now, time, all, 0);
        }

        private boolean matches(Date last, Date now, Calendar time, int[][] times, int depth) {
            if (depth == UNITS.length) {
                Date compare = time.getTime();
                return compare.compareTo(last) >= 0 && compare.compareTo(now) < 0;
            }
            if (times[depth] != WILDCARD) {
                for (int i = 0; i < times[depth].length; ++i) {
                    time.set(UNITS[depth], times[depth][i]);
                    if (!this.matches(last, now, time, times, depth + 1)) continue;
                    return true;
                }
            }
            return this.matches(last, now, time, times, depth + 1);
        }
    }
}

