/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation.jmx;

import javax.management.ObjectName;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.instrumentation.AbstractPreparedQueryCacheInstrument;
import org.apache.openjpa.instrumentation.jmx.JMXInstrument;
import org.apache.openjpa.instrumentation.jmx.JMXProvider;
import org.apache.openjpa.instrumentation.jmx.PreparedQueryCacheJMXInstrumentMBean;
import org.apache.openjpa.kernel.PreparedQueryCache;
import org.apache.openjpa.lib.instrumentation.Instrument;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class PreparedQueryCacheJMXInstrument
extends AbstractPreparedQueryCacheInstrument
implements JMXInstrument,
PreparedQueryCacheJMXInstrumentMBean {
    private static Localizer _loc = Localizer.forPackage(PreparedQueryCacheJMXInstrument.class);
    private static final String MBEAN_TYPE = "QuerySQLCache";
    private ObjectName _objName = null;

    public String getName() {
        return MBEAN_TYPE;
    }

    @Override
    public InstrumentationLevel getLevel() {
        return InstrumentationLevel.FACTORY;
    }

    public void initialize() {
        OpenJPAConfiguration conf = (OpenJPAConfiguration)this.getProvider().getConfiguration();
        PreparedQueryCache pqc = conf.getQuerySQLCacheInstance();
        if (pqc == null) {
            throw new UserException(_loc.get("prep-query-cache-not-found"));
        }
        this.setPreparedQueryCache(pqc);
        this.setConfigId(conf.getId());
        this.setContextRef(Integer.toString(System.identityHashCode(this.getContext())));
    }

    @Override
    public ObjectName getObjectName() {
        if (this._objName != null) {
            return this._objName;
        }
        try {
            this._objName = JMXProvider.createObjectName(this, null);
            return this._objName;
        }
        catch (Throwable t) {
            throw new UserException(_loc.get("unable-to-create-object-name", (Object)this.getName()), t);
        }
    }

    public void start() {
        this.getProvider().startInstrument((Instrument)this);
    }

    public void stop() {
        this.getProvider().stopInstrument((Instrument)this);
    }
}

