/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Date;
import org.apache.openjpa.enhance.FieldManager;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.kernel.ObjectIdStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.BigDecimalId;
import org.apache.openjpa.util.BigIntegerId;
import org.apache.openjpa.util.ByteId;
import org.apache.openjpa.util.CharId;
import org.apache.openjpa.util.DateId;
import org.apache.openjpa.util.DoubleId;
import org.apache.openjpa.util.FloatId;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.IntId;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.LongId;
import org.apache.openjpa.util.ObjectId;
import org.apache.openjpa.util.OpenJPAId;
import org.apache.openjpa.util.ShortId;
import org.apache.openjpa.util.StringId;
import org.apache.openjpa.util.UserException;
import serp.util.Numbers;

public class ApplicationIds {
    private static final Localizer _loc = Localizer.forPackage((Class)ApplicationIds.class);
    private static final Localizer _loc2 = Localizer.forPackage((Class)StateManagerImpl.class);

    public static Object[] toPKValues(Object oid, ClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        if (meta.isOpenJPAIdentity()) {
            Object[] pks = new Object[1];
            if (oid != null) {
                pks[0] = ((OpenJPAId)oid).getIdObject();
            }
            return pks;
        }
        FieldMetaData[] fmds = meta.getPrimaryKeyFields();
        meta = fmds[fmds.length - 1].getDeclaringMetaData();
        Object[] pks = new Object[fmds.length];
        if (oid == null) {
            return pks;
        }
        if (!Modifier.isAbstract(meta.getDescribedType().getModifiers())) {
            PrimaryKeyFieldManager consumer = new PrimaryKeyFieldManager();
            consumer.setStore(pks);
            PCRegistry.copyKeyFieldsFromObjectId(meta.getDescribedType(), consumer, oid);
            return consumer.getStore();
        }
        if (meta.isObjectIdTypeShared()) {
            oid = ((ObjectId)oid).getId();
        }
        Class<?> oidType = oid.getClass();
        for (int i = 0; i < fmds.length; ++i) {
            pks[i] = meta.getAccessType() == 2 ? Reflection.get(oid, Reflection.findField(oidType, fmds[i].getName(), true)) : Reflection.get(oid, Reflection.findGetter(oidType, fmds[i].getName(), true));
        }
        return pks;
    }

    public static Object fromPKValues(Object[] pks, ClassMetaData meta) {
        boolean convert;
        if (meta == null || pks == null) {
            return null;
        }
        boolean bl = convert = !meta.getRepository().getConfiguration().getCompatibilityInstance().getStrictIdentityValues();
        if (meta.isOpenJPAIdentity()) {
            int type = meta.getPrimaryKeyFields()[0].getObjectIdFieldTypeCode();
            Object val = convert ? JavaTypes.convert(pks[0], type) : pks[0];
            switch (type) {
                case 1: 
                case 17: {
                    if (!convert && !(val instanceof Byte)) {
                        throw new ClassCastException("!(x instanceof Byte)");
                    }
                    return new ByteId(meta.getDescribedType(), val == null ? (byte)0 : ((Number)val).byteValue());
                }
                case 2: 
                case 18: {
                    return new CharId(meta.getDescribedType(), val == null ? (char)'\u0000' : ((Character)val).charValue());
                }
                case 3: 
                case 19: {
                    if (!convert && !(val instanceof Double)) {
                        throw new ClassCastException("!(x instanceof Double)");
                    }
                    return new DoubleId(meta.getDescribedType(), val == null ? 0.0 : ((Number)val).doubleValue());
                }
                case 4: 
                case 20: {
                    if (!convert && !(val instanceof Float)) {
                        throw new ClassCastException("!(x instanceof Float)");
                    }
                    return new FloatId(meta.getDescribedType(), val == null ? 0.0f : ((Number)val).floatValue());
                }
                case 5: 
                case 21: {
                    if (!convert && !(val instanceof Integer)) {
                        throw new ClassCastException("!(x instanceof Integer)");
                    }
                    return new IntId(meta.getDescribedType(), val == null ? 0 : ((Number)val).intValue());
                }
                case 6: 
                case 22: {
                    if (!convert && !(val instanceof Long)) {
                        throw new ClassCastException("!(x instanceof Long)");
                    }
                    return new LongId(meta.getDescribedType(), val == null ? 0L : ((Number)val).longValue());
                }
                case 7: 
                case 23: {
                    if (!convert && !(val instanceof Short)) {
                        throw new ClassCastException("!(x instanceof Short)");
                    }
                    return new ShortId(meta.getDescribedType(), val == null ? (short)0 : ((Number)val).shortValue());
                }
                case 9: {
                    return new StringId(meta.getDescribedType(), (String)val);
                }
                case 14: {
                    return new DateId(meta.getDescribedType(), (Date)val);
                }
                case 8: 
                case 29: {
                    return new ObjectId(meta.getDescribedType(), val);
                }
                case 24: {
                    if (!convert && !(val instanceof BigDecimal)) {
                        throw new ClassCastException("!(x instanceof BigDecimal)");
                    }
                    return new BigDecimalId(meta.getDescribedType(), (BigDecimal)val);
                }
                case 25: {
                    if (!convert && !(val instanceof BigInteger)) {
                        throw new ClassCastException("!(x instanceof BigInteger)");
                    }
                    return new BigIntegerId(meta.getDescribedType(), (BigInteger)val);
                }
            }
            throw new InternalException();
        }
        if (!Modifier.isAbstract(meta.getDescribedType().getModifiers())) {
            Object oid = PCRegistry.newObjectId(meta.getDescribedType());
            PrimaryKeyFieldManager producer = new PrimaryKeyFieldManager();
            producer.setStore(pks);
            if (convert) {
                producer.setMetaData(meta);
            }
            PCRegistry.copyKeyFieldsToObjectId(meta.getDescribedType(), producer, oid);
            return oid;
        }
        Class oidType = meta.getObjectIdType();
        if (Modifier.isAbstract(oidType.getModifiers())) {
            throw new UserException(_loc.get("objectid-abstract", (Object)meta));
        }
        ObjectId copy = null;
        try {
            copy = (ObjectId)AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction((Class)oidType));
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            throw new GeneralException(t2);
        }
        FieldMetaData[] fmds = meta.getPrimaryKeyFields();
        for (int i = 0; i < fmds.length; ++i) {
            Object val;
            Object object = val = convert ? JavaTypes.convert(pks[i], fmds[i].getObjectIdFieldTypeCode()) : pks[i];
            if (meta.getAccessType() == 2) {
                Reflection.set((Object)copy, Reflection.findField(oidType, fmds[i].getName(), true), val);
                continue;
            }
            Reflection.set((Object)copy, Reflection.findSetter(oidType, fmds[i].getName(), fmds[i].getDeclaredType(), true), val);
        }
        if (meta.isObjectIdTypeShared()) {
            copy = new ObjectId(meta.getDescribedType(), copy);
        }
        return copy;
    }

    public static Object copy(Object oid, ClassMetaData meta) {
        if (meta == null || oid == null) {
            return null;
        }
        if (meta.isOpenJPAIdentity()) {
            Class cls = meta.getDescribedType();
            OpenJPAId koid = (OpenJPAId)oid;
            FieldMetaData pk = meta.getPrimaryKeyFields()[0];
            switch (pk.getObjectIdFieldTypeCode()) {
                case 1: 
                case 17: {
                    return new ByteId(cls, ((ByteId)oid).getId(), koid.hasSubclasses());
                }
                case 2: 
                case 18: {
                    return new CharId(cls, ((CharId)oid).getId(), koid.hasSubclasses());
                }
                case 3: 
                case 19: {
                    return new DoubleId(cls, ((DoubleId)oid).getId(), koid.hasSubclasses());
                }
                case 4: 
                case 20: {
                    return new FloatId(cls, ((FloatId)oid).getId(), koid.hasSubclasses());
                }
                case 5: 
                case 21: {
                    return new IntId(cls, ((IntId)oid).getId(), koid.hasSubclasses());
                }
                case 6: 
                case 22: {
                    return new LongId(cls, ((LongId)oid).getId(), koid.hasSubclasses());
                }
                case 7: 
                case 23: {
                    return new ShortId(cls, ((ShortId)oid).getId(), koid.hasSubclasses());
                }
                case 9: {
                    return new StringId(cls, oid.toString(), koid.hasSubclasses());
                }
                case 29: {
                    ClassMetaData embed = pk.getEmbeddedMetaData();
                    Object inner = koid.getIdObject();
                    if (embed != null) {
                        inner = ApplicationIds.copy(inner, embed, embed.getFields());
                    }
                    return new ObjectId(cls, inner, koid.hasSubclasses());
                }
                case 8: {
                    return new ObjectId(cls, koid.getIdObject(), koid.hasSubclasses());
                }
                case 14: {
                    return new DateId(cls, ((DateId)oid).getId(), koid.hasSubclasses());
                }
                case 24: {
                    return new BigDecimalId(cls, ((BigDecimalId)oid).getId(), koid.hasSubclasses());
                }
                case 25: {
                    return new BigIntegerId(cls, ((BigIntegerId)oid).getId(), koid.hasSubclasses());
                }
            }
            throw new InternalException();
        }
        if (!Modifier.isAbstract(meta.getDescribedType().getModifiers()) && !ApplicationIds.hasPCPrimaryKeyFields(meta)) {
            Class type = meta.getInterfaceImpl();
            if (type == null) {
                type = meta.getDescribedType();
            }
            PersistenceCapable pc = PCRegistry.newInstance(type, null, oid, false);
            Object copy = pc.pcNewObjectIdInstance();
            pc.pcCopyKeyFieldsToObjectId(copy);
            return copy;
        }
        Object copy = !meta.isObjectIdTypeShared() ? oid : ((ObjectId)oid).getId();
        copy = ApplicationIds.copy(copy, meta, meta.getPrimaryKeyFields());
        if (meta.isObjectIdTypeShared()) {
            copy = new ObjectId(meta.getDescribedType(), copy, ((OpenJPAId)oid).hasSubclasses());
        }
        return copy;
    }

    private static boolean hasPCPrimaryKeyFields(ClassMetaData meta) {
        FieldMetaData[] fmds = meta.getPrimaryKeyFields();
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getDeclaredTypeCode() != 15) continue;
            return true;
        }
        return false;
    }

    private static Object copy(Object oid, ClassMetaData meta, FieldMetaData[] fmds) {
        if (oid == null) {
            return null;
        }
        Class<?> oidType = oid.getClass();
        Object copy = null;
        try {
            copy = AccessController.doPrivileged(J2DoPrivHelper.newInstanceAction(oidType));
        }
        catch (Throwable t2) {
            Exception t2;
            if (t2 instanceof PrivilegedActionException) {
                t2 = ((PrivilegedActionException)t2).getException();
            }
            throw new GeneralException(t2);
        }
        for (int i = 0; i < fmds.length; ++i) {
            if (fmds[i].getManagement() != 3) continue;
            if (meta.getAccessType() == 2) {
                Field field = Reflection.findField(oidType, fmds[i].getName(), true);
                Reflection.set(copy, field, Reflection.get(oid, field));
                continue;
            }
            Object val = Reflection.get(oid, Reflection.findGetter(oidType, fmds[i].getName(), true));
            Reflection.set(copy, Reflection.findSetter(oidType, fmds[i].getName(), fmds[i].getObjectIdFieldType(), true), val);
        }
        return copy;
    }

    public static Object get(Object oid, FieldMetaData fmd) {
        if (oid == null) {
            return null;
        }
        if (oid instanceof OpenJPAId) {
            return ((OpenJPAId)oid).getIdObject();
        }
        ClassMetaData meta = fmd.getDefiningMetaData();
        Class<?> oidType = oid.getClass();
        if (meta.getAccessType() == 2) {
            return Reflection.get(oid, Reflection.findField(oidType, fmd.getName(), true));
        }
        return Reflection.get(oid, Reflection.findGetter(oidType, fmd.getName(), true));
    }

    public static Object create(PersistenceCapable pc, ClassMetaData meta) {
        if (pc == null) {
            return null;
        }
        Object oid = pc.pcNewObjectIdInstance();
        if (oid == null) {
            return null;
        }
        if (!meta.isOpenJPAIdentity()) {
            pc.pcCopyKeyFieldsToObjectId(oid);
            return oid;
        }
        FieldMetaData pk = meta.getPrimaryKeyFields()[0];
        if (pk.getDeclaredTypeCode() != 29) {
            return oid;
        }
        ObjectId objid = (ObjectId)oid;
        ClassMetaData embed = pk.getEmbeddedMetaData();
        objid.setId(ApplicationIds.copy(objid.getId(), embed, embed.getFields()));
        return objid;
    }

    public static boolean assign(OpenJPAStateManager sm, StoreManager store, boolean preFlush) {
        boolean ret;
        ClassMetaData meta = sm.getMetaData();
        if (meta.getIdentityType() != 2) {
            throw new InternalException();
        }
        FieldMetaData[] pks = meta.getPrimaryKeyFields();
        if (meta.isOpenJPAIdentity() && pks[0].getDeclaredTypeCode() == 29) {
            ObjectIdStateManager oidsm = new ObjectIdStateManager(sm.fetchObjectField(pks[0].getIndex()), sm, pks[0]);
            ret = ApplicationIds.assign(oidsm, store, pks[0].getEmbeddedMetaData().getFields(), preFlush);
            sm.storeObjectField(pks[0].getIndex(), oidsm.getManagedInstance());
        } else {
            ret = ApplicationIds.assign(sm, store, meta.getPrimaryKeyFields(), preFlush);
        }
        if (!ret) {
            return false;
        }
        sm.setObjectId(ApplicationIds.create(sm.getPersistenceCapable(), meta));
        return true;
    }

    private static boolean assign(OpenJPAStateManager sm, StoreManager store, FieldMetaData[] pks, boolean preFlush) {
        for (int i = 0; i < pks.length; ++i) {
            if (pks[i].getValueStrategy() == 0) continue;
            if (!sm.isDefaultValue(pks[i].getIndex())) {
                throw new InvalidStateException(_loc2.get("existing-value-override-excep", (Object)pks[i].getFullName(false)));
            }
            if (store.assignField(sm, pks[i].getIndex(), preFlush)) {
                pks[i].setValueGenerated(true);
                continue;
            }
            return false;
        }
        return true;
    }

    private static class PrimaryKeyFieldManager
    implements FieldManager {
        private Object[] _store = null;
        private int _index = 0;
        private ClassMetaData _meta = null;

        private PrimaryKeyFieldManager() {
        }

        public void setMetaData(ClassMetaData meta) {
            this._meta = meta;
        }

        public Object[] getStore() {
            return this._store;
        }

        public void setStore(Object[] store) {
            this._store = store;
        }

        public void storeBooleanField(int field, boolean val) {
            this.store(val ? Boolean.TRUE : Boolean.FALSE);
        }

        public void storeByteField(int field, byte val) {
            this.store(new Byte(val));
        }

        public void storeCharField(int field, char val) {
            this.store(new Character(val));
        }

        public void storeShortField(int field, short val) {
            this.store(new Short(val));
        }

        public void storeIntField(int field, int val) {
            this.store(Numbers.valueOf((int)val));
        }

        public void storeLongField(int field, long val) {
            this.store(Numbers.valueOf((long)val));
        }

        public void storeFloatField(int field, float val) {
            this.store(new Float(val));
        }

        public void storeDoubleField(int field, double val) {
            this.store(new Double(val));
        }

        public void storeStringField(int field, String val) {
            this.store(val);
        }

        public void storeObjectField(int field, Object val) {
            this.store(val);
        }

        public boolean fetchBooleanField(int field) {
            return this.retrieve(field) == Boolean.TRUE;
        }

        public char fetchCharField(int field) {
            return ((Character)this.retrieve(field)).charValue();
        }

        public byte fetchByteField(int field) {
            return ((Number)this.retrieve(field)).byteValue();
        }

        public short fetchShortField(int field) {
            return ((Number)this.retrieve(field)).shortValue();
        }

        public int fetchIntField(int field) {
            return ((Number)this.retrieve(field)).intValue();
        }

        public long fetchLongField(int field) {
            return ((Number)this.retrieve(field)).longValue();
        }

        public float fetchFloatField(int field) {
            return ((Number)this.retrieve(field)).floatValue();
        }

        public double fetchDoubleField(int field) {
            return ((Number)this.retrieve(field)).doubleValue();
        }

        public String fetchStringField(int field) {
            return (String)this.retrieve(field);
        }

        public Object fetchObjectField(int field) {
            return this.retrieve(field);
        }

        private void store(Object val) {
            this._store[this._index++] = val;
        }

        private Object retrieve(int field) {
            Object val = this._store[this._index++];
            if (this._meta != null) {
                FieldMetaData fmd = this._meta.getField(field);
                val = fmd.getDeclaredTypeCode() != 15 ? JavaTypes.convert(val, fmd.getDeclaredTypeCode()) : JavaTypes.convert(val, JavaTypes.getTypeCode(fmd.getObjectIdFieldType()));
            }
            return val;
        }
    }
}

