/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProviderIterator;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.lib.util.concurrent.ReentrantLock;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;

public class ExtentImpl
implements Extent {
    private static final ClassMetaData[] EMPTY_METAS = new ClassMetaData[0];
    private final Broker _broker;
    private final Class _type;
    private final boolean _subs;
    private final FetchConfiguration _fc;
    private final ReentrantLock _lock;
    private boolean _ignore = false;
    private ReferenceHashSet _openItrs = null;

    ExtentImpl(Broker broker, Class type, boolean subs, FetchConfiguration fetch) {
        this._broker = broker;
        this._type = type;
        this._subs = subs;
        this._fc = fetch != null ? fetch : (FetchConfiguration)broker.getFetchConfiguration().clone();
        this._ignore = broker.getIgnoreChanges();
        this._lock = broker.getMultithreaded() ? new ReentrantLock() : null;
    }

    public FetchConfiguration getFetchConfiguration() {
        return this._fc;
    }

    public boolean getIgnoreChanges() {
        return this._ignore;
    }

    public void setIgnoreChanges(boolean ignoreChanges) {
        this._broker.assertOpen();
        this._ignore = ignoreChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List list() {
        ArrayList arrayList;
        ArrayList list = new ArrayList();
        Iterator itr = this.iterator();
        try {
            while (itr.hasNext()) {
                list.add(itr.next());
            }
            arrayList = list;
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ImplHelper.close(itr);
            throw throwable;
        }
        ImplHelper.close(itr);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        this._broker.assertNontransactionalRead();
        CloseableIterator citr = null;
        try {
            MetaDataRepository repos;
            ClassMetaData meta;
            boolean trans;
            CloseableIteratorChain chain = new CloseableIteratorChain();
            boolean bl = trans = !this._ignore && this._broker.isActive();
            if (trans) {
                chain.addIterator((Iterator)((Object)new FilterNewIterator()));
            }
            ClassMetaData[] metas = (meta = (repos = this._broker.getConfiguration().getMetaDataRepositoryInstance()).getMetaData(this._type, this._broker.getClassLoader(), false)) != null && (!this._subs || !meta.isManagedInterface()) && (meta.isMapped() || this._subs && meta.getMappedPCSubclassMetaDatas().length > 0) ? new ClassMetaData[]{meta} : (this._subs && (meta == null || meta.isManagedInterface()) ? repos.getImplementorMetaDatas(this._type, this._broker.getClassLoader(), false) : EMPTY_METAS);
            for (int i = 0; i < metas.length; ++i) {
                ResultObjectProvider rop = this._broker.getStoreManager().executeExtent(metas[i], this._subs, this._fc);
                if (rop == null) continue;
                chain.addIterator((Iterator)new ResultObjectProviderIterator(rop));
            }
            citr = trans ? new FilterDeletedIterator(chain) : chain;
            citr.setRemoveOnClose(this);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        this.lock();
        try {
            if (this._openItrs == null) {
                this._openItrs = new ReferenceHashSet(2);
            }
            this._openItrs.add((Object)citr);
            Object var10_11 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.unlock();
            throw throwable;
        }
        return citr;
    }

    public Broker getBroker() {
        return this._broker;
    }

    public Class getElementType() {
        return this._type;
    }

    public boolean hasSubclasses() {
        return this._subs;
    }

    public void closeAll() {
        if (this._openItrs == null) {
            return;
        }
        this.lock();
        try {
            try {
                Iterator itr = this._openItrs.iterator();
                while (itr.hasNext()) {
                    CloseableIterator citr = (CloseableIterator)itr.next();
                    citr.setRemoveOnClose(null);
                    try {
                        citr.close();
                    }
                    catch (Exception exception) {}
                }
                this._openItrs.clear();
            }
            catch (OpenJPAException ke) {
                throw ke;
            }
            catch (RuntimeException re) {
                throw new GeneralException(re);
            }
            Object var5_6 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    public void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    private class FilterNewIterator
    extends FilterIterator
    implements Closeable,
    Predicate {
        public FilterNewIterator() {
            super(ExtentImpl.this._broker.getTransactionalObjects().iterator());
            this.setPredicate(this);
        }

        public void close() {
        }

        public boolean evaluate(Object o) {
            if (!ExtentImpl.this._broker.isNew(o)) {
                return false;
            }
            Class<?> type = o.getClass();
            if (!ExtentImpl.this._subs && type != ExtentImpl.this._type) {
                return false;
            }
            return !ExtentImpl.this._subs || ExtentImpl.this._type.isAssignableFrom(type);
        }
    }

    private static class FilterDeletedIterator
    extends FilterIterator
    implements CloseableIterator,
    Predicate {
        private ExtentImpl _extent = null;
        private boolean _closed = false;

        public FilterDeletedIterator(Iterator itr) {
            super(itr);
            this.setPredicate(this);
        }

        public boolean hasNext() {
            return this._closed ? false : super.hasNext();
        }

        public Object next() {
            if (this._closed) {
                throw new NoSuchElementException();
            }
            return super.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void setRemoveOnClose(ExtentImpl extent) {
            this._extent = extent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws Exception {
            if (this._extent != null && this._extent._openItrs != null) {
                this._extent.lock();
                try {
                    this._extent._openItrs.remove((Object)this);
                    Object var2_1 = null;
                    this._extent.unlock();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this._extent.unlock();
                    throw throwable;
                }
            }
            this._closed = true;
            ((Closeable)this.getIterator()).close();
        }

        public boolean evaluate(Object o) {
            return !this._extent._broker.isDeleted(o);
        }
    }

    private static class CloseableIteratorChain
    extends IteratorChain
    implements CloseableIterator {
        private ExtentImpl _extent = null;
        private boolean _closed = false;

        private CloseableIteratorChain() {
        }

        public boolean hasNext() {
            return this._closed ? false : super.hasNext();
        }

        public Object next() {
            if (this._closed) {
                throw new NoSuchElementException();
            }
            return super.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void setRemoveOnClose(ExtentImpl extent) {
            this._extent = extent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws Exception {
            if (this._extent != null && this._extent._openItrs != null) {
                this._extent.lock();
                try {
                    this._extent._openItrs.remove((Object)this);
                    Object var2_1 = null;
                    this._extent.unlock();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this._extent.unlock();
                    throw throwable;
                }
            }
            this._closed = true;
            Iterator itr = this.getIterators().iterator();
            while (itr.hasNext()) {
                ((Closeable)itr.next()).close();
            }
        }
    }

    private static interface CloseableIterator
    extends Closeable,
    Iterator {
        public void setRemoveOnClose(ExtentImpl var1);
    }
}

