/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.ClassArgParser;
import org.apache.openjpa.lib.util.CodeFormat;
import org.apache.openjpa.lib.util.Files;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.DelegatingMetaDataFactory;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.UserException;
import serp.bytecode.BCClass;
import serp.bytecode.BCClassLoader;
import serp.bytecode.Project;
import serp.util.Strings;

public class ApplicationIdTool {
    public static final String TOKEN_DEFAULT = "::";
    private static final String TOKENIZER_CUSTOM = "Tokenizer";
    private static final String TOKENIZER_STD = "StringTokenizer";
    private static Localizer _loc = Localizer.forPackage((Class)ApplicationIdTool.class);
    private final Log _log;
    private final Class _type;
    private final ClassMetaData _meta;
    private boolean _abstract = false;
    private FieldMetaData[] _fields = null;
    private boolean _ignore = true;
    private File _dir = null;
    private Writer _writer = null;
    private String _code = null;
    private String _token = "::";
    private CodeFormat _format = null;
    static /* synthetic */ Class class$java$lang$Object;

    public ApplicationIdTool(OpenJPAConfiguration conf, Class type) {
        this._log = conf.getLog("openjpa.Enhance");
        this._type = type;
        MetaDataRepository repos = conf.newMetaDataRepositoryInstance();
        repos.setValidate(0);
        repos.setSourceMode(2, false);
        ApplicationIdTool.loadObjectIds(repos, true);
        this._meta = repos.getMetaData(type, null, false);
        if (this._meta != null) {
            this._abstract = Modifier.isAbstract(this._meta.getDescribedType().getModifiers());
            this._fields = ApplicationIdTool.getDeclaredPrimaryKeyFields(this._meta);
        }
    }

    public ApplicationIdTool(OpenJPAConfiguration conf, Class type, ClassMetaData meta) {
        this._log = conf.getLog("openjpa.Enhance");
        this._type = type;
        this._meta = meta;
        if (this._meta != null) {
            this._abstract = Modifier.isAbstract(this._meta.getDescribedType().getModifiers());
            this._fields = ApplicationIdTool.getDeclaredPrimaryKeyFields(this._meta);
        }
    }

    private static FieldMetaData[] getDeclaredPrimaryKeyFields(ClassMetaData meta) {
        if (meta.getPCSuperclass() == null) {
            return meta.getPrimaryKeyFields();
        }
        FieldMetaData[] fields = meta.getPrimaryKeyFields();
        ArrayList<FieldMetaData> decs = new ArrayList<FieldMetaData>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getDeclaringType() != meta.getDescribedType()) continue;
            decs.add(fields[i]);
        }
        return decs.toArray(new FieldMetaData[decs.size()]);
    }

    public boolean getIgnoreErrors() {
        return this._ignore;
    }

    public void setIgnoreErrors(boolean ignore) {
        this._ignore = ignore;
    }

    public CodeFormat getCodeFormat() {
        return this._format;
    }

    public void setCodeFormat(CodeFormat format) {
        this._format = format;
    }

    public File getDirectory() {
        return this._dir;
    }

    public void setDirectory(File dir) {
        this._dir = dir;
    }

    public String getToken() {
        return this._token;
    }

    public void setToken(String token) {
        this._token = token;
    }

    public Writer getWriter() {
        return this._writer;
    }

    public void setWriter(Writer writer) {
        this._writer = writer;
    }

    public Class getType() {
        return this._type;
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public String getCode() {
        return this._code;
    }

    public boolean isInnerClass() {
        Class oidClass = this._meta.getObjectIdType();
        return oidClass.getName().indexOf(36) != -1;
    }

    private String getClassName() {
        if (this._meta.isOpenJPAIdentity()) {
            return null;
        }
        String className = Strings.getClassName((Class)this._meta.getObjectIdType());
        if (this.isInnerClass()) {
            className = className.substring(className.lastIndexOf(36) + 1);
        }
        return className;
    }

    public boolean run() {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)_loc.get("appid-start", (Object)this._type));
        }
        if (this._meta == null || this._meta.getIdentityType() != 2 || this._meta.isOpenJPAIdentity()) {
            if (!this._ignore) {
                throw new UserException(_loc.get("appid-invalid", (Object)this._type));
            }
            if (this._log.isWarnEnabled()) {
                this._log.warn((Object)_loc.get("appid-warn", (Object)this._type));
            }
            return false;
        }
        Class oidClass = this._meta.getObjectIdType();
        Class superOidClass = null;
        if (this._meta.getPCSuperclass() != null) {
            superOidClass = this._meta.getPCSuperclassMetaData().getObjectIdType();
            if (oidClass == null || oidClass.equals(superOidClass)) {
                if (this._log.isWarnEnabled()) {
                    this._log.warn((Object)_loc.get("appid-warn", (Object)this._type));
                }
                return false;
            }
        }
        if (oidClass == null) {
            throw new UserException(_loc.get("no-id-class", (Object)this._type)).setFatal(true);
        }
        boolean bytes = false;
        for (int i = 0; !bytes && i < this._fields.length; ++i) {
            bytes = this._fields[i].getDeclaredType() == (array$B == null ? ApplicationIdTool.class$("[B") : array$B);
        }
        String className = this.getClassName();
        String packageName = Strings.getPackageName((Class)oidClass);
        String packageDec = "";
        if (packageName.length() > 0) {
            packageDec = "package " + packageName + ";";
        }
        String imports = this.getImports();
        String fieldDecs = this.getFieldDeclarations();
        String constructor = this.getConstructor(superOidClass != null);
        String properties = this.getProperties();
        String fromStringCode = this.getFromStringCode(superOidClass != null);
        String toStringCode = this.getToStringCode(superOidClass != null);
        String equalsCode = this.getEqualsCode(superOidClass != null);
        String hashCodeCode = this.getHashCodeCode(superOidClass != null);
        CodeFormat code = this.newCodeFormat();
        if (!this.isInnerClass() && packageDec.length() > 0) {
            code.append((Object)packageDec).afterSection();
        }
        if (!this.isInnerClass() && imports.length() > 0) {
            code.append((Object)imports).afterSection();
        }
        code.append((Object)"/**").endl().append((Object)" * ").append((Object)_loc.get("appid-comment-for", (Object)this._type.getName())).endl().append((Object)" *").endl().append((Object)" * ").append((Object)_loc.get("appid-comment-gen")).endl().append((Object)" * ").append((Object)this.getClass().getName()).endl().append((Object)" */").endl();
        code.append((Object)"public ");
        if (this.isInnerClass()) {
            code.append((Object)"static ");
        }
        code.append((Object)"class ").append((Object)className);
        if (code.getBraceOnSameLine()) {
            code.append((Object)" ");
        } else {
            code.endl().tab();
        }
        if (superOidClass != null) {
            code.append((Object)("extends " + Strings.getClassName((Class)superOidClass)));
            if (code.getBraceOnSameLine()) {
                code.append((Object)" ");
            } else {
                code.endl().tab();
            }
        }
        code.append((Object)"implements Serializable").openBrace(1).endl();
        if (bytes) {
            code.tab().append((Object)"private static final char[] HEX = ").append((Object)"new char[] {").endl();
            code.tab(2).append((Object)"'0', '1', '2', '3', '4', '5', '6', '7',").endl();
            code.tab(2).append((Object)"'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'").endl();
            code.tab().append((Object)"};").endl(2);
        }
        code.tab().append((Object)"static").openBrace(2).endl();
        code.tab(2).append((Object)"// register persistent class in JVM").endl();
        if (JavaVersions.VERSION >= 5) {
            code.tab(2).append((Object)"try { Class.forName").openParen(true).append((Object)"\"").append((Object)this._type.getName()).append((Object)"\"").closeParen().append((Object)";").append((Object)" }").endl();
            code.tab(2).append((Object)"catch").openParen(true).append((Object)"Exception e").closeParen().append((Object)" {}").endl();
        } else {
            code.tab(2).append((Object)"Class c = ").append((Object)this._type.getName()).append((Object)".class;").endl();
        }
        code.closeBrace(2);
        if (fieldDecs.length() > 0) {
            code.endl(2).append((Object)fieldDecs);
        }
        code.afterSection().tab().append((Object)"public ").append((Object)className).parens().openBrace(2).endl();
        code.closeBrace(2);
        code.afterSection().append((Object)constructor);
        if (properties.length() > 0) {
            code.afterSection().append((Object)properties);
        }
        if (toStringCode.length() > 0) {
            code.afterSection().append((Object)toStringCode);
        }
        if (hashCodeCode.length() > 0) {
            code.afterSection().append((Object)hashCodeCode);
        }
        if (equalsCode.length() > 0) {
            code.afterSection().append((Object)equalsCode);
        }
        if (fromStringCode.length() > 0) {
            code.afterSection().append((Object)fromStringCode);
        }
        if (bytes) {
            code.afterSection().append((Object)this.getToBytesByteArrayCode());
            code.afterSection().append((Object)this.getToStringByteArrayCode());
            code.afterSection().append((Object)this.getEqualsByteArrayCode());
            code.afterSection().append((Object)this.getHashCodeByteArrayCode());
        }
        if (superOidClass == null && this.getTokenizer(false) == TOKENIZER_CUSTOM) {
            code.afterSection().append((Object)this.getCustomTokenizerClass());
        }
        code.endl();
        code.closeBrace(1);
        this._code = code.toString();
        if (this.isInnerClass()) {
            this._code = code.getTab() + Strings.replace((String)this._code, (String)J2DoPrivHelper.getLineSeparator(), (String)(J2DoPrivHelper.getLineSeparator() + code.getTab()));
        }
        return true;
    }

    public void record() throws IOException {
        if (this._code == null) {
            return;
        }
        Writer writer = this._writer;
        if (writer == null) {
            File file = this.getFile();
            Files.backup((File)file, (boolean)false);
            writer = new FileWriter(file);
        }
        PrintWriter printer = new PrintWriter(writer);
        printer.print(this._code);
        printer.flush();
        if (this._writer == null) {
            writer.close();
        }
    }

    private String getImports() {
        Set pkgs = this.getImportPackages();
        CodeFormat imports = this.newCodeFormat();
        String base = Strings.getPackageName((Class)this._meta.getObjectIdType());
        Iterator itr = pkgs.iterator();
        while (itr.hasNext()) {
            String pkg = (String)itr.next();
            if (pkg.length() <= 0 || "java.lang".equals(pkg) || base.equals(pkg)) continue;
            if (imports.length() > 0) {
                imports.endl();
            }
            imports.append((Object)"import ").append((Object)pkg).append((Object)".*;");
        }
        return imports.toString();
    }

    public Set getImportPackages() {
        TreeSet<String> pkgs = new TreeSet<String>();
        pkgs.add(Strings.getPackageName((Class)this._type));
        Class superOidClass = null;
        if (this._meta != null && this._meta.getPCSuperclassMetaData() != null) {
            superOidClass = this._meta.getPCSuperclassMetaData().getObjectIdType();
        }
        if (superOidClass != null) {
            pkgs.add(Strings.getPackageName(superOidClass));
        }
        pkgs.add("java.io");
        pkgs.add("java.util");
        for (int i = 0; i < this._fields.length; ++i) {
            Class type = this._fields[i].getObjectIdFieldType();
            if (type == (array$B == null ? ApplicationIdTool.class$("[B") : array$B) || type == (array$C == null ? ApplicationIdTool.class$("[C") : array$C) || type.getName().startsWith("java.sql.")) continue;
            pkgs.add(Strings.getPackageName((Class)type));
        }
        return pkgs;
    }

    private String getFieldDeclarations() {
        CodeFormat code = this.newCodeFormat();
        for (int i = 0; i < this._fields.length; ++i) {
            if (i > 0) {
                code.endl();
            }
            code.tab().append((Object)"public ").append((Object)this.getTypeName(this._fields[i])).append((Object)" ").append((Object)this._fields[i].getName()).append((Object)";");
        }
        return code.toString();
    }

    private String getTypeName(FieldMetaData fmd) {
        Class type = fmd.getObjectIdFieldType();
        if (type == [B.class) {
            return "byte[]";
        }
        if (type == [C.class) {
            return "char[]";
        }
        if (type.getName().startsWith("java.sql.")) {
            return type.getName();
        }
        return Strings.getClassName((Class)type);
    }

    private String getProperties() {
        if (this._meta.getAccessType() == 2) {
            return "";
        }
        CodeFormat code = this.newCodeFormat();
        for (int i = 0; i < this._fields.length; ++i) {
            if (i > 0) {
                code.afterSection();
            }
            String typeName = this.getTypeName(this._fields[i]);
            String propName = StringUtils.capitalize((String)this._fields[i].getName());
            code.tab().append((Object)"public ").append((Object)typeName).append((Object)" ");
            if (this._fields[i].getDeclaredTypeCode() == 0 || this._fields[i].getDeclaredTypeCode() == 16) {
                code.append((Object)"is");
            } else {
                code.append((Object)"get");
            }
            code.append((Object)propName).parens().openBrace(2).endl();
            code.tab(2).append((Object)"return ").append((Object)this._fields[i].getName()).append((Object)";").endl();
            code.closeBrace(2);
            code.afterSection();
            code.tab().append((Object)"public void set").append((Object)propName);
            code.openParen(true).append((Object)typeName).append((Object)" ").append((Object)this._fields[i].getName()).closeParen();
            code.openBrace(2).endl();
            code.tab(2).append((Object)"this.").append((Object)this._fields[i].getName()).append((Object)" = ").append((Object)this._fields[i].getName()).append((Object)";").endl();
            code.closeBrace(2);
        }
        return code.toString();
    }

    private String getConstructor(boolean hasSuperclass) {
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"public ");
        code.append((Object)this.getClassName());
        code.openParen(true).append((Object)"String str").closeParen();
        code.openBrace(2).endl();
        if (this._fields.length != 0 || hasSuperclass && this._meta.getPrimaryKeyFields().length > 0) {
            code.tab(2).append((Object)"fromString").openParen(true).append((Object)"str").closeParen().append((Object)";").endl();
        }
        code.closeBrace(2);
        return code.toString();
    }

    private String getFromStringCode(boolean hasSuperclass) {
        int i;
        if (this.hasConcreteSuperclass()) {
            return "";
        }
        if (this._fields.length == 0) {
            return "";
        }
        hasSuperclass = hasSuperclass && ApplicationIdTool.getDeclaredPrimaryKeyFields(this._meta.getPCSuperclassMetaData()).length > 0;
        String toke = this.getTokenizer(hasSuperclass);
        CodeFormat code = this.newCodeFormat();
        if (this._abstract || hasSuperclass) {
            code.tab().append((Object)"protected ").append((Object)toke).append((Object)" fromString");
        } else {
            code.tab().append((Object)"private void fromString");
        }
        code.openParen(true).append((Object)"String str").closeParen();
        code.openBrace(2).endl();
        for (i = 0; i < this._fields.length; ++i) {
            if (this._fields[i].getObjectIdFieldType() != (class$java$lang$Object == null ? ApplicationIdTool.class$("java.lang.Object") : class$java$lang$Object)) continue;
            code.tab(2).append((Object)"throw new UnsupportedOperationException").parens().append((Object)";").endl();
            code.closeBrace(2);
            return code.toString();
        }
        if (toke != null) {
            code.tab(2).append((Object)toke).append((Object)" toke = ");
            if (hasSuperclass) {
                code.append((Object)"super.fromString").openParen(true).append((Object)"str").closeParen();
            } else {
                code.append((Object)"new ").append((Object)toke).openParen(true).append((Object)"str");
                if (toke == TOKENIZER_STD) {
                    code.append((Object)", \"").append((Object)this._token).append((Object)"\"");
                }
                code.closeParen();
            }
            code.append((Object)";").endl();
        }
        for (i = 0; i < this._fields.length; ++i) {
            if (toke != null) {
                code.tab(2).append((Object)"str = toke.nextToken").parens().append((Object)";").endl();
            }
            code.tab(2).append((Object)this.getConversionCode(this._fields[i], "str")).endl();
        }
        if (this._abstract || hasSuperclass) {
            code.tab(2).append((Object)"return toke;").endl();
        }
        code.closeBrace(2);
        return code.toString();
    }

    private String getTokenizer(boolean hasSuperclass) {
        if (!this._abstract && !hasSuperclass && this._fields.length == 1) {
            return null;
        }
        if (this._token.length() == 1) {
            return TOKENIZER_STD;
        }
        return TOKENIZER_CUSTOM;
    }

    private String getConversionCode(FieldMetaData field, String var) {
        CodeFormat parse = this.newCodeFormat();
        if (field.getName().equals(var)) {
            parse.append((Object)"this.");
        }
        parse.append((Object)field.getName()).append((Object)" = ");
        Class type = field.getObjectIdFieldType();
        if (type == java.util.Date.class) {
            parse.append((Object)"new Date").openParen(true).append((Object)"Long.parseLong").openParen(true).append((Object)var).closeParen().closeParen();
        } else if (type == Date.class || type == Timestamp.class || type == Time.class) {
            parse.append((Object)type.getName()).append((Object)".valueOf").openParen(true).append((Object)var).closeParen();
        } else if (type == String.class) {
            parse.append((Object)var);
        } else if (type == Character.class) {
            parse.append((Object)"new Character").openParen(true).append((Object)var).append((Object)".charAt").openParen(true).append(0).closeParen().closeParen();
        } else if (type == [B.class) {
            parse.append((Object)"toBytes").openParen(true).append((Object)var).closeParen();
        } else if (type == [C.class) {
            parse.append((Object)var).append((Object)".toCharArray").parens();
        } else if (!type.isPrimitive()) {
            parse.append((Object)"new ").append((Object)Strings.getClassName((Class)type)).openParen(true).append((Object)var).closeParen();
        } else {
            switch (type.getName().charAt(0)) {
                case 'b': {
                    if (type == Boolean.TYPE) {
                        parse.append((Object)"\"true\".equals").openParen(true).append((Object)var).closeParen();
                        break;
                    }
                    parse.append((Object)"Byte.parseByte").openParen(true).append((Object)var).closeParen();
                    break;
                }
                case 'c': {
                    parse.append((Object)var).append((Object)".charAt").openParen(true).append(0).closeParen();
                    break;
                }
                case 'd': {
                    parse.append((Object)"Double.parseDouble").openParen(true).append((Object)var).closeParen();
                    break;
                }
                case 'f': {
                    parse.append((Object)"Float.parseFloat").openParen(true).append((Object)var).closeParen();
                    break;
                }
                case 'i': {
                    parse.append((Object)"Integer.parseInt").openParen(true).append((Object)var).closeParen();
                    break;
                }
                case 'l': {
                    parse.append((Object)"Long.parseLong").openParen(true).append((Object)var).closeParen();
                    break;
                }
                case 's': {
                    parse.append((Object)"Short.parseShort").openParen(true).append((Object)var).closeParen();
                }
            }
        }
        if (!type.isPrimitive() && type != [B.class) {
            CodeFormat isNull = this.newCodeFormat();
            isNull.append((Object)"if").openParen(true).append((Object)"\"null\".equals").openParen(true).append((Object)var).closeParen().closeParen().endl().tab(3);
            if (field.getName().equals(var)) {
                isNull.append((Object)"this.");
            }
            isNull.append((Object)field.getName()).append((Object)" = null;").endl();
            isNull.tab(2).append((Object)"else").endl();
            isNull.tab(3).append((Object)parse);
            parse = isNull;
        }
        return parse.append((Object)";").toString();
    }

    private String getEqualsCode(boolean hasSuperclass) {
        if (this.hasConcreteSuperclass() || hasSuperclass && this._fields.length == 0) {
            return "";
        }
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"public boolean equals").openParen(true).append((Object)"Object obj").closeParen().openBrace(2).endl();
        code.tab(2).append((Object)"if").openParen(true).append((Object)"this == obj").closeParen().endl();
        code.tab(3).append((Object)"return true;").endl();
        String className = this.getClassName();
        if (hasSuperclass) {
            code.tab(2).append((Object)"if").openParen(true).append((Object)"!super.equals").openParen(true).append((Object)"obj").closeParen().closeParen().endl();
            code.tab(3).append((Object)"return false;").endl();
        } else {
            code.tab(2).append((Object)"if").openParen(true).append((Object)"obj == null || obj.getClass").parens().append((Object)" != ").append((Object)"getClass").parens().closeParen().endl();
            code.tab(3).append((Object)"return false;").endl();
        }
        for (int i = 0; i < this._fields.length; ++i) {
            if (i == 0) {
                code.endl().tab(2).append((Object)className).append((Object)" other = ").openParen(false).append((Object)className).closeParen().append((Object)" obj;").endl();
            }
            if (i == 0) {
                code.tab(2).append((Object)"return ");
            } else {
                code.endl().tab(3).append((Object)"&& ");
            }
            String name = this._fields[i].getName();
            Class type = this._fields[i].getObjectIdFieldType();
            if (type.isPrimitive()) {
                code.openParen(false).append((Object)name).append((Object)" == ").append((Object)"other.").append((Object)name).closeParen();
                continue;
            }
            if (type == (array$B == null ? ApplicationIdTool.class$("[B") : array$B)) {
                code.openParen(false).append((Object)"equals").openParen(true).append((Object)name).append((Object)", ").append((Object)"other.").append((Object)name).closeParen().closeParen();
                continue;
            }
            if (type == (array$C == null ? ApplicationIdTool.class$("[C") : array$C)) {
                code.append((Object)"(").openParen(false).append((Object)name).append((Object)" == null && other.").append((Object)name).append((Object)" == null").closeParen().endl();
                code.tab(3).append((Object)"|| ");
                code.openParen(false).append((Object)name).append((Object)" != null ").append((Object)"&& String.valueOf").openParen(true).append((Object)name).closeParen().append((Object)".").endl();
                code.tab(3).append((Object)"equals").openParen(true).append((Object)"String.valueOf").openParen(true).append((Object)"other.").append((Object)name).closeParen().closeParen().closeParen().append((Object)")");
                continue;
            }
            code.append((Object)"(").openParen(false).append((Object)name).append((Object)" == null && other.").append((Object)name).append((Object)" == null").closeParen().endl();
            code.tab(3).append((Object)"|| ");
            code.openParen(false).append((Object)name).append((Object)" != null ").append((Object)"&& ").append((Object)name).append((Object)".equals").openParen(true).append((Object)"other.").append((Object)name).closeParen().closeParen().append((Object)")");
        }
        if (this._fields.length == 0) {
            code.tab(2).append((Object)"return true;").endl();
        } else {
            code.append((Object)";").endl();
        }
        code.closeBrace(2);
        return code.toString();
    }

    private String getHashCodeCode(boolean hasSuperclass) {
        if (this.hasConcreteSuperclass() || hasSuperclass && this._fields.length == 0) {
            return "";
        }
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"public int hashCode").parens().openBrace(2).endl();
        if (this._fields.length == 0) {
            code.tab(2).append((Object)"return 17;").endl();
        } else if (this._fields.length == 1 && !hasSuperclass) {
            code.tab(2).append((Object)"return ");
            this.appendHashCodeCode(this._fields[0], code);
            code.append((Object)";").endl();
        } else {
            code.tab(2).append((Object)"int rs = ");
            if (hasSuperclass) {
                code.append((Object)"super.hashCode").openParen(true).closeParen().append((Object)";");
            } else {
                code.append((Object)"17;");
            }
            code.endl();
            for (int i = 0; i < this._fields.length; ++i) {
                code.tab(2).append((Object)"rs = rs * 37 + ");
                this.appendHashCodeCode(this._fields[i], code);
                code.append((Object)";").endl();
            }
            code.tab(2).append((Object)"return rs;").endl();
        }
        code.closeBrace(2);
        return code.toString();
    }

    private boolean hasConcreteSuperclass() {
        for (ClassMetaData sup = this._meta.getPCSuperclassMetaData(); sup != null; sup = sup.getPCSuperclassMetaData()) {
            if (Modifier.isAbstract(sup.getDescribedType().getModifiers())) continue;
            return true;
        }
        return false;
    }

    private void appendHashCodeCode(FieldMetaData field, CodeFormat code) {
        Class type;
        String name = field.getName();
        if ("rs".equals(name)) {
            name = "this." + name;
        }
        if ((type = field.getObjectIdFieldType()).isPrimitive()) {
            if (type == Boolean.TYPE) {
                code.append((Object)"(").openParen(false).append((Object)name).closeParen().append((Object)" ? 1 : 0").append((Object)")");
            } else if (type == Long.TYPE) {
                code.openParen(false).append((Object)"int").closeParen().append((Object)" ").openParen(false).append((Object)name).append((Object)" ^ ").openParen(false).append((Object)name).append((Object)" >>> 32").closeParen().closeParen();
            } else if (type == Double.TYPE) {
                code.openParen(false).append((Object)"int").closeParen().append((Object)" ").openParen(false).append((Object)"Double.doubleToLongBits").openParen(true).append((Object)name).closeParen().endl();
                code.tab(3).append((Object)"^ ").openParen(false).append((Object)"Double.doubleToLongBits").openParen(true).append((Object)name).closeParen().append((Object)" >>> 32").closeParen().closeParen();
            } else if (type == Float.TYPE) {
                code.append((Object)"Float.floatToIntBits").openParen(true).append((Object)name).closeParen();
            } else if (type == Integer.TYPE) {
                code.append((Object)name);
            } else {
                code.openParen(false).append((Object)"int").closeParen().append((Object)" ").append((Object)name);
            }
        } else if (type == [B.class) {
            code.append((Object)"hashCode").openParen(true).append((Object)name).closeParen();
        } else if (type == [C.class) {
            code.append((Object)"(").openParen(false).append((Object)name).append((Object)" == null").closeParen().append((Object)" ? 0 : ").append((Object)"String.valueOf").openParen(true).append((Object)name).closeParen().append((Object)".hashCode").parens().append((Object)")");
        } else {
            code.append((Object)"(").openParen(false).append((Object)name).append((Object)" == null").closeParen().append((Object)" ? 0 : ").append((Object)name).append((Object)".hashCode").parens().append((Object)")");
        }
    }

    private String getToStringCode(boolean hasSuperclass) {
        if (this.hasConcreteSuperclass() || hasSuperclass && this._fields.length == 0) {
            return "";
        }
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"public String toString").parens().openBrace(2).endl();
        String appendDelimiter = "+ \"" + this._token + "\" + ";
        for (int i = 0; i < this._fields.length; ++i) {
            if (i == 0) {
                code.tab(2).append((Object)"return ");
                if (hasSuperclass && ApplicationIdTool.getDeclaredPrimaryKeyFields(this._meta.getPCSuperclassMetaData()).length > 0) {
                    code.append((Object)"super.toString").parens();
                    code.endl().tab(3).append((Object)appendDelimiter);
                }
            } else {
                code.endl().tab(3).append((Object)appendDelimiter);
            }
            String name = this._fields[i].getName();
            Class type = this._fields[i].getObjectIdFieldType();
            if (type == (class$java$lang$String == null ? ApplicationIdTool.class$("java.lang.String") : class$java$lang$String)) {
                code.append((Object)name);
                continue;
            }
            if (type == (array$B == null ? ApplicationIdTool.class$("[B") : array$B)) {
                code.append((Object)"toString").openParen(true).append((Object)name).closeParen();
                continue;
            }
            if (type == (array$C == null ? ApplicationIdTool.class$("[C") : array$C)) {
                code.openParen(true).openParen(true).append((Object)name).append((Object)" == null").closeParen().append((Object)" ? \"null\"").append((Object)": String.valueOf").openParen(true).append((Object)name).closeParen().closeParen();
                continue;
            }
            if (type == (class$java$util$Date == null ? ApplicationIdTool.class$("java.util.Date") : class$java$util$Date)) {
                code.openParen(true).openParen(true).append((Object)name).append((Object)" == null").closeParen().append((Object)" ? \"null\"").endl().tab(4).append((Object)": String.valueOf").openParen(true).append((Object)name).append((Object)".getTime").parens().closeParen().closeParen();
                continue;
            }
            code.append((Object)"String.valueOf").openParen(true).append((Object)name).closeParen();
        }
        if (this._fields.length == 0) {
            code.tab(2).append((Object)"return \"\"");
        }
        code.append((Object)";").endl();
        code.closeBrace(2);
        return code.toString();
    }

    private String getToBytesByteArrayCode() {
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"private static byte[] toBytes").openParen(true).append((Object)"String s").closeParen().openBrace(2).endl();
        code.tab(2).append((Object)"if").openParen(true).append((Object)"\"null\".equals").openParen(true).append((Object)"s").closeParen().closeParen().endl();
        code.tab(3).append((Object)"return null;").endl(2);
        code.tab(2).append((Object)"int len = s.length").parens().append((Object)";").endl();
        code.tab(2).append((Object)"byte[] r = new byte[len / 2];").endl();
        code.tab(2).append((Object)"for").openParen(true).append((Object)"int i = 0; i < r.length; i++").closeParen().openBrace(3).endl();
        code.tab(3).append((Object)"int digit1 = s.charAt").openParen(true).append((Object)"i * 2").closeParen().append((Object)", ").append((Object)"digit2 = s.charAt").openParen(true).append((Object)"i * 2 + 1").closeParen().append((Object)";").endl();
        code.tab(3).append((Object)"if").openParen(true).append((Object)"digit1 >= '0' && digit1 <= '9'").closeParen().endl();
        code.tab(4).append((Object)"digit1 -= '0';").endl();
        code.tab(3).append((Object)"else if").openParen(true).append((Object)"digit1 >= 'A' && digit1 <= 'F'").closeParen().endl();
        code.tab(4).append((Object)"digit1 -= 'A' - 10;").endl();
        code.tab(3).append((Object)"if").openParen(true).append((Object)"digit2 >= '0' && digit2 <= '9'").closeParen().endl();
        code.tab(4).append((Object)"digit2 -= '0';").endl();
        code.tab(3).append((Object)"else if").openParen(true).append((Object)"digit2 >= 'A' && digit2 <= 'F'").closeParen().endl();
        code.tab(4).append((Object)"digit2 -= 'A' - 10;").endl(2);
        code.tab(3).append((Object)"r[i] = (byte) ").openParen(false).openParen(false).append((Object)"digit1 << 4").closeParen().append((Object)" + digit2").closeParen().append((Object)";").endl();
        code.closeBrace(3).endl();
        code.tab(2).append((Object)"return r;").endl();
        code.closeBrace(2);
        return code.toString();
    }

    private String getToStringByteArrayCode() {
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"private static String toString").openParen(true).append((Object)"byte[] b").closeParen().openBrace(2).endl();
        code.tab(2).append((Object)"if").openParen(true).append((Object)"b == null").closeParen().endl();
        code.tab(3).append((Object)"return \"null\";").endl(2);
        code.tab(2).append((Object)"StringBuffer r = new StringBuffer").openParen(true).append((Object)"b.length * 2").closeParen().append((Object)";").endl();
        code.tab(2).append((Object)"for").openParen(true).append((Object)"int i = 0; i < b.length; i++").closeParen().endl();
        code.tab(3).append((Object)"for").openParen(true).append((Object)"int j = 1; j >= 0; j--").closeParen().endl();
        code.tab(4).append((Object)"r.append").openParen(true).append((Object)"HEX[").openParen(false).append((Object)"b[i] >> ").openParen(false).append((Object)"j * 4").closeParen().closeParen().append((Object)" & 0xF]").closeParen().append((Object)";").endl();
        code.tab(2).append((Object)"return r.toString").parens().append((Object)";").endl();
        code.closeBrace(2);
        return code.toString();
    }

    private String getEqualsByteArrayCode() {
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"private static boolean equals").openParen(true).append((Object)"byte[] b1, byte[] b2").closeParen().openBrace(2).endl();
        code.tab(2).append((Object)"if").openParen(true).append((Object)"b1 == null && b2 == null").closeParen().endl();
        code.tab(3).append((Object)"return true;").endl();
        code.tab(2).append((Object)"if").openParen(true).append((Object)"b1 == null || b2 == null").closeParen().endl();
        code.tab(3).append((Object)"return false;").endl();
        code.tab(2).append((Object)"if").openParen(true).append((Object)"b1.length != b2.length").closeParen().endl();
        code.tab(3).append((Object)"return false;").endl();
        code.tab(2).append((Object)"for").openParen(true).append((Object)"int i = 0; i < b1.length; i++").closeParen().endl();
        code.tab(3).append((Object)"if").openParen(true).append((Object)"b1[i] != b2[i]").closeParen().endl();
        code.tab(4).append((Object)"return false;").endl();
        code.tab(2).append((Object)"return true;").endl();
        code.closeBrace(2);
        return code.toString();
    }

    private String getHashCodeByteArrayCode() {
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"private static int hashCode").openParen(true).append((Object)"byte[] b").closeParen().openBrace(2).endl();
        code.tab(2).append((Object)"if").openParen(true).append((Object)"b == null").closeParen().endl();
        code.tab(3).append((Object)"return 0;").endl();
        code.tab(2).append((Object)"int sum = 0;").endl();
        code.tab(2).append((Object)"for").openParen(true).append((Object)"int i = 0; i < b.length; i++").closeParen().endl();
        code.tab(3).append((Object)"sum += b[i];").endl();
        code.tab(2).append((Object)"return sum;").endl();
        code.closeBrace(2);
        return code.toString();
    }

    private String getCustomTokenizerClass() {
        CodeFormat code = this.newCodeFormat();
        code.tab().append((Object)"protected static class ").append((Object)TOKENIZER_CUSTOM).openBrace(2).endl();
        code.tab(2).append((Object)"private final String str;").endl();
        code.tab(2).append((Object)"private int last;").afterSection();
        code.tab(2).append((Object)"public Tokenizer (String str)").openBrace(3).endl();
        code.tab(3).append((Object)"this.str = str;").endl();
        code.closeBrace(3).afterSection();
        code.tab(2).append((Object)"public String nextToken ()").openBrace(3).endl();
        code.tab(3).append((Object)"int next = str.indexOf").openParen(true).append((Object)"\"").append((Object)this._token).append((Object)"\", last").closeParen().append((Object)";").endl();
        code.tab(3).append((Object)"String part;").endl();
        code.tab(3).append((Object)"if").openParen(true).append((Object)"next == -1").closeParen().openBrace(4).endl();
        code.tab(4).append((Object)"part = str.substring").openParen(true).append((Object)"last").closeParen().append((Object)";").endl();
        code.tab(4).append((Object)"last = str.length").parens().append((Object)";").endl().closeBrace(4);
        if (!code.getBraceOnSameLine()) {
            code.endl().tab(3);
        } else {
            code.append((Object)" ");
        }
        code.append((Object)"else").openBrace(4).endl();
        code.tab(4).append((Object)"part = str.substring").openParen(true).append((Object)"last, next").closeParen().append((Object)";").endl();
        code.tab(4).append((Object)"last = next + ").append(this._token.length()).append((Object)";").endl().closeBrace(4).endl();
        code.tab(3).append((Object)"return part;").endl();
        code.closeBrace(3);
        code.endl().closeBrace(2);
        return code.toString();
    }

    private File getFile() {
        if (this._meta == null) {
            return null;
        }
        String packageName = Strings.getPackageName((Class)this._meta.getObjectIdType());
        String fileName = Strings.getClassName((Class)this._meta.getObjectIdType()) + ".java";
        File dir = null;
        if (this._dir == null && Strings.getPackageName((Class)this._type).equals(packageName) && (dir = Files.getSourceFile((Class)this._type)) != null) {
            dir = dir.getParentFile();
        }
        if (dir == null) {
            dir = Files.getPackageFile((File)this._dir, (String)packageName, (boolean)true);
        }
        return new File(dir, fileName);
    }

    private CodeFormat newCodeFormat() {
        return this._format == null ? new CodeFormat() : (CodeFormat)this._format.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Options opts = new Options();
        args = opts.setFromCmdLine(args);
        OpenJPAConfigurationImpl conf = new OpenJPAConfigurationImpl();
        try {
            if (!ApplicationIdTool.run(conf, args, opts)) {
                System.err.println(_loc.get("appid-usage"));
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            conf.close();
            throw throwable;
        }
        conf.close();
    }

    public static boolean run(OpenJPAConfiguration conf, String[] args, Options opts) throws IOException, ClassNotFoundException {
        if (opts.containsKey((Object)"help") || opts.containsKey((Object)"-help")) {
            return false;
        }
        Flags flags = new Flags();
        flags.ignoreErrors = opts.removeBooleanProperty("ignoreErrors", "i", flags.ignoreErrors);
        flags.directory = Files.getFile((String)opts.removeProperty("directory", "d", null), null);
        flags.token = opts.removeProperty("token", "t", flags.token);
        flags.name = opts.removeProperty("name", "n", flags.name);
        flags.suffix = opts.removeProperty("suffix", "s", flags.suffix);
        Options formatOpts = new Options();
        Iterator itr = opts.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = (Map.Entry)itr.next();
            String key = (String)entry.getKey();
            if (key.startsWith("codeFormat.")) {
                formatOpts.put((Object)key.substring(11), entry.getValue());
                itr.remove();
                continue;
            }
            if (!key.startsWith("cf.")) continue;
            formatOpts.put((Object)key.substring(3), entry.getValue());
            itr.remove();
        }
        if (!formatOpts.isEmpty()) {
            flags.format = new CodeFormat();
            formatOpts.setInto((Object)flags.format);
        }
        Configurations.populateConfiguration((Configuration)conf, (Options)opts);
        ClassLoader loader = conf.getClassResolverInstance().getClassLoader(ApplicationIdTool.class, null);
        return ApplicationIdTool.run(conf, args, flags, loader);
    }

    public static boolean run(OpenJPAConfiguration conf, String[] args, Flags flags, ClassLoader loader) throws IOException, ClassNotFoundException {
        HashSet<Class> classes;
        MetaDataRepository repos = conf.newMetaDataRepositoryInstance();
        repos.setValidate(0, true);
        ApplicationIdTool.loadObjectIds(repos, flags.name == null && flags.suffix == null);
        Log log = conf.getLog("openjpa.Tool");
        if (args.length == 0) {
            log.info((Object)_loc.get("running-all-classes"));
            classes = repos.loadPersistentTypes(true, loader);
        } else {
            ClassArgParser cap = conf.getMetaDataRepositoryInstance().getMetaDataFactory().newClassArgParser();
            cap.setClassLoader(loader);
            classes = new HashSet<Class>();
            for (int i = 0; i < args.length; ++i) {
                classes.addAll(Arrays.asList(cap.parseTypes(args[i])));
            }
        }
        if (flags.name != null && classes.size() > 1) {
            throw new UserException(_loc.get("name-mult-args", classes));
        }
        BCClassLoader bc = (BCClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newBCClassLoaderAction((Project)new Project()));
        Iterator itr = classes.iterator();
        while (itr.hasNext()) {
            Class cls = (Class)itr.next();
            log.info((Object)_loc.get("appid-running", (Object)cls));
            ClassMetaData meta = repos.getMetaData(cls, null, false);
            ApplicationIdTool.setObjectIdType(meta, flags, bc);
            ApplicationIdTool tool = new ApplicationIdTool(conf, cls, meta);
            tool.setDirectory(flags.directory);
            tool.setIgnoreErrors(flags.ignoreErrors);
            tool.setToken(flags.token);
            tool.setCodeFormat(flags.format);
            if (tool.run()) {
                log.info((Object)_loc.get("appid-output", (Object)tool.getFile()));
                tool.record();
                continue;
            }
            log.info((Object)_loc.get("appid-norun"));
        }
        bc.getProject().clear();
        return true;
    }

    private static void setObjectIdType(ClassMetaData meta, Flags flags, BCClassLoader bc) throws ClassNotFoundException {
        if (meta == null || meta.getObjectIdType() != null && (!meta.isOpenJPAIdentity() || flags.name == null) || ApplicationIdTool.getDeclaredPrimaryKeyFields(meta).length == 0) {
            return;
        }
        Class desc = meta.getDescribedType();
        Class cls = null;
        if (flags.name != null) {
            cls = ApplicationIdTool.loadClass(desc, flags.name, bc);
        } else if (flags.suffix != null) {
            cls = ApplicationIdTool.loadClass(desc, desc.getName() + flags.suffix, bc);
        }
        meta.setObjectIdType(cls, false);
    }

    private static Class loadClass(Class context, String name, BCClassLoader bc) throws ClassNotFoundException {
        ClassLoader loader;
        if (name.indexOf(46) == -1 && context.getName().indexOf(46) != -1) {
            name = Strings.getPackageName((Class)context) + "." + name;
        }
        if ((loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction((Class)context))) == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        try {
            return Class.forName(name, false, loader);
        }
        catch (Throwable t) {
            BCClass oid = bc.getProject().loadClass(name, null);
            oid.addDefaultConstructor();
            return Class.forName(name, false, (ClassLoader)bc);
        }
    }

    private static void loadObjectIds(MetaDataRepository repos, boolean fatal) {
        MetaDataFactory mdf = repos.getMetaDataFactory();
        if (mdf instanceof DelegatingMetaDataFactory) {
            mdf = ((DelegatingMetaDataFactory)mdf).getInnermostDelegate();
        }
        if (mdf instanceof ObjectIdLoader) {
            ((ObjectIdLoader)((Object)mdf)).setLoadObjectIds();
        } else if (fatal) {
            throw new InvalidStateException(_loc.get("factory-not-oidloader")).setFatal(true);
        }
    }

    public static interface ObjectIdLoader {
        public void setLoadObjectIds();
    }

    public static class Flags {
        public File directory = null;
        public boolean ignoreErrors = true;
        public String token = "::";
        public CodeFormat format = null;
        public String name = null;
        public String suffix = null;
    }
}

