/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Raw;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.Literal;

public class Lit
extends Const
implements Literal {
    private static final long serialVersionUID = 1L;
    private Object _val;
    private int _ptype;
    private boolean _isRaw;

    public Lit(Object val, int ptype) {
        this._val = val;
        this._ptype = ptype;
        if (this._ptype == 8 || this._ptype == 9 || this._ptype == 10) {
            this._isRaw = true;
        }
    }

    public Class getType() {
        if (this._val == null) {
            return Object.class;
        }
        return this._val.getClass();
    }

    public void setImplicitType(Class type) {
        this._val = Filters.convert((Object)this._val, (Class)type);
    }

    public int getParseType() {
        return this._ptype;
    }

    public Object getValue() {
        return this._val;
    }

    public void setValue(Object val) {
        this._val = val;
    }

    public Object getValue(Object[] params) {
        return this.getValue();
    }

    public boolean isRaw() {
        return this._isRaw;
    }

    public void setRaw(boolean isRaw) {
        this._isRaw = isRaw;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return new LitExpState();
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        super.calculateValue(sel, ctx, state, other, otherState);
        LitExpState lstate = (LitExpState)state;
        if (other != null) {
            lstate.sqlValue = other.toDataStoreValue(sel, ctx, otherState, this._val);
            lstate.otherLength = other.length(sel, ctx, otherState);
        } else {
            lstate.sqlValue = this._val;
        }
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        Object useLiteral;
        LitExpState lstate = (LitExpState)state;
        if (lstate.otherLength > 1) {
            sql.appendValue(((Object[])lstate.sqlValue)[index], lstate.getColumn(index));
            return;
        }
        if (this._isRaw) {
            int parseType = this.getParseType();
            if (parseType == 4 || parseType == 3) {
                lstate.sqlValue = new Raw("'" + this._val.toString() + "'");
            } else if (parseType == 2) {
                Boolean boolVal = (Boolean)this._val;
                Object dbRepresentation = ctx.store.getDBDictionary().getBooleanRepresentation().getRepresentation(boolVal);
                lstate.sqlValue = dbRepresentation instanceof String ? new Raw("'" + dbRepresentation.toString() + "'") : (dbRepresentation instanceof Boolean || dbRepresentation instanceof Integer ? new Raw(dbRepresentation.toString()) : this._val);
            } else if (parseType == 6) {
                StringBuilder value = new StringBuilder();
                boolean isOrdinal = false;
                if (lstate.sqlValue instanceof Integer) {
                    isOrdinal = true;
                }
                if (!isOrdinal) {
                    value.append("'");
                }
                value.append(lstate.sqlValue);
                if (!isOrdinal) {
                    value.append("'");
                }
                lstate.sqlValue = new Raw(value.toString());
            } else {
                lstate.sqlValue = parseType == 8 || parseType == 9 || parseType == 10 ? new Raw(this._val.toString()) : (parseType == 1 ? new Raw(this._val.toString()) : new Raw((String)(this._val instanceof String ? "'" + String.valueOf(this._val) + "'" : this._val.toString())));
            }
        }
        boolean useParamToken = (useLiteral = ctx.fetch.getHint("openjpa.hint.UseLiteralInSQL")) != null ? !((Boolean)useLiteral).booleanValue() : true;
        sql.appendValue(lstate.sqlValue, lstate.getColumn(index), null, useParamToken);
    }

    private static class LitExpState
    extends Const.ConstExpState {
        public Object sqlValue;
        public int otherLength;

        private LitExpState() {
        }
    }
}

