/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.DateTimeExtractField;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;

public class ExtractDateTimeField
extends AbstractVal {
    private static final long serialVersionUID = 1L;
    private final Val _val;
    private final DateTimeExtractField _field;
    private ClassMetaData _meta = null;

    public ExtractDateTimeField(Val val, DateTimeExtractField field) {
        this._val = val;
        this._field = field;
    }

    public Val getVal() {
        return this._val;
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    public Class getType() {
        return this._field == DateTimeExtractField.SECOND ? Float.TYPE : Integer.TYPE;
    }

    public void setImplicitType(Class type) {
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState valueState = this._val.initialize(sel, ctx, 0);
        return new ExtractDateTimeFieldExpState(valueState.joins, valueState);
    }

    @Override
    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        sel.select(this.newSQLBuffer(sel, ctx, state), (Object)this);
    }

    @Override
    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        ExtractDateTimeFieldExpState edtstate = (ExtractDateTimeFieldExpState)state;
        this._val.selectColumns(sel, ctx, edtstate.valueState, true);
    }

    @Override
    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
        sel.groupBy(this.newSQLBuffer(sel, ctx, state));
    }

    @Override
    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
        sel.orderBy(this.newSQLBuffer(sel, ctx, state), asc, false, this.getSelectAs());
    }

    private SQLBuffer newSQLBuffer(Select sel, ExpContext ctx, ExpState state) {
        this.calculateValue(sel, ctx, state, null, null);
        SQLBuffer buf = new SQLBuffer(ctx.store.getDBDictionary());
        this.appendTo(sel, ctx, state, buf, 0);
        return buf;
    }

    @Override
    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        return Filters.convert((Object)res.getObject(this, 1012, null), (Class)this.getType());
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        ExtractDateTimeFieldExpState edtstate = (ExtractDateTimeFieldExpState)state;
        this._val.calculateValue(sel, ctx, edtstate.valueState, null, null);
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        DBDictionary dict = ctx.store.getDBDictionary();
        String func = dict.extractDateTimeFieldFunction;
        int fieldPart = func.indexOf("{0}");
        int fromPart = func.indexOf("{1}");
        String part1 = func.substring(0, fieldPart);
        String part2 = func.substring(fieldPart + 3, fromPart);
        String part3 = func.substring(fromPart + 3);
        ExtractDateTimeFieldExpState edtstate = (ExtractDateTimeFieldExpState)state;
        sql.append(part1);
        sql.append(this._field.name());
        sql.append(part2);
        this._val.appendTo(sel, ctx, edtstate.valueState, sql, 0);
        sql.append(part3);
    }

    @Override
    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter((Value)this);
        this._val.acceptVisit(visitor);
        visitor.exit((Value)this);
    }

    @Override
    public int getId() {
        return 24;
    }

    private static class ExtractDateTimeFieldExpState
    extends ExpState {
        public final ExpState valueState;

        public ExtractDateTimeFieldExpState(Joins joins, ExpState valueState) {
            super(joins);
            this.valueState = valueState;
        }
    }
}

