/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.XROP;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.StoredProcedure;
import org.apache.openjpa.kernel.AbstractStoreQuery;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MultiQueryMetaData;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.util.InternalException;

public class StoredProcedureQuery
extends AbstractStoreQuery {
    private static final long serialVersionUID = 1L;
    private static final Object[] NO_PARAM = new Object[0];
    JDBCStore _store;
    StoredProcedure _proc;
    private MultiQueryMetaData _meta;

    public StoredProcedureQuery(JDBCStore store) {
        this._store = store;
    }

    public int getOperation() {
        return 1;
    }

    public StoredProcedure getProcedure() {
        return this._proc;
    }

    public DBDictionary getDictionary() {
        return this._store.getDBDictionary();
    }

    public boolean setQuery(Object meta) {
        if (meta == null || meta instanceof MultiQueryMetaData) {
            this._meta = (MultiQueryMetaData)meta;
            return true;
        }
        throw new InternalException("Unknown " + String.valueOf(meta));
    }

    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subclasses) {
        List parts;
        ArrayList<QueryResultMapping> mappings = null;
        ArrayList<Class> classes = null;
        if (this._meta != null && (parts = this._meta.getComponents()) != null && !parts.isEmpty()) {
            mappings = new ArrayList<QueryResultMapping>();
            classes = new ArrayList<Class>();
            MappingRepository repos = this._store.getConfiguration().getMappingRepositoryInstance();
            for (QueryMetaData part : parts) {
                QueryResultMapping mapping = repos.getQueryResultMapping(this.ctx.getResultMappingScope(), part.getResultSetMappingName(), null, true);
                if (mapping != null) {
                    mappings.add(mapping);
                }
                if (part.getResultType() == null) continue;
                classes.add(part.getResultType());
            }
        }
        return new StoredProcedureQueryExecutor(this, mappings, classes);
    }

    public boolean supportsParameterDeclarations() {
        return false;
    }

    public boolean supportsDataStoreExecution() {
        return true;
    }

    public boolean requiresCandidateType() {
        return false;
    }

    public boolean requiresParameterDeclarations() {
        return false;
    }

    public class StoredProcedureQueryExecutor
    extends AbstractStoreQuery.AbstractExecutor {
        private final List<Class<?>> _resultClasses;
        private final List<QueryResultMapping> _resultMappings;

        public StoredProcedureQueryExecutor(StoredProcedureQuery q, List<QueryResultMapping> resultMapping, List<Class<?>> classes) {
            QueryContext ctx = q.getContext();
            this._resultMappings = resultMapping;
            this._resultClasses = classes;
            String procName = ctx.getQueryString();
            StoredProcedureQuery.this._proc = this.getStoredProcedure(StoredProcedureQuery.this._store.getConnection(), StoredProcedureQuery.this._store.getDBDictionary(), procName);
            if (StoredProcedureQuery.this._proc == null) {
                throw new RuntimeException("Can not find stored procedure " + procName);
            }
        }

        StoredProcedure getStoredProcedure(Connection conn, DBDictionary dict, String procedureName) {
            try {
                StoredProcedure sp = dict.getStoredProcedure(conn.getMetaData(), null, null, procedureName);
                if (sp != null) {
                    StoredProcedure storedProcedure = sp;
                    return storedProcedure;
                }
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
            throw new RuntimeException("Procedure [" + procedureName + "] not found");
        }

        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            try {
                DBDictionary dict = StoredProcedureQuery.this._store.getDBDictionary();
                Connection conn = StoredProcedureQuery.this._store.getConnection();
                CallableStatement stmnt = conn.prepareCall(StoredProcedureQuery.this._proc.getCallSQL());
                StoredProcedureQuery spq = (StoredProcedureQuery)((Object)StoredProcedureQuery.class.cast(q));
                for (Column c : spq.getProcedure().getInColumns()) {
                    dict.setUnknown((PreparedStatement)stmnt, c.getIndex() + 1, params[c.getIndex()], c);
                }
                for (Column c : spq.getProcedure().getInOutColumns()) {
                    int index = c.getIndex() + 1;
                    stmnt.registerOutParameter(index, c.getType());
                    dict.setUnknown((PreparedStatement)stmnt, index, params[index - 1], c);
                }
                for (Column c : spq.getProcedure().getOutColumns()) {
                    stmnt.registerOutParameter(c.getIndex() + 1, c.getType());
                }
                JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)q.getContext().getFetchConfiguration();
                XROP rop = new XROP(this._resultMappings, this._resultClasses, StoredProcedureQuery.this._store, fetch, stmnt);
                rop.open();
                return rop;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object[] toParameterArray(StoreQuery q, Map<?, ?> userParams) {
            if (userParams == null) {
                return NO_PARAM;
            }
            Object[] array = new Object[userParams.size()];
            int i = 0;
            StoredProcedureQuery storedProcedureQuery = (StoredProcedureQuery)((Object)StoredProcedureQuery.class.cast(q));
            Iterator iterator = Arrays.asList(storedProcedureQuery.getProcedure().getInColumns(), storedProcedureQuery.getProcedure().getInOutColumns()).iterator();
            while (iterator.hasNext()) {
                Column[] columns;
                for (Column c : columns = (Column[])iterator.next()) {
                    array[i] = userParams.get(c.getIdentifier().getName());
                    if (array[i++] != null) continue;
                    userParams.get(c.getIndex());
                }
            }
            return array;
        }
    }
}

